/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.forkjoin;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.CollectionAssertions;

public class MultipleForksTest
extends JbpmTestCase {
    public void testConcurrencyGraphBased() {
        this.deployJpdlXmlString("<process name='ConcurrencyGraphBased'>  <start>    <transition to='fork'/>  </start>  <fork name='fork'>    <transition to='fork2' />    <transition to='send invoice' />  </fork>  <fork name='fork2'>    <transition to='load truck'/>    <transition to='print shipping documents' />  </fork>  <state name='send invoice'>    <transition to='final join' />  </state>  <state name='load truck'>    <transition to='shipping join' />  </state>  <state name='print shipping documents'>    <transition to='shipping join' />  </state>  <join name='shipping join'>    <transition to='drive truck to destination'/>  </join>  <state name='drive truck to destination'>    <transition to='final join' />  </state>  <join name='final join'>    <transition to='end'/>  </join>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ConcurrencyGraphBased");
        String pid = processInstance.getId();
        HashSet<String> expectedActivityNames = new HashSet<String>();
        expectedActivityNames.add("send invoice");
        expectedActivityNames.add("load truck");
        expectedActivityNames.add("print shipping documents");
        MultipleForksTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        MultipleForksTest.assertNotNull((Object)processInstance.findActiveExecutionIn("send invoice"));
        MultipleForksTest.assertNotNull((Object)processInstance.findActiveExecutionIn("load truck"));
        MultipleForksTest.assertNotNull((Object)processInstance.findActiveExecutionIn("print shipping documents"));
        String sendInvoiceExecutionId = processInstance.findActiveExecutionIn("send invoice").getId();
        processInstance = this.executionService.signalExecutionById(sendInvoiceExecutionId);
        expectedActivityNames.remove("send invoice");
        MultipleForksTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        MultipleForksTest.assertNotNull((Object)processInstance.findActiveExecutionIn("load truck"));
        MultipleForksTest.assertNotNull((Object)processInstance.findActiveExecutionIn("print shipping documents"));
        String loadTruckExecutionId = processInstance.findActiveExecutionIn("load truck").getId();
        processInstance = this.executionService.signalExecutionById(loadTruckExecutionId);
        expectedActivityNames.remove("load truck");
        MultipleForksTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        MultipleForksTest.assertNotNull((Object)processInstance.findActiveExecutionIn("print shipping documents"));
        String printShippingDocumentsId = processInstance.findActiveExecutionIn("print shipping documents").getId();
        processInstance = this.executionService.signalExecutionById(printShippingDocumentsId);
        expectedActivityNames.remove("print shipping documents");
        expectedActivityNames.add("drive truck to destination");
        MultipleForksTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        MultipleForksTest.assertNotNull((Object)processInstance.findActiveExecutionIn("drive truck to destination"));
        String driveTruckExecutionId = processInstance.findActiveExecutionIn("drive truck to destination").getId();
        processInstance = this.executionService.signalExecutionById(driveTruckExecutionId);
        MultipleForksTest.assertNull((String)("execution " + pid + " should not exist"), (Object)this.executionService.findExecutionById(pid));
    }

    public void testNestedForks() {
        this.deployJpdlXmlString("<process name='nestedForks'>  <start>    <transition to='outerFork' />  </start>  <fork name='outerFork'>    <transition to='passthrough1' />    <transition to='passthrough2' />    <transition to='wait' />  </fork>  <state name='wait'>    <transition to='outerJoin' />  </state>  <passthrough name='passthrough1'>    <transition to='innerJoin' />  </passthrough>  <passthrough name='passthrough2'>    <transition to='innerJoin' />  </passthrough>  <join name='innerJoin'>    <transition to='innerFork' />  </join>  <fork name='innerFork' >    <transition to='passthrough3'/>    <transition to='passthrough4'/>    <transition to='passthrough5'/>  </fork>  <passthrough name='passthrough3'>    <transition to='outerJoin' />  </passthrough>  <passthrough name='passthrough4'>    <transition to='outerJoin' />  </passthrough>  <passthrough name='passthrough5'>    <transition to='outerJoin' />  </passthrough>  <join name='outerJoin'>    <transition to='theEnd' />  </join>  <end name='theEnd' /></process>");
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("nestedForks");
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), Arrays.asList("wait"));
        this.executionService.signalExecutionById(pi.findActiveExecutionIn("wait").getId());
        this.assertProcessInstanceEnded(pi);
    }
}

