/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn;

import java.util.Arrays;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.task.Task;
import org.jbpm.bpmn.parser.BpmnParser;
import org.jbpm.pvm.internal.xml.Problem;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.CollectionAssertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelGatewayTest
extends JbpmTestCase {
    static BpmnParser bpmnParser = new BpmnParser();

    public List<Problem> parse(String resource) {
        List problems = bpmnParser.createParse().setResource(resource).execute().getProblems();
        return problems;
    }

    public void testNormalParse() {
        List<Problem> problems = this.parse("org/jbpm/bpmn/parallelGateway.bpmn.xml");
        if (!problems.isEmpty()) {
            ParallelGatewayTest.fail((String)("No problems should have occured. Problems: " + problems));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalExecute() {
        String deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/bpmn/parallelGateway.bpmn.xml").deploy();
        try {
            ProcessInstance pi = this.executionService.startProcessInstanceByKey("ParallelGateway");
            String pid = pi.getId();
            TaskQuery taskQuery = this.taskService.createTaskQuery();
            List allTasks = taskQuery.list();
            ParallelGatewayTest.assertEquals((int)2, (int)allTasks.size());
            CollectionAssertions.assertContainsSameElements(Arrays.asList("UserTaskLeg1", "UserTaskLeg2"), Arrays.asList(((Task)allTasks.get(0)).getActivityName(), ((Task)allTasks.get(1)).getActivityName()));
            this.taskService.completeTask(((Task)allTasks.get(0)).getId());
            pi = this.executionService.findProcessInstanceById(pid);
            ParallelGatewayTest.assertNotNull((Object)pi);
            this.taskService.completeTask(((Task)allTasks.get(1)).getId());
            ParallelGatewayTest.assertEquals((int)0, (int)taskQuery.list().size());
            pi = this.executionService.findProcessInstanceById(pid);
            ParallelGatewayTest.assertNull((Object)pi);
        }
        finally {
            this.repositoryService.deleteDeploymentCascade(deploymentId);
        }
    }

    public void testInvalid() {
        List<Problem> problems = this.parse("org/jbpm/bpmn/parallelGatewayInvalid.bpmn.xml");
        if (problems == null || problems.isEmpty()) {
            ParallelGatewayTest.fail((String)"expected problems during parse");
        } else {
            this.assertTextPresent("parallelGateway 'The Fork' has the wrong number of incomming (1) and outgoing (2) transitions for gatewayDirection='converging'", problems.get(0).getMsg());
        }
    }
}

