/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jbpm.Configuration;
import org.jbpm.env.Environment;
import org.jbpm.env.EnvironmentFactory;
import org.jbpm.log.Jdk14LogFactory;
import org.jbpm.log.Log;
import org.jbpm.log.LogFormatter;

public abstract class JbpmTestCase
extends TestCase {
    protected static Log log;

    protected void setUp() throws Exception {
        JbpmTestCase.assertNull((Object)Environment.getCurrent());
        LogFormatter.resetIndentation();
        log.info("=== starting " + this.getName() + " =============================");
    }

    protected void tearDown() throws Exception {
        log.info("=== ending " + this.getName() + " =============================\n");
        JbpmTestCase.assertNull((Object)Environment.getCurrent());
    }

    public void assertTextPresent(String expected, String value) {
        if (value == null || value.indexOf(expected) == -1) {
            JbpmTestCase.fail((String)("expected presence of '" + expected + "' but was '" + value + "'"));
        }
    }

    public static Environment openEnvironment(String xmlString) {
        EnvironmentFactory environmentFactory = (EnvironmentFactory)new Configuration().setXmlString(xmlString).buildProcessEngine();
        return environmentFactory.openEnvironment();
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (AssertionFailedError e) {
            log.error("");
            log.error("ASSERTION FAILURE: " + e.getMessage(), (Throwable)e);
            log.error("");
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    static {
        Jdk14LogFactory.initializeJdk14Logging();
        log = Log.getLog((String)JbpmTestCase.class.getName());
    }
}

