/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jbpm.Configuration;
import org.jbpm.Execution;
import org.jbpm.ExecutionService;
import org.jbpm.ManagementService;
import org.jbpm.ProcessDefinition;
import org.jbpm.ProcessEngine;
import org.jbpm.ProcessService;
import org.jbpm.TaskService;
import org.jbpm.cmd.CommandService;
import org.jbpm.task.Task;
import org.jbpm.test.Db;
import org.jbpm.test.JbpmTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbTestCase
extends JbpmTestCase {
    protected static ProcessEngine processEngine = null;
    protected static ProcessService processService;
    protected static ExecutionService executionService;
    protected static ManagementService managementService;
    protected static TaskService taskService;
    protected static CommandService commandService;
    protected List<ProcessDefinition> processDefinitions;
    protected List<String> taskIds;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initialize();
    }

    protected synchronized void initialize() {
        if (processEngine == null) {
            String jbpmTestCfgType = System.getProperty("jbpm.test.cfg.type");
            Configuration configuration = new Configuration(jbpmTestCfgType);
            String jbpmTestCfgResource = System.getProperty("jbpm.test.cfg.resource");
            if (jbpmTestCfgResource != null) {
                configuration.setResource(jbpmTestCfgResource);
            }
            processEngine = configuration.buildProcessEngine();
            processService = processEngine.getProcessService();
            executionService = processEngine.getExecutionService();
            managementService = processEngine.getManagementService();
            taskService = processEngine.getTaskService();
            commandService = (CommandService)processEngine.get(CommandService.class);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.processDefinitions != null) {
            for (ProcessDefinition processDefinition : this.processDefinitions) {
                processService.deleteProcessDefinitionAndInstances(processDefinition.getId());
            }
        }
        if (this.taskIds != null) {
            for (String taskId : this.taskIds) {
                taskService.deleteTask(taskId);
            }
        }
        Db.verifyClean(processEngine);
        super.tearDown();
    }

    public ProcessDefinition deployJpdlXmlString(String jpdlXmlString) {
        List deployedProcessDefinitions = processService.createDeployment().addString("xmlstring.jpdl.xml", jpdlXmlString).deploy().getProcessDefinitions();
        return this.addDeployedProcessDefinition(deployedProcessDefinitions);
    }

    public ProcessDefinition deployJpdlResource(String resource) {
        List deployedProcessDefinitions = processService.createDeployment().addResource(resource).deploy().getProcessDefinitions();
        return this.addDeployedProcessDefinition(deployedProcessDefinitions);
    }

    protected ProcessDefinition addDeployedProcessDefinition(ProcessDefinition deployedProcessDefinition) {
        if (this.processDefinitions == null) {
            this.processDefinitions = new ArrayList<ProcessDefinition>();
        }
        this.processDefinitions.add(deployedProcessDefinition);
        return deployedProcessDefinition;
    }

    protected ProcessDefinition addDeployedProcessDefinition(List<ProcessDefinition> deployedProcessDefinitions) {
        if (this.processDefinitions == null) {
            this.processDefinitions = new ArrayList<ProcessDefinition>();
        }
        this.processDefinitions.addAll(deployedProcessDefinitions);
        if (deployedProcessDefinitions.size() >= 1) {
            return deployedProcessDefinitions.get(0);
        }
        return null;
    }

    public void saveTask(Task task) {
        taskService.saveTask(task);
        if (this.taskIds == null) {
            this.taskIds = new ArrayList<String>();
        }
        this.taskIds.add(task.getId());
    }

    public HashSet<String> getNodeNames(String processInstanceId) {
        HashSet<String> nodeNames = new HashSet<String>();
        List executions = executionService.findExecutions(processInstanceId);
        for (Execution execution : executions) {
            String nodeName = execution.getNodeName();
            if (nodeName == null) continue;
            nodeNames.add(nodeName);
        }
        return nodeNames;
    }

    public Execution findExecution(String processInstanceId, String nodeName) {
        List executions = executionService.findExecutions(processInstanceId);
        for (Execution execution : executions) {
            if (!nodeName.equals(execution.getNodeName())) continue;
            return execution;
        }
        return null;
    }
}

