/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.ArrayList;
import java.util.Iterator;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.jbpm.ProcessEngine;
import org.jbpm.env.EnvironmentFactory;
import org.jbpm.log.Log;

public class Db {
    private static final Log log = Log.getLog((String)Db.class.getName());
    private static final String TABLE_NAMES_KEY = "tableNames";
    private static final String CLEAN_SQL_KEY = "cleanSql";

    public static void clean(ProcessEngine processEngine) {
        Db.clean((EnvironmentFactory)processEngine);
    }

    public static void verifyClean(ProcessEngine processEngine) {
        Db.verifyClean((EnvironmentFactory)processEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clean(EnvironmentFactory environmentFactory) {
        SessionFactory sessionFactory = (SessionFactory)environmentFactory.get(SessionFactory.class);
        String[] cleanSql = (String[])environmentFactory.get(CLEAN_SQL_KEY);
        if (cleanSql == null) {
            Configuration configuration = (Configuration)environmentFactory.get(Configuration.class);
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
            Dialect dialect = sessionFactoryImplementor.getDialect();
            ArrayList<String> dropForeignKeysSql = new ArrayList<String>();
            ArrayList<String> createForeignKeysSql = new ArrayList<String>();
            Iterator iter = configuration.getTableMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                String catalog = table.getCatalog();
                String schema = table.getSchema();
                Iterator subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    dropForeignKeysSql.add(fk.sqlDropString(dialect, catalog, schema));
                    if (dialect instanceof MySQLDialect) {
                        dropForeignKeysSql.add("alter table " + table.getName() + " drop key " + fk.getName());
                    }
                    createForeignKeysSql.add(fk.sqlCreateString(dialect, (Mapping)sessionFactoryImplementor, catalog, schema));
                }
            }
            ArrayList<String> deleteSql = new ArrayList<String>();
            iter = configuration.getTableMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                deleteSql.add("delete from " + table.getName());
            }
            ArrayList<String> cleanSqlList = new ArrayList<String>();
            cleanSqlList.addAll(dropForeignKeysSql);
            cleanSqlList.addAll(deleteSql);
            cleanSqlList.addAll(createForeignKeysSql);
            cleanSql = cleanSqlList.toArray(new String[cleanSqlList.size()]);
            environmentFactory.set(CLEAN_SQL_KEY, (Object)cleanSql);
        }
        Session session = sessionFactory.openSession();
        try {
            for (String query : cleanSql) {
                session.createSQLQuery(query).executeUpdate();
            }
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyClean(EnvironmentFactory environmentFactory) {
        SessionFactory sessionFactory = (SessionFactory)environmentFactory.get(SessionFactory.class);
        String[] tableNames = (String[])environmentFactory.get(TABLE_NAMES_KEY);
        if (tableNames == null) {
            Configuration configuration = (Configuration)environmentFactory.get(Configuration.class);
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
            Dialect dialect = sessionFactoryImplementor.getDialect();
            ArrayList<String> tableNamesList = new ArrayList<String>();
            Iterator iter = configuration.getTableMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                tableNamesList.add(table.getName());
            }
            tableNames = tableNamesList.toArray(new String[tableNamesList.size()]);
            environmentFactory.set(TABLE_NAMES_KEY, (Object)tableNames);
        }
        boolean recordsLeft = false;
        Session session = sessionFactory.openSession();
        try {
            for (String tableName : tableNames) {
                String countSql = "select count(*) recordCount from " + tableName;
                SQLQuery sqlQuery = session.createSQLQuery(countSql);
                sqlQuery.addScalar("recordCount", (Type)Hibernate.INTEGER);
                Integer recordCount = (Integer)sqlQuery.uniqueResult();
                if (recordCount <= 0) continue;
                recordsLeft = true;
                log.error("FIXME: " + recordCount + " records left in table " + tableName);
            }
        }
        finally {
            session.close();
        }
        if (recordsLeft) {
            Db.clean(environmentFactory);
        }
    }
}

