/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.processlog;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.jbpm.Execution;
import org.jbpm.model.OpenExecution;
import org.jbpm.processlog.ProcessLog;
import org.jbpm.processlog.ProcessLogProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessLogImpl
implements Serializable,
ProcessLog {
    private static final long serialVersionUID = 1L;
    protected long dbid;
    protected int index = -1;
    protected Date time;
    protected Execution execution;
    protected Execution processInstance;

    public void setExecution(OpenExecution execution) {
        this.execution = execution;
        this.processInstance = execution != null ? execution.getProcessInstance() : null;
    }

    @Override
    public abstract String getType();

    @Override
    public abstract List<ProcessLogProperty> getProperties();

    @Override
    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.getType());
        text.append('[');
        List<ProcessLogProperty> properties = this.getProperties();
        if (properties != null) {
            for (int i = 0; i < properties.size(); ++i) {
                ProcessLogProperty property = properties.get(i);
                text.append(property.name);
                if (property.value != null) {
                    text.append('=');
                    text.append(property.value);
                }
                if (i >= properties.size() - 1) continue;
                text.append('|');
            }
        }
        text.append(']');
        return text.toString();
    }

    @Override
    public long getDbid() {
        return this.dbid;
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    @Override
    public void setTime(Date date) {
        this.time = date;
    }

    @Override
    public Execution getExecution() {
        return this.execution;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Execution getProcessInstance() {
        return this.processInstance;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

