/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.identity.action;

import java.util.Iterator;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class DeleteMembershipActionListener
implements JbpmActionListener {
    private final ValueExpression userExpression;
    private final ValueExpression membershipIdExpression;

    public DeleteMembershipActionListener(ValueExpression userExpression, ValueExpression membershipIdExpression) {
        this.userExpression = userExpression;
        this.membershipIdExpression = membershipIdExpression;
    }

    public String getName() {
        return "deleteMembership";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            User user = (User)this.userExpression.getValue(elContext);
            long membershipId = (Long)this.membershipIdExpression.getValue(elContext);
            Set membershipSet = user.getMemberships();
            Iterator it = membershipSet.iterator();
            while (it.hasNext()) {
                Membership membership = (Membership)it.next();
                if (membership.getId() != membershipId) continue;
                it.remove();
                context.getJbpmContext().getSession().delete((Object)membership);
                break;
            }
            context.addSuccessMessage("Successfully deleted membership");
        }
        catch (Exception ex) {
            context.setError("Failed to delete membership", ex);
        }
    }
}

