/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class SuspendActionListener
implements JbpmActionListener {
    private final ValueExpression valueExpression;

    public SuspendActionListener(ValueExpression valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String getName() {
        return "suspend";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object value = this.valueExpression.getValue(elContext);
            if (value == null) {
                context.setError("Suspend failed", "The value is null");
                return;
            }
            if (value instanceof TaskInstance) {
                ((TaskInstance)value).suspend();
                context.addSuccessMessage("Task instance suspended");
            } else if (value instanceof Token) {
                ((Token)value).suspend();
                context.addSuccessMessage("Token suspended");
            } else if (value instanceof ProcessInstance) {
                ((ProcessInstance)value).suspend();
                context.addSuccessMessage("Process instance suspended");
            } else {
                context.setError("Suspend failed", "The value type is not recognized");
                return;
            }
            context.getJbpmContext().getSession().flush();
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Suspend failed", ex);
            return;
        }
    }
}

