/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import java.util.List;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class ListProcessInstancesActionListener
implements JbpmActionListener {
    private final ValueExpression targetExpression;
    private final ValueExpression processIdExpression;

    public ListProcessInstancesActionListener(ValueExpression processIdExpression, ValueExpression targetExpression) {
        this.processIdExpression = processIdExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "listProcessInstances";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            long id;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object idValue = this.processIdExpression.getValue(elContext);
            if (idValue instanceof Number) {
                id = ((Number)idValue).longValue();
            } else if (idValue instanceof String) {
                id = Long.parseLong((String)idValue);
            } else if (idValue != null) {
                id = Long.parseLong(idValue.toString());
            } else {
                context.setError("Error loading process instance list", "The process ID value is null");
                return;
            }
            List processList = context.getJbpmContext().getGraphSession().findProcessInstances(id);
            this.targetExpression.setValue(elContext, (Object)processList);
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error loading process instance list", ex);
            return;
        }
    }
}

