/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.ExecutionManager;
import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.InputSet;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.OutputSet;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.Property;
import org.jboss.bpm.runtime.Attachments;
import org.jboss.util.id.UID;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.integration.model.AbstractElementImpl;
import org.jbpm.integration.model.FlowObjectImpl;
import org.jbpm.integration.model.SequenceFlowImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessImpl
extends AbstractElementImpl
implements Process {
    private ProcessDefinition jbpmProc;
    private List<FlowObject> flowObjects = new ArrayList<FlowObject>();
    private Process.ProcessStatus status = Process.ProcessStatus.None;

    public ProcessImpl(ProcessDefinition jbpmProc) {
        this.jbpmProc = jbpmProc;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.jbpmProc;
    }

    public ObjectName getID() {
        if (this.id == null) {
            StringBuilder str = new StringBuilder("org.jbpm:");
            str.append("type=Process,name=" + this.getName() + ",id=" + new UID());
            this.id = ObjectNameFactory.create((String)str.toString());
        }
        return this.id;
    }

    public String getName() {
        return this.jbpmProc.getName();
    }

    public Process.ProcessStatus getProcessStatus() {
        return this.status;
    }

    public void setProcessStatus(Process.ProcessStatus status) {
        this.status = status;
    }

    public void addFlowObject(FlowObject flowObject) {
        this.flowObjects.add(flowObject);
    }

    public ObjectName startProcess() {
        ExecutionManager exManager = ExecutionManager.locateExecutionManager();
        exManager.startProcess((Process)this, null);
        return this.getID();
    }

    public Process.ProcessStatus waitForEnd() {
        ExecutionManager exManager = ExecutionManager.locateExecutionManager();
        return exManager.waitForEnd((Process)this);
    }

    public Process.ProcessStatus waitForEnd(long timeout) {
        ExecutionManager exManager = ExecutionManager.locateExecutionManager();
        return exManager.waitForEnd((Process)this, timeout);
    }

    public List<FlowObject> getFlowObjects() {
        return Collections.unmodifiableList(this.flowObjects);
    }

    public FlowObject getFlowObject(String name) {
        for (FlowObject fo : this.getFlowObjects()) {
            if (!name.equals(fo.getName())) continue;
            return fo;
        }
        return null;
    }

    public void initialize() {
        for (FlowObject fo : this.getFlowObjects()) {
            FlowObjectImpl foImpl = (FlowObjectImpl)fo;
            SequenceFlowImpl flowImpl = (SequenceFlowImpl)foImpl.getOutFlow();
            if (flowImpl == null) continue;
            String targetName = flowImpl.getTargetName();
            FlowObjectImpl targetFO = (FlowObjectImpl)this.getFlowObject(targetName);
            Node jbpmTarget = targetFO.getNode();
            Transition jbpmTransition = flowImpl.getTransition();
            jbpmTransition.setTo(jbpmTarget);
        }
    }

    public List<Assignment> getAssignments() {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public <T extends FlowObject> List<T> getFlowObjects(Class<T> clazz) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public List<InputSet> getInputSets() {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public Message getMessage(String msgName) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public List<Message> getMessages() {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public List<OutputSet> getOutputSets() {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public List<String> getPerformers() {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public Process.ProcessType getProcessType() {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public ObjectName startProcess(Attachments att) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public List<Property> getProperties() {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public Property getProperty(String name) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public List<String> getPropertyNames() {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public Object getPropertyValue(String name) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public <T> T getPropertyValue(Class<T> clazz, String name) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }
}

