/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.model;

import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.EventBuilder;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.GatewayBuilder;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.Task;
import org.jboss.bpm.model.TaskBuilder;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.integration.model.EndStateWrapper;
import org.jbpm.integration.model.EventBuilderImpl;
import org.jbpm.integration.model.FlowObjectImpl;
import org.jbpm.integration.model.ProcessImpl;
import org.jbpm.integration.model.SequenceFlowImpl;
import org.jbpm.integration.model.StartStateWrapper;
import org.jbpm.integration.model.StateWrapper;
import org.jbpm.integration.model.TaskBuilderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessBuilderImpl
implements ProcessBuilder {
    protected ProcessImpl proc;
    protected FlowObjectImpl flowObject;

    public ProcessBuilderImpl() {
    }

    public ProcessBuilderImpl(ProcessImpl proc, FlowObjectImpl flowObject) {
        this.proc = proc;
        this.flowObject = flowObject;
    }

    public ProcessBuilder addProcess(String name) {
        ProcessDefinition jbpmProc = new ProcessDefinition(name);
        this.proc = new ProcessImpl(jbpmProc);
        return this;
    }

    public EventBuilder addStartEvent(String name) {
        StartStateWrapper jbpmNode = new StartStateWrapper(name);
        this.flowObject = new FlowObjectImpl(this.proc, (Node)jbpmNode);
        this.proc.addFlowObject(this.flowObject);
        ProcessDefinition jbpmProc = this.proc.getProcessDefinition();
        jbpmProc.setStartState((Node)jbpmNode);
        return new EventBuilderImpl(this.proc, this.flowObject);
    }

    public EventBuilder addEndEvent(String name) {
        EndStateWrapper jbpmNode = new EndStateWrapper(name);
        this.flowObject = new FlowObjectImpl(this.proc, (Node)jbpmNode);
        this.proc.addFlowObject(this.flowObject);
        return new EventBuilderImpl(this.proc, this.flowObject);
    }

    public TaskBuilder addTask(String name) {
        StateWrapper jbpmNode = new StateWrapper(name);
        this.flowObject = new FlowObjectImpl(this.proc, (Node)jbpmNode);
        this.proc.addFlowObject(this.flowObject);
        return new TaskBuilderImpl(this.proc, this.flowObject);
    }

    public ProcessBuilder addSequenceFlow(String targetName) {
        Node jbpmNode = this.flowObject.getNode();
        Transition jbpmTransition = new Transition(targetName);
        jbpmTransition.setFrom(jbpmNode);
        jbpmNode.addLeavingTransition(jbpmTransition);
        this.flowObject.setOutFlow(new SequenceFlowImpl(jbpmTransition));
        return this;
    }

    public Process getProcess() {
        this.proc.initialize();
        return this.proc;
    }

    public ProcessBuilder addAssignment(Assignment.AssignTime time, Expression.ExpressionLanguage lang, String fromExpr, String toProp) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public EventBuilder addEvent(String name) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public ProcessBuilder addExecutionHandler(Class<?> clazz) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public ProcessBuilder addFlowHandler(Class<?> clazz) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public GatewayBuilder addGateway(String name, Gateway.GatewayType type) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public MessageBuilder addMessage(String name) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public ProcessBuilder addMessageFlow(String targetName) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public ProcessBuilder addProcess(Process proc) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public ProcessBuilder addProperty(String name, String value) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public ProcessBuilder addSignalHandler(Class<?> clazz) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public TaskBuilder addTask(String name, Task.TaskType type) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public Process getProcessForInclude() {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }
}

