/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.runtime.Context;
import org.jboss.bpm.api.service.ContextService;
import org.jboss.bpm.api.service.ProcessDefinitionService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.ProcessEngineSupport;
import org.jboss.bpm.api.service.ProcessInstanceService;
import org.jboss.bpm.api.service.internal.AbstractService;
import org.jbpm.JbpmContext;
import org.jbpm.db.GraphSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.integration.spec.model.ProcessDefinitionImpl;
import org.jbpm.integration.spec.model.ProcessInstanceImpl;
import org.jbpm.integration.spec.runtime.InvocationProxy;
import org.jbpm.integration.spec.runtime.NodeInterceptor;
import org.jbpm.integration.spec.service.MutableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceServiceImpl
extends AbstractService
implements ProcessInstanceService,
MutableService {
    static final Logger log = LoggerFactory.getLogger(ProcessInstanceServiceImpl.class);
    private List<NodeInterceptor> nodeInterceptors = new ArrayList<NodeInterceptor>();

    @Override
    public void setProcessEngine(ProcessEngine engine) {
        super.setProcessEngine(engine);
    }

    public void setInterceptors(List<String> itorClassNames) {
        for (String itorClass : itorClassNames) {
            NodeInterceptor itor = this.loadNodeInterceptor(itorClass);
            this.nodeInterceptors.add(itor);
        }
    }

    public List<NodeInterceptor> getNodeInterceptors() {
        return Collections.unmodifiableList(this.nodeInterceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInstance getInstance(ObjectName procID) {
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            ProcessInstance proc = null;
            GraphSession graphSession = ((JbpmContext)bpmContext.getAttachment(JbpmContext.class)).getGraphSession();
            org.jbpm.graph.exe.ProcessInstance oldProc = graphSession.getProcessInstance(this.adaptKey(procID).longValue());
            if (oldProc != null) {
                proc = ProcessInstanceImpl.newInstance(this.getProcessEngine(), oldProc, true);
            }
            ProcessInstance processInstance = proc;
            return processInstance;
        }
        finally {
            bpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ObjectName> getInstance() {
        HashSet<ObjectName> procs = new HashSet<ObjectName>();
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            ProcessDefinitionService pdService = (ProcessDefinitionService)this.getProcessEngine().getService(ProcessDefinitionService.class);
            for (ObjectName procDefID : pdService.getProcessDefinitions()) {
                Long id = this.adaptKey(procDefID);
                GraphSession graphSession = ((JbpmContext)bpmContext.getAttachment(JbpmContext.class)).getGraphSession();
                for (Object item : graphSession.findProcessInstances(id.longValue())) {
                    org.jbpm.graph.exe.ProcessInstance oldProc = (org.jbpm.graph.exe.ProcessInstance)item;
                    procs.add(ProcessInstanceImpl.getKey(oldProc));
                }
            }
        }
        finally {
            bpmContext.close();
        }
        return Collections.unmodifiableSet(procs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ObjectName> getInstance(ObjectName procDefID, ProcessInstance.ProcessStatus status) {
        HashSet<ObjectName> procs = new HashSet<ObjectName>();
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            Long id = this.adaptKey(procDefID);
            GraphSession graphSession = ((JbpmContext)bpmContext.getAttachment(JbpmContext.class)).getGraphSession();
            for (Object item : graphSession.findProcessInstances(id.longValue())) {
                org.jbpm.graph.exe.ProcessInstance oldProc = (org.jbpm.graph.exe.ProcessInstance)item;
                ProcessInstance auxProc = ProcessInstanceImpl.newInstance(this.getProcessEngine(), oldProc, true);
                if (status != null && auxProc.getProcessStatus() != status) continue;
                procs.add(auxProc.getKey());
            }
        }
        finally {
            bpmContext.close();
        }
        return Collections.unmodifiableSet(procs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessInstance registerInstance(ProcessInstance proc) {
        log.debug("registerProcess: " + proc);
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            if (this.getInstance(proc.getKey()) != null) {
                throw new IllegalStateException("Process already registered: " + proc);
            }
            ProcessInstance.ProcessStatus procStatus = proc.getProcessStatus();
            if (procStatus != ProcessInstance.ProcessStatus.None) {
                throw new IllegalStateException("Cannot register process in state: " + procStatus);
            }
            org.jboss.bpm.api.model.ProcessDefinition procDef = proc.getProcessDefinition();
            ProcessDefinitionService procDefService = (ProcessDefinitionService)this.getProcessEngine().getService(ProcessDefinitionService.class);
            if (procDefService.getProcessDefinition(procDef.getKey()) == null) {
                procDefService.registerProcessDefinition(procDef);
            }
            ProcessInstanceImpl procImpl = InvocationProxy.getUnderlying(proc, ProcessInstanceImpl.class);
            org.jbpm.graph.exe.ProcessInstance oldProcInst = (org.jbpm.graph.exe.ProcessInstance)procImpl.getDelegate();
            procDef = procDefService.getProcessDefinition(procDef.getKey());
            ProcessDefinitionImpl procDefImpl = InvocationProxy.getUnderlying(procDef, ProcessDefinitionImpl.class);
            oldProcInst.setProcessDefinition((ProcessDefinition)procDefImpl.getDelegate());
            JbpmContext jbpmContext = (JbpmContext)bpmContext.getAttachment(JbpmContext.class);
            jbpmContext.save(oldProcInst);
            procImpl.setProcessStatus(ProcessInstance.ProcessStatus.Ready);
            ProcessInstance processInstance = proc = InvocationProxy.newInstance((ProcessEngineSupport)procImpl, ProcessInstance.class);
            return processInstance;
        }
        finally {
            bpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterInstance(ObjectName procID) {
        boolean removed = false;
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            ProcessInstance proc = this.getInstance(procID);
            if (proc != null) {
                log.debug("unregisterProcess: " + proc);
                ProcessInstanceImpl procImpl = InvocationProxy.getUnderlying(proc, ProcessInstanceImpl.class);
                GraphSession graphSession = ((JbpmContext)bpmContext.getAttachment(JbpmContext.class)).getGraphSession();
                graphSession.deleteProcessInstance((org.jbpm.graph.exe.ProcessInstance)procImpl.getDelegate());
                removed = true;
            }
        }
        finally {
            bpmContext.close();
        }
        return removed;
    }

    private NodeInterceptor loadNodeInterceptor(String className) {
        NodeInterceptor itor = null;
        if (className != null) {
            try {
                ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
                itor = (NodeInterceptor)ctxLoader.loadClass(className).newInstance();
            }
            catch (Exception ex) {
                log.error("Cannot load interceptor: " + className, (Throwable)ex);
            }
        }
        return itor;
    }

    private Long adaptKey(ObjectName key) {
        String id = key.getKeyProperty("id");
        if (id == null) {
            throw new IllegalStateException("Cannot obtain id property from: " + key);
        }
        return new Long(id);
    }
}

