/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.model.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.bpm.api.InvalidProcessException;
import org.jboss.bpm.api.NotImplementedException;
import org.jboss.bpm.api.model.Node;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.incubator.model.EndEvent;
import org.jboss.bpm.incubator.model.Expression;
import org.jboss.bpm.incubator.model.Gateway;
import org.jboss.bpm.incubator.model.StartEvent;
import org.jboss.bpm.incubator.model.Task;
import org.jboss.bpm.incubator.model.builder.GatewayBuilder;
import org.jboss.bpm.incubator.model.builder.ProcessBuilder;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.Decision;
import org.jbpm.graph.node.EndState;
import org.jbpm.graph.node.StartState;
import org.jbpm.graph.node.State;
import org.jbpm.integration.spec.model.EndEventImpl;
import org.jbpm.integration.spec.model.ExclusiveGatewayImpl;
import org.jbpm.integration.spec.model.NodeImpl;
import org.jbpm.integration.spec.model.NoneTaskImpl;
import org.jbpm.integration.spec.model.ProcessDefinitionImpl;
import org.jbpm.integration.spec.model.SequenceFlowImpl;
import org.jbpm.integration.spec.model.StartEventImpl;
import org.jbpm.integration.spec.model.WaitStateImpl;
import org.jbpm.integration.spec.model.builder.GatewayBuilderImpl;

public class ProcessBuilderImpl
implements ProcessBuilder {
    protected ProcessEngine engine;
    protected ProcessDefinitionImpl procDefImpl;
    protected NodeImpl<?> nodeImpl;
    private List<FlowSpec> flows = new ArrayList<FlowSpec>();

    public ProcessBuilderImpl(ProcessEngine engine) {
        this.engine = engine;
    }

    protected ProcessBuilderImpl(ProcessBuilderImpl procBuilder) {
        this.engine = procBuilder.engine;
        this.procDefImpl = procBuilder.procDefImpl;
        this.nodeImpl = procBuilder.nodeImpl;
        this.flows = procBuilder.flows;
    }

    public ProcessBuilder addProcess(String name) {
        ProcessDefinition oldProcDef = ProcessDefinition.createNewProcessDefinition();
        oldProcDef.setName(name);
        this.procDefImpl = (ProcessDefinitionImpl)ProcessDefinitionImpl.newInstance(this.engine, oldProcDef, false);
        return this;
    }

    public org.jboss.bpm.api.model.ProcessDefinition getProcessDefinition() {
        this.initProcessDefinition();
        return this.procDefImpl;
    }

    public ProcessBuilder addStartEvent(String name) {
        if (name == null) {
            throw new InvalidProcessException("StartEvent name cannot be null");
        }
        this.nodeImpl = new StartEventImpl(this.engine, this.procDefImpl, (org.jbpm.graph.def.Node)new StartState(name));
        this.procDefImpl.addNode(this.nodeImpl);
        return this;
    }

    public GatewayBuilder addGateway(String name, Gateway.GatewayType type) {
        if (type != Gateway.GatewayType.Exclusive) {
            throw new NotImplementedException("Unsupported gateway type: " + type);
        }
        this.nodeImpl = new ExclusiveGatewayImpl(this.engine, this.procDefImpl, (org.jbpm.graph.def.Node)new Decision(name));
        this.procDefImpl.addNode(this.nodeImpl);
        return new GatewayBuilderImpl(this);
    }

    public ProcessBuilder addTask(String name) {
        return this.addTask(name, Task.TaskType.None);
    }

    public ProcessBuilder addTask(String name, Task.TaskType type) {
        if (type == Task.TaskType.None) {
            this.nodeImpl = new NoneTaskImpl(this.engine, this.procDefImpl, new org.jbpm.graph.def.Node(name));
            this.procDefImpl.addNode(this.nodeImpl);
        } else if (type == Task.TaskType.Wait) {
            this.nodeImpl = new WaitStateImpl(this.engine, this.procDefImpl, (org.jbpm.graph.def.Node)new State(name));
            this.procDefImpl.addNode(this.nodeImpl);
        } else {
            throw new NotImplementedException("Unsupported task type: " + type);
        }
        return this;
    }

    public ProcessBuilder addEndEvent(String name) {
        this.nodeImpl = new EndEventImpl(this.engine, this.procDefImpl, (org.jbpm.graph.def.Node)new EndState(name));
        this.procDefImpl.addNode(this.nodeImpl);
        return this;
    }

    public ProcessBuilder addSequenceFlow(String targetName) {
        return this.addSequenceFlow(targetName, null, null);
    }

    public ProcessBuilder addSequenceFlow(String targetName, Expression.ExpressionLanguage exprLang, String exprBody) {
        this.flows.add(new FlowSpec(this.nodeImpl.getName(), targetName, exprLang, exprBody));
        return this;
    }

    private void initProcessDefinition() {
        Node.NodeType nodeType;
        org.jbpm.graph.def.Node delegate;
        NodeImpl nodeImpl;
        for (FlowSpec flow : this.flows) {
            NodeImpl srcNode = (NodeImpl)this.procDefImpl.getNode(flow.source);
            if (srcNode == null) {
                throw new InvalidProcessException("Cannot obtain source node: " + flow.source);
            }
            NodeImpl targetNode = (NodeImpl)this.procDefImpl.getNode(flow.target);
            if (targetNode == null) {
                throw new InvalidProcessException("Cannot obtain target node: " + flow.target);
            }
            Transition trans = new Transition(flow.target);
            trans.setFrom((org.jbpm.graph.def.Node)srcNode.getDelegate());
            trans.setTo((org.jbpm.graph.def.Node)targetNode.getDelegate());
            SequenceFlowImpl seqFlow = new SequenceFlowImpl(trans, flow.exprLang, flow.exprBody);
            srcNode.addSequenceFlow(seqFlow);
        }
        List<StartEvent> startEvents = this.procDefImpl.getNodes(StartEvent.class);
        if (startEvents.size() == 0) {
            throw new InvalidProcessException("Cannot obtain a start event");
        }
        List<EndEvent> endEvents = this.procDefImpl.getNodes(EndEvent.class);
        if (endEvents.size() == 0) {
            throw new InvalidProcessException("Cannot obtain an end event");
        }
        for (Node node : this.procDefImpl.getNodes()) {
            nodeImpl = (NodeImpl)node;
            delegate = (org.jbpm.graph.def.Node)nodeImpl.getDelegate();
            Set arriving = delegate.getArrivingTransitions();
            nodeType = delegate.getNodeType();
            if (nodeType == Node.NodeType.StartState || arriving != null) continue;
            throw new InvalidProcessException("Unreachable node: " + node);
        }
        for (Node node : this.procDefImpl.getNodes()) {
            nodeImpl = (NodeImpl)node;
            delegate = (org.jbpm.graph.def.Node)nodeImpl.getDelegate();
            List leaving = delegate.getLeavingTransitions();
            nodeType = delegate.getNodeType();
            if (nodeType == Node.NodeType.EndState || leaving != null) continue;
            throw new InvalidProcessException("Dead end node: " + node);
        }
    }

    class FlowSpec {
        String source;
        String target;
        Expression.ExpressionLanguage exprLang;
        String exprBody;

        public FlowSpec(String source, String target, Expression.ExpressionLanguage exprLang, String exprBody) {
            this.source = source;
            this.target = target;
            this.exprLang = exprLang;
            this.exprBody = exprBody;
        }
    }
}

