/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.integration.jbpm3;

import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.model.jbpm3.TokenReference;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.PooledActor;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
class Transform
{
   public static ProcessDefinitionRef processDefinition(org.jbpm.graph.def.ProcessDefinition p0)
   {
      return new ProcessDefinitionRef(p0.getId(), p0.getName(), String.valueOf(p0.getVersion()));
   }

   public static ProcessInstanceRef processInstance(org.jbpm.graph.exe.ProcessInstance i0)
   {      
      Date start = i0.getStart();      
      Date end = i0.getEnd();
      boolean suspended = i0.isSuspended();
      long processId = i0.getProcessDefinition().getId();
      long instanceId = i0.getId();
      ProcessInstanceRef processInstance = new ProcessInstanceRef(instanceId, processId, start, end, suspended);

      // token
      Token t0 = i0.getRootToken();
      processInstance.setRootToken(Transform.tokenReference(t0));
      return processInstance;
   }

   private static TokenReference tokenReference(Token t0)
   {
      TokenReference token = new TokenReference(t0.getId(), null, t0.getNode().getName());

      if(t0.hasActiveChildren() || t0.isTerminatedImplicitly())
         token.setCanBeSignaled(false);
      
      Map children = t0.getChildren();
      if(children!=null)
      {
         for(Object o : children.values())
         {
            Token t1 = (Token)o;
            token.getChildren().add( Transform.tokenReference(t1) );
         }
      }

      // signals
      for(Object tr0  : t0.getNode().getLeavingTransitionsList())
      {
         Transition transition = (Transition)tr0;
            String tName = transition.getName()!=null ? transition.getName() : "default transition";
         token.getAvailableSignals().add(tName);
      }

      return token;
   }

   public static void doTransition(org.jbpm.graph.exe.ProcessInstance p0, ProcessInstanceRef.STATE nextState)
   {
      ProcessInstanceRef instance = Transform.processInstance(p0);
      instance.setState(nextState);  // has lifecycle build in, hence the extra round

      switch(instance.getState())
      {
         case ENDED:
            p0.setEnd(instance.getEndDate());
            p0.end();
            break;
         case SUSPENDED:
            p0.suspend();
            break;
         case RUNNING:
            if(p0.isSuspended())
               p0.resume();            
      }
            
   }

   public static TaskRef taskInstance(org.jbpm.taskmgmt.exe.TaskInstance t0)
   {
      TaskRef taskRef = new TaskRef(
            t0.getId(),
            t0.getToken().getId(),
            t0.getProcessInstance().getId(),
            t0.getProcessInstance().getProcessDefinition().getId(),
            t0.getName(), t0.getActorId(),
            t0.isBlocking(), t0.isSignalling()            
      );

      Set<PooledActor> pooledActors = (Set<PooledActor>)t0.getPooledActors();
      for(PooledActor p : pooledActors)
      {
         taskRef.addPooledActor(p.getActorId());         
      }

      List<Transition> transitionList =
            t0.getToken().getNode().getLeavingTransitionsList();
      for(Transition transition : transitionList)
      {
         String tName = transition.getName()!=null ? transition.getName() : "default transition";
         taskRef.getTransitionNames().add(tName);
      }

      return taskRef;
   }


}
