/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.integration.jbpm3;

import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.server.integration.TaskManagement;
import org.jbpm.taskmgmt.exe.TaskInstance;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class JBPM3TaskManagement implements TaskManagement
{

   private JBPM3CommandDelegate delegate;

   public JBPM3TaskManagement()
   {
      this.delegate = new JBPM3CommandDelegate();
   }

   public List<TaskRef> getTasksByActor(String actorName)
   {

      List<TaskInstance> actualTasks =
            delegate.getActualTasksForActor(actorName);

      List<TaskRef> taskRefs = new ArrayList<TaskRef>();
      for(TaskInstance t0 : actualTasks)
      {
         taskRefs.add( Transform.taskInstance(t0));
      }

      return taskRefs;
   }

   public TaskRef getTaskById(long taskId)
   {
      TaskInstance t0 = delegate.getTaskById(taskId);
      TaskRef taskRef = Transform.taskInstance(t0);
      return taskRef; 
   }


   public void reassignTask(long taskId, String actorId)
   {
      // TODO: validation of actorId?
      delegate.assignTask(taskId, actorId);
   }


   public void closeTask(long taskId, String signalName)
   {
      delegate.endTask(taskId, signalName);
   }
}
