/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.nio.Log;
import org.xnio.nio.WorkerThread;

final class NioHandle<C extends Channel>
implements Runnable {
    private final SelectionKey selectionKey;
    private final WorkerThread workerThread;
    private final ChannelListener.SimpleSetter<C> handlerSetter;
    private final C channel;
    private volatile int state;
    private static final int FLAG_SCHEDULED = 32;
    private static final int FLAG_SUS_RES = 64;
    private static final int FLAG_RESUMED = 128;
    private static final int MASK_OPS = Bits.intBitMask((int)0, (int)4);
    private static final AtomicIntegerFieldUpdater<NioHandle> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(NioHandle.class, "state");

    NioHandle(SelectionKey selectionKey, WorkerThread workerThread, ChannelListener.SimpleSetter<C> handlerSetter, C channel, int ops) {
        this.selectionKey = selectionKey;
        this.workerThread = workerThread;
        this.handlerSetter = handlerSetter;
        this.channel = channel;
        this.state = ops & MASK_OPS;
    }

    WorkerThread getWorkerThread() {
        return this.workerThread;
    }

    ChannelListener.SimpleSetter<C> getHandlerSetter() {
        return this.handlerSetter;
    }

    void cancelKey() {
        this.suspend();
        this.workerThread.cancelKey(this.selectionKey);
    }

    int setOps(int newOps) {
        int newVal;
        int oldVal;
        do {
            if (((oldVal = this.state) & MASK_OPS) != newOps) continue;
            return newOps;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal & ~MASK_OPS | newOps));
        return oldVal & MASK_OPS;
    }

    void resume() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)128)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x80 | 0x40));
        if (Bits.allAreSet((int)oldVal, (int)64)) {
            return;
        }
        oldVal = newVal;
        newVal = oldVal & 0xFFFFFFBF;
        this.workerThread.setOps(this.selectionKey, oldVal & MASK_OPS);
        if (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
            boolean resume = true;
            do {
                oldVal = this.state;
                newVal = oldVal & 0xFFFFFFBF;
                if (Bits.allAreSet((int)oldVal, (int)128) == resume && (oldVal & MASK_OPS) == (newVal & MASK_OPS)) continue;
                resume = !resume;
                this.workerThread.setOps(this.selectionKey, resume ? oldVal & MASK_OPS : 0);
            } while (!stateUpdater.compareAndSet(this, oldVal, newVal));
        }
    }

    void suspend() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreClear((int)(oldVal = this.state), (int)128)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal & 0xFFFFFF7F | 0x40));
        if (Bits.allAreSet((int)oldVal, (int)64)) {
            return;
        }
        oldVal = newVal;
        newVal = oldVal & 0xFFFFFFBF;
        this.workerThread.setOps(this.selectionKey, 0);
        if (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
            int ops = oldVal & MASK_OPS;
            boolean resume = false;
            do {
                if (Bits.allAreSet((int)oldVal, (int)128) == resume) continue;
                resume = !resume;
                this.workerThread.setOps(this.selectionKey, resume ? ops : 0);
            } while (!stateUpdater.compareAndSet(this, oldVal = this.state, newVal = oldVal & 0xFFFFFFBF));
        }
    }

    boolean isResumed() {
        return Bits.allAreSet((int)this.state, (int)128);
    }

    C getChannel() {
        return this.channel;
    }

    @Override
    public void run() {
        int newVal;
        int oldVal;
        while (!stateUpdater.compareAndSet(this, oldVal = this.state, newVal = oldVal & 0xFFFFFFDF)) {
        }
        ChannelListener listener = this.handlerSetter.get();
        if (listener == null) {
            Log.log.tracef("Null listener; suspending %s to prevent runaway", (Object)this);
            this.suspend();
        } else if (Bits.allAreSet((int)oldVal, (int)128)) {
            ChannelListeners.invokeChannelListener(this.channel, (ChannelListener)listener);
        }
    }

    void execute() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)32)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x20));
        this.workerThread.execute(this);
    }
}

