/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ScatteringByteChannel;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.IoUtils;
import org.xnio.nio.AbstractNioStreamChannel;
import org.xnio.nio.NioXnioWorker;

final class NioPipeChannel
extends AbstractNioStreamChannel<NioPipeChannel> {
    private final Pipe.SourceChannel sourceChannel;
    private final Pipe.SinkChannel sinkChannel;
    private volatile int closeBits = 0;
    private static final AtomicIntegerFieldUpdater<NioPipeChannel> closeBitsUpdater = AtomicIntegerFieldUpdater.newUpdater(NioPipeChannel.class, "closeBits");

    NioPipeChannel(NioXnioWorker worker, Pipe.SinkChannel sinkChannel, Pipe.SourceChannel sourceChannel) throws ClosedChannelException {
        super(worker);
        this.sinkChannel = sinkChannel;
        this.sourceChannel = sourceChannel;
    }

    @Override
    protected ScatteringByteChannel getReadChannel() {
        return this.sourceChannel;
    }

    @Override
    protected GatheringByteChannel getWriteChannel() {
        return this.sinkChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReads() throws IOException {
        int old = NioPipeChannel.setBits(this, 2);
        if ((old & 2) == 0) {
            try {
                try {
                    this.cancelReadKey();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.sourceChannel.close();
            }
            finally {
                if (old == 1) {
                    this.invokeCloseHandler();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownWrites() throws IOException {
        int old = NioPipeChannel.setBits(this, 1);
        if ((old & 1) == 0) {
            try {
                try {
                    this.cancelWriteKey();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.sinkChannel.close();
            }
            finally {
                if (old == 2) {
                    this.invokeCloseHandler();
                }
            }
        }
    }

    public boolean isOpen() {
        return this.closeBits < 3;
    }

    private static int setBits(NioPipeChannel instance, int bits) {
        int old;
        int updated;
        while ((updated = (old = instance.closeBits) | bits) != old && !closeBitsUpdater.compareAndSet(instance, old, updated)) {
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block15: {
            int old = NioPipeChannel.setBits(this, 3);
            if (old != 3) {
                try {
                    if (old == 0) {
                        try {
                            this.cancelReadKey();
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                        try {
                            this.cancelWriteKey();
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                        IoUtils.safeClose((Closeable)this.sourceChannel);
                        this.sinkChannel.close();
                        break block15;
                    }
                    if (old == 1) {
                        try {
                            this.cancelReadKey();
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                        this.sourceChannel.close();
                        break block15;
                    }
                    assert (old == 2);
                    try {
                        this.cancelWriteKey();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.sinkChannel.close();
                }
                finally {
                    this.invokeCloseHandler();
                }
            }
        }
    }

    public String toString() {
        return String.format("pipe channel (NIO) <%h>", this);
    }
}

