/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.nio.AbstractNioChannel;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioTcpChannel;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

final class NioTcpServer
extends AbstractNioChannel<NioTcpServer>
implements AcceptingChannel<NioTcpChannel> {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio.tcp.server");
    private static final String FQCN = NioTcpServer.class.getName();
    private final ChannelListener.SimpleSetter<NioTcpServer> acceptSetter = new ChannelListener.SimpleSetter();
    private final List<NioHandle<NioTcpServer>> acceptHandles;
    private final ServerSocketChannel channel;
    private final ServerSocket socket;
    private static final Set<Option<?>> options = Option.setBuilder().add(Options.REUSE_ADDRESSES).add(Options.RECEIVE_BUFFER).add(Options.SEND_BUFFER).add(Options.KEEP_ALIVE).add(Options.TCP_OOB_INLINE).add(Options.TCP_NODELAY).add(Options.CONNECTION_HIGH_WATER).add(Options.CONNECTION_LOW_WATER).add(Options.READ_TIMEOUT).add(Options.WRITE_TIMEOUT).create();
    private volatile int keepAlive;
    private volatile int oobInline;
    private volatile int tcpNoDelay;
    private volatile int sendBuffer = -1;
    private volatile long connectionStatus = CONN_LOW_MASK | CONN_HIGH_MASK;
    private volatile int readTimeout = 0;
    private volatile int writeTimeout = 0;
    private volatile Thread waitingThread;
    private static final int CONN_MAX = 1048575;
    private static final long CONN_COUNT_MASK = Bits.longBitMask((int)0, (int)19);
    private static final long CONN_COUNT_BIT = 0L;
    private static final long CONN_COUNT_ONE = 1L;
    private static final long CONN_LOW_MASK = Bits.longBitMask((int)20, (int)39);
    private static final long CONN_LOW_BIT = 20L;
    private static final long CONN_LOW_ONE = 0x100000L;
    private static final long CONN_HIGH_MASK = Bits.longBitMask((int)40, (int)59);
    private static final long CONN_HIGH_BIT = 40L;
    private static final long CONN_HIGH_ONE = 0x10000000000L;
    private static final long CONN_SUSPENDING = 0x1000000000000000L;
    private static final long CONN_FULL = 0x2000000000000000L;
    private static final long CONN_RESUMED = 0x4000000000000000L;
    private static final AtomicIntegerFieldUpdater<NioTcpServer> keepAliveUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "keepAlive");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> oobInlineUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "oobInline");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> tcpNoDelayUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "tcpNoDelay");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> sendBufferUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "sendBuffer");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> readTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "readTimeout");
    private static final AtomicIntegerFieldUpdater<NioTcpServer> writeTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpServer.class, "writeTimeout");
    private static final AtomicLongFieldUpdater<NioTcpServer> connectionStatusUpdater = AtomicLongFieldUpdater.newUpdater(NioTcpServer.class, "connectionStatus");
    private static final AtomicReferenceFieldUpdater<NioTcpServer, Thread> waitingThreadUpdater = AtomicReferenceFieldUpdater.newUpdater(NioTcpServer.class, Thread.class, "waitingThread");

    NioTcpServer(NioXnioWorker worker, ServerSocketChannel channel, OptionMap optionMap) throws IOException {
        super(worker);
        this.channel = channel;
        boolean write = optionMap.get(Options.WORKER_ESTABLISH_WRITING, false);
        int count = optionMap.get(Options.WORKER_ACCEPT_THREADS, 1);
        WorkerThread[] threads = worker.choose(count, write);
        NioHandle[] handles = new NioHandle[threads.length];
        int length = threads.length;
        for (int i = 0; i < length; ++i) {
            handles[i] = threads[i].addChannel(channel, this, 0, this.acceptSetter);
        }
        this.acceptHandles = Arrays.asList(handles);
        this.socket = channel.socket();
        if (optionMap.contains(Options.REUSE_ADDRESSES)) {
            this.socket.setReuseAddress(optionMap.get(Options.REUSE_ADDRESSES, false));
        }
        if (optionMap.contains(Options.RECEIVE_BUFFER)) {
            this.socket.setReceiveBufferSize(optionMap.get(Options.RECEIVE_BUFFER, 0));
        }
        if (optionMap.contains(Options.SEND_BUFFER)) {
            sendBufferUpdater.set(this, optionMap.get(Options.SEND_BUFFER, 0));
        }
        if (optionMap.contains(Options.KEEP_ALIVE)) {
            keepAliveUpdater.set(this, optionMap.get(Options.KEEP_ALIVE, false) ? 1 : 0);
        }
        if (optionMap.contains(Options.TCP_OOB_INLINE)) {
            oobInlineUpdater.set(this, optionMap.get(Options.TCP_OOB_INLINE, false) ? 1 : 0);
        }
        if (optionMap.contains(Options.TCP_NODELAY)) {
            tcpNoDelayUpdater.set(this, optionMap.get(Options.TCP_NODELAY, false) ? 1 : 0);
        }
        if (optionMap.contains(Options.READ_TIMEOUT)) {
            readTimeoutUpdater.set(this, optionMap.get(Options.READ_TIMEOUT, 0));
        }
        if (optionMap.contains(Options.WRITE_TIMEOUT)) {
            writeTimeoutUpdater.set(this, optionMap.get(Options.WRITE_TIMEOUT, 0));
        }
        if (optionMap.contains(Options.CONNECTION_HIGH_WATER) || optionMap.contains(Options.CONNECTION_LOW_WATER)) {
            int highWater = optionMap.get(Options.CONNECTION_HIGH_WATER, 1048575);
            int lowWater = optionMap.get(Options.CONNECTION_LOW_WATER, highWater);
            if (highWater <= 0 || highWater > 1048575) {
                throw NioTcpServer.badHighWater();
            }
            if (lowWater <= 0 || lowWater > highWater) {
                throw NioTcpServer.badLowWater(highWater);
            }
            long highLowWater = (long)highWater << 40 | (long)lowWater << 20;
            connectionStatusUpdater.set(this, highLowWater);
        }
    }

    private static IllegalArgumentException badLowWater(int highWater) {
        return new IllegalArgumentException("Low water must be greater than 0 and less than or equal to high water (" + highWater + ")");
    }

    private static IllegalArgumentException badHighWater() {
        return new IllegalArgumentException("High water must be greater than 0 and less than or equal to 1048575");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.channel.close();
        }
        finally {
            for (NioHandle<NioTcpServer> handle : this.acceptHandles) {
                handle.cancelKey();
            }
        }
    }

    public boolean supportsOption(Option<?> option) {
        return options.contains(option);
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        if (option == Options.REUSE_ADDRESSES) {
            return (T)option.cast((Object)this.socket.getReuseAddress());
        }
        if (option == Options.RECEIVE_BUFFER) {
            return (T)option.cast((Object)this.socket.getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            int value = this.sendBuffer;
            return (T)(value == -1 ? null : option.cast((Object)value));
        }
        if (option == Options.KEEP_ALIVE) {
            return (T)option.cast((Object)(this.keepAlive != 0 ? 1 : 0));
        }
        if (option == Options.TCP_OOB_INLINE) {
            return (T)option.cast((Object)(this.oobInline != 0 ? 1 : 0));
        }
        if (option == Options.TCP_NODELAY) {
            return (T)option.cast((Object)(this.tcpNoDelay != 0 ? 1 : 0));
        }
        if (option == Options.READ_TIMEOUT) {
            return (T)option.cast((Object)this.readTimeout);
        }
        if (option == Options.WRITE_TIMEOUT) {
            return (T)option.cast((Object)this.writeTimeout);
        }
        if (option == Options.CONNECTION_HIGH_WATER) {
            return (T)option.cast((Object)NioTcpServer.getHighWater(this.connectionStatus));
        }
        if (option == Options.CONNECTION_LOW_WATER) {
            return (T)option.cast((Object)NioTcpServer.getLowWater(this.connectionStatus));
        }
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Comparable<Boolean> old;
        if (option == Options.REUSE_ADDRESSES) {
            old = this.socket.getReuseAddress();
            this.socket.setReuseAddress((Boolean)Options.REUSE_ADDRESSES.cast(value));
        } else if (option == Options.RECEIVE_BUFFER) {
            old = this.socket.getReceiveBufferSize();
            this.socket.setReceiveBufferSize((Integer)Options.RECEIVE_BUFFER.cast(value));
        } else if (option == Options.SEND_BUFFER) {
            int newValue;
            int n = newValue = value == null ? -1 : (Integer)Options.SEND_BUFFER.cast(value);
            if (value != null && newValue < 1) {
                throw new IllegalArgumentException("Bad send buffer size specified");
            }
            int oldValue = sendBufferUpdater.getAndSet(this, newValue);
            old = oldValue == -1 ? null : Integer.valueOf(oldValue);
        } else if (option == Options.KEEP_ALIVE) {
            old = keepAliveUpdater.getAndSet(this, (Boolean)Options.KEEP_ALIVE.cast(value) != false ? 1 : 0) != 0;
        } else if (option == Options.TCP_OOB_INLINE) {
            old = oobInlineUpdater.getAndSet(this, (Boolean)Options.TCP_OOB_INLINE.cast(value) != false ? 1 : 0) != 0;
        } else if (option == Options.TCP_NODELAY) {
            old = tcpNoDelayUpdater.getAndSet(this, (Boolean)Options.TCP_NODELAY.cast(value) != false ? 1 : 0) != 0;
        } else if (option == Options.READ_TIMEOUT) {
            old = readTimeoutUpdater.getAndSet(this, (Integer)Options.READ_TIMEOUT.cast(value));
        } else if (option == Options.WRITE_TIMEOUT) {
            old = writeTimeoutUpdater.getAndSet(this, (Integer)Options.WRITE_TIMEOUT.cast(value));
        } else if (option == Options.CONNECTION_HIGH_WATER) {
            old = NioTcpServer.getHighWater(this.updateWaterMark(-1, (Integer)Options.CONNECTION_LOW_WATER.cast(value)));
        } else if (option == Options.CONNECTION_LOW_WATER) {
            old = NioTcpServer.getLowWater(this.updateWaterMark((Integer)Options.CONNECTION_LOW_WATER.cast(value), -1));
        } else {
            return null;
        }
        return (T)option.cast((Object)old);
    }

    private long updateWaterMark(int reqNewLowWater, int reqNewHighWater) {
        Thread thread;
        long newVal;
        long oldVal;
        assert (reqNewLowWater != -1 || reqNewHighWater != -1);
        assert (reqNewLowWater == -1 || reqNewHighWater == -1 || reqNewLowWater <= reqNewHighWater);
        do {
            int newHighWater;
            oldVal = this.connectionStatus;
            int oldLowWater = NioTcpServer.getLowWater(oldVal);
            int oldHighWater = NioTcpServer.getHighWater(oldVal);
            int connCount = NioTcpServer.getCount(oldVal);
            int newLowWater = reqNewLowWater == -1 ? oldLowWater : reqNewLowWater;
            int n = newHighWater = reqNewHighWater == -1 ? oldHighWater : reqNewHighWater;
            if (reqNewLowWater != -1 && newLowWater > newHighWater) {
                newHighWater = newLowWater;
            } else if (reqNewHighWater != -1 && newHighWater < newLowWater) {
                newLowWater = newHighWater;
            }
            if (oldLowWater == newLowWater && oldHighWater == newHighWater) {
                return oldVal;
            }
            newVal = NioTcpServer.withLowWater(NioTcpServer.withHighWater(oldVal, newHighWater), newLowWater);
            if (Bits.allAreClear((long)oldVal, (long)0x2000000000000000L) && oldHighWater > connCount && newHighWater < connCount) {
                newVal |= 0x3000000000000000L;
                continue;
            }
            if (!Bits.allAreSet((long)oldVal, (long)0x2000000000000000L) || oldLowWater >= connCount || newLowWater <= connCount) continue;
            newVal &= 0x2000000000000000L;
            newVal |= 0x1000000000000000L;
        } while (!connectionStatusUpdater.compareAndSet(this, oldVal, newVal));
        if (Bits.allAreSet((long)oldVal, (long)0x2000000000000000L) && Bits.allAreClear((long)newVal, (long)0x2000000000000000L) && (thread = (Thread)waitingThreadUpdater.getAndSet(this, null)) != null) {
            LockSupport.unpark(thread);
        }
        if (Bits.allAreClear((long)oldVal, (long)0x1000000000000000L) && Bits.allAreSet((long)newVal, (long)0x1000000000000000L)) {
            if (Bits.allAreSet((long)newVal, (long)0x2000000000000000L)) {
                this.doResume(0);
                this.synchronizeConnectionState(newVal, true);
            } else {
                this.doResume(16);
                this.synchronizeConnectionState(newVal, false);
            }
        }
        return newVal;
    }

    private static int getHighWater(long value) {
        return (int)((value & CONN_HIGH_MASK) >> 40);
    }

    private static int getLowWater(long value) {
        return (int)((value & CONN_LOW_MASK) >> 20);
    }

    private static int getCount(long value) {
        return (int)((value & CONN_COUNT_MASK) >> 0);
    }

    private static long withHighWater(long oldValue, int highWater) {
        return oldValue & (CONN_HIGH_MASK ^ 0xFFFFFFFFFFFFFFFFL) | (long)highWater << 40;
    }

    private static long withLowWater(long oldValue, int lowWater) {
        return oldValue & (CONN_LOW_MASK ^ 0xFFFFFFFFFFFFFFFFL) | (long)lowWater << 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioTcpChannel accept() throws IOException {
        NioTcpChannel newChannel;
        SocketChannel accepted;
        long newVal;
        long oldVal;
        do {
            if (Bits.allAreSet((long)(oldVal = this.connectionStatus), (long)0x2000000000000000L)) {
                log.trace((Object)"No connection accepted (full)");
                return null;
            }
            newVal = oldVal + 1L;
            if (NioTcpServer.getCount(newVal) <= NioTcpServer.getHighWater(newVal)) continue;
            newVal |= 0x3000000000000000L;
        } while (!connectionStatusUpdater.compareAndSet(this, oldVal, newVal));
        boolean wasSuspended = Bits.anyAreSet((long)oldVal, (long)0x2000000000000000L) || Bits.allAreClear((long)oldVal, (long)0x4000000000000000L);
        boolean doSuspend = !wasSuspended && Bits.allAreClear((long)oldVal, (long)0x1000000000000000L) && Bits.allAreSet((long)newVal, (long)0x3000000000000000L);
        try {
            accepted = this.channel.accept();
        }
        catch (IOException e) {
            this.undoAccept(newVal, wasSuspended, doSuspend);
            log.tracef("No connection accepted (%s)", (Object)e);
            return null;
        }
        if (accepted == null) {
            this.undoAccept(newVal, wasSuspended, doSuspend);
            log.trace((Object)"No connection accepted");
            return null;
        }
        boolean ok = false;
        try {
            accepted.configureBlocking(false);
            Socket socket = accepted.socket();
            socket.setKeepAlive(this.keepAlive != 0);
            socket.setOOBInline(this.oobInline != 0);
            socket.setTcpNoDelay(this.tcpNoDelay != 0);
            int sendBuffer = this.sendBuffer;
            if (sendBuffer > 0) {
                socket.setSendBufferSize(sendBuffer);
            }
            newChannel = new NioTcpChannel(this.worker, this, accepted);
            newChannel.setOption(Options.READ_TIMEOUT, this.readTimeout);
            newChannel.setOption(Options.WRITE_TIMEOUT, this.writeTimeout);
            ok = true;
            log.trace((Object)"TCP server accepted connection");
        }
        finally {
            if (!ok) {
                log.trace((Object)"Failed to accept a connection, undoing");
                this.undoAccept(newVal, wasSuspended, doSuspend);
                IoUtils.safeClose((Closeable)accepted);
            }
        }
        if (doSuspend) {
            if (Bits.allAreSet((long)oldVal, (long)0x4000000000000000L)) {
                this.doResume(0);
            }
            this.synchronizeConnectionState(oldVal, doSuspend);
        }
        return newChannel;
    }

    private void synchronizeConnectionState(long oldVal, boolean suspended) {
        long newVal = oldVal & 0xEFFFFFFFFFFFFFFFL;
        while (!connectionStatusUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.connectionStatus;
            if ((Bits.allAreClear((long)oldVal, (long)0x2000000000000000L) && Bits.allAreSet((long)oldVal, (long)0x4000000000000000L)) != suspended) {
                suspended = !suspended;
                this.doResume(suspended ? 0 : 16);
            }
            newVal = oldVal & 0xEFFFFFFFFFFFFFFFL;
        }
    }

    private void undoAccept(long newVal, boolean wasSuspended, boolean doSuspend) {
        Thread thread;
        long oldVal = newVal;
        newVal = oldVal - 1L;
        newVal &= 0xCFFFFFFFFFFFFFFFL;
        boolean bl = doSuspend = !doSuspend && !wasSuspended;
        while (!connectionStatusUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.connectionStatus;
            newVal = oldVal - 1L & 0xEFFFFFFFFFFFFFFFL;
            if (Bits.allAreSet((long)newVal, (long)0x2000000000000000L) && (newVal & CONN_COUNT_MASK) >> 0 <= (newVal & CONN_LOW_MASK) >> 20) {
                newVal &= 0xDFFFFFFFFFFFFFFFL;
            }
            if ((Bits.allAreClear((long)newVal, (long)0x2000000000000000L) && Bits.allAreSet((long)newVal, (long)0x4000000000000000L)) == doSuspend) continue;
            doSuspend = !doSuspend;
            this.doResume(doSuspend ? 0 : 16);
        }
        if (Bits.allAreSet((long)oldVal, (long)0x2000000000000000L) && Bits.allAreClear((long)newVal, (long)0x2000000000000000L) && (thread = (Thread)waitingThreadUpdater.getAndSet(this, null)) != null) {
            LockSupport.unpark(thread);
        }
    }

    void channelClosed() {
        Thread thread;
        long newVal;
        long oldVal;
        do {
            if (!Bits.allAreSet((long)(newVal = (oldVal = this.connectionStatus) - 1L), (long)0x2000000000000000L) || (newVal & CONN_COUNT_MASK) >> 0 > (newVal & CONN_LOW_MASK) >> 20 || !Bits.allAreSet((long)(newVal &= 0xDFFFFFFFFFFFFFFFL), (long)0x4000000000000000L)) continue;
            newVal |= 0x1000000000000000L;
        } while (!connectionStatusUpdater.compareAndSet(this, oldVal, newVal));
        if (Bits.allAreSet((long)oldVal, (long)0x2000000000000000L) && Bits.allAreClear((long)newVal, (long)0x2000000000000000L) && (thread = (Thread)waitingThreadUpdater.getAndSet(this, null)) != null) {
            LockSupport.unpark(thread);
        }
        if (Bits.allAreSet((long)oldVal, (long)0x1000000000000000L) || Bits.allAreClear((long)newVal, (long)0x1000000000000000L)) {
            return;
        }
        boolean doSuspend = false;
        this.doResume(16);
        oldVal = newVal;
        newVal &= 0xEFFFFFFFFFFFFFFFL;
        while (!connectionStatusUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.connectionStatus;
            newVal = oldVal - 1L & 0xEFFFFFFFFFFFFFFFL;
            if (Bits.allAreSet((long)newVal, (long)0x2000000000000000L) && (newVal & CONN_COUNT_MASK) >> 0 <= (newVal & CONN_LOW_MASK) >> 20) {
                newVal &= 0xDFFFFFFFFFFFFFFFL;
            }
            if ((Bits.allAreClear((long)newVal, (long)0x2000000000000000L) && Bits.allAreSet((long)newVal, (long)0x4000000000000000L)) == doSuspend) continue;
            doSuspend = !doSuspend;
            this.doResume(doSuspend ? 0 : 16);
        }
    }

    public String toString() {
        return String.format("TCP server (NIO) <%s>", Integer.toHexString(this.hashCode()));
    }

    public ChannelListener.SimpleSetter<NioTcpServer> getAcceptSetter() {
        return this.acceptSetter;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public SocketAddress getLocalAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        SocketAddress address = this.getLocalAddress();
        return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
    }

    public void suspendAccepts() {
        this.doResumeWithFlag(false);
    }

    public void resumeAccepts() {
        this.doResumeWithFlag(true);
    }

    private void doResumeWithFlag(boolean flag) {
        long newVal;
        long oldVal;
        do {
            if (Bits.allAreSet((long)(oldVal = this.connectionStatus), (long)0x4000000000000000L) != flag) continue;
            return;
        } while (!connectionStatusUpdater.compareAndSet(this, oldVal, newVal = oldVal ^ 0x4000000000000000L | 0x1000000000000000L));
        if (Bits.anyAreSet((long)oldVal, (long)0x3000000000000000L)) {
            return;
        }
        oldVal = newVal;
        newVal = oldVal & 0xEFFFFFFFFFFFFFFFL;
        this.doResume(flag ? 16 : 0);
        if (connectionStatusUpdater.compareAndSet(this, oldVal, newVal)) {
            return;
        }
        do {
            if ((Bits.allAreSet((long)(oldVal = this.connectionStatus), (long)0x4000000000000000L) && Bits.allAreClear((long)oldVal, (long)0x2000000000000000L)) == flag) continue;
            flag = !flag;
            this.doResume(flag ? 16 : 0);
        } while (!connectionStatusUpdater.compareAndSet(this, oldVal, newVal = oldVal & 0xEFFFFFFFFFFFFFFFL));
    }

    private void doResume(int op) {
        for (NioHandle<NioTcpServer> handle : this.acceptHandles) {
            handle.resume(op);
        }
    }

    public void wakeupAccepts() {
        log.logf(FQCN, Logger.Level.TRACE, null, "Wake up accepts on %s", (Object)this);
        this.resumeAccepts();
        List<NioHandle<NioTcpServer>> handles = this.acceptHandles;
        int len = handles.size();
        if (len == 0) {
            throw new IllegalArgumentException("No thread configured");
        }
        int idx = IoUtils.getThreadLocalRandom().nextInt(len);
        this.acceptHandles.get(idx).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitAcceptable() throws IOException {
        Thread thread = Thread.currentThread();
        long val = this.connectionStatus;
        while (true) {
            if (Bits.allAreSet((long)val, (long)0x2000000000000000L)) {
                Thread nextThread = waitingThreadUpdater.getAndSet(this, thread);
                try {
                    if (Bits.allAreSet((long)this.connectionStatus, (long)0x2000000000000000L)) {
                        LockSupport.park(this);
                    }
                }
                finally {
                    if (nextThread != null) {
                        LockSupport.unpark(nextThread);
                    }
                }
                if (thread.isInterrupted()) {
                    throw new InterruptedIOException();
                }
                val = this.connectionStatus;
                continue;
            }
            SelectorUtils.await(this.worker.getXnio(), this.channel, 16);
            val = this.connectionStatus;
            if (Bits.allAreClear((long)val, (long)0x2000000000000000L)) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void awaitAcceptable(long time, TimeUnit timeUnit) throws IOException {
        then = System.nanoTime();
        duration = timeUnit.toNanos(time);
        thread = Thread.currentThread();
        val = this.connectionStatus;
        do lbl-1000:
        // 3 sources

        {
            block8: {
                if (!Bits.allAreSet((long)val, (long)0x2000000000000000L)) break block8;
                nextThread = NioTcpServer.waitingThreadUpdater.getAndSet(this, thread);
                try {
                    if (Bits.allAreSet((long)this.connectionStatus, (long)0x2000000000000000L)) {
                        LockSupport.parkNanos(this, duration);
                    }
                }
                finally {
                    if (nextThread != null) {
                        LockSupport.unpark(nextThread);
                    }
                }
                if (thread.isInterrupted()) {
                    throw new InterruptedIOException();
                }
                val = this.connectionStatus;
                now = System.nanoTime();
                if ((duration -= now - (then = now)) > 0L) ** GOTO lbl-1000
                return;
            }
            SelectorUtils.await(this.worker.getXnio(), this.channel, 16, duration, TimeUnit.NANOSECONDS);
            val = this.connectionStatus;
            if (!Bits.allAreClear((long)val, (long)0x2000000000000000L)) continue;
            return;
        } while ((duration -= (now = System.nanoTime()) - (then = now)) > 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void migrateTo(NioXnioWorker worker) throws ClosedChannelException {
        boolean ok = false;
        WorkerThread acceptThread = worker.choose(true);
        try {
            List<NioHandle<NioTcpServer>> handles = this.acceptHandles;
            for (int i = 0; i < handles.size(); ++i) {
                NioHandle<NioTcpServer> oldHandle = handles.get(i);
                oldHandle.cancelKey();
                handles.set(i, acceptThread.addChannel(this.channel, this.typed(), 0, this.acceptSetter));
            }
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)((Object)this));
            } else {
                super.migrateTo(worker);
            }
        }
    }
}

