/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.ScatteringByteChannel;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.nio.AbstractNioStreamSourceChannel;
import org.xnio.nio.NioXnioWorker;

final class NioPipeSourceChannel
extends AbstractNioStreamSourceChannel<NioPipeSourceChannel> {
    private final Pipe.SourceChannel sourceChannel;
    private volatile int closed = 0;
    private static final AtomicIntegerFieldUpdater<NioPipeSourceChannel> closedUpdater = AtomicIntegerFieldUpdater.newUpdater(NioPipeSourceChannel.class, "closed");

    NioPipeSourceChannel(NioXnioWorker worker, Pipe.SourceChannel sourceChannel) throws ClosedChannelException {
        super(worker);
        this.sourceChannel = sourceChannel;
    }

    @Override
    protected ScatteringByteChannel getReadChannel() {
        return this.sourceChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReads() throws IOException {
        if (closedUpdater.compareAndSet(this, 0, 1)) {
            try {
                this.sourceChannel.close();
            }
            finally {
                this.invokeCloseHandler();
            }
        }
    }

    public boolean isOpen() {
        return this.sourceChannel.isOpen();
    }

    public void close() throws IOException {
        this.shutdownReads();
    }
}

