/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.Pipe;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.nio.AbstractNioStreamSinkChannel;
import org.xnio.nio.NioXnioWorker;

final class NioPipeSinkChannel
extends AbstractNioStreamSinkChannel<NioPipeSinkChannel> {
    private final Pipe.SinkChannel sinkChannel;
    private volatile int closed = 0;
    private static final AtomicIntegerFieldUpdater<NioPipeSinkChannel> closedUpdater = AtomicIntegerFieldUpdater.newUpdater(NioPipeSinkChannel.class, "closed");

    NioPipeSinkChannel(NioXnioWorker worker, Pipe.SinkChannel sinkChannel) throws ClosedChannelException {
        super(worker);
        this.sinkChannel = sinkChannel;
    }

    @Override
    protected GatheringByteChannel getWriteChannel() {
        return this.sinkChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownWrites() throws IOException {
        if (closedUpdater.compareAndSet(this, 0, 1)) {
            try {
                this.sinkChannel.close();
            }
            finally {
                this.invokeCloseHandler();
            }
        }
    }

    public boolean isOpen() {
        return this.sinkChannel.isOpen();
    }

    public void close() throws IOException {
        this.shutdownWrites();
    }
}

