/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.XnioWorker;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.nio.AbstractNioStreamChannel;
import org.xnio.nio.NioXnioWorker;

final class NioTcpChannel
extends AbstractNioStreamChannel<NioTcpChannel>
implements ConnectedStreamChannel {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio.tcp.channel");
    private final SocketChannel socketChannel;
    private final Socket socket;
    private volatile int closeBits = 0;
    private static final AtomicIntegerFieldUpdater<NioTcpChannel> closeBitsUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpChannel.class, "closeBits");
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.CLOSE_ABORT).add(Options.KEEP_ALIVE).add(Options.TCP_OOB_INLINE).add(Options.RECEIVE_BUFFER).add(Options.SEND_BUFFER).add(Options.TCP_NODELAY).add(Options.IP_TRAFFIC_CLASS).create();

    NioTcpChannel(NioXnioWorker worker, SocketChannel socketChannel) throws ClosedChannelException {
        super(worker);
        this.socketChannel = socketChannel;
        this.socket = socketChannel.socket();
        this.start();
    }

    void configureFrom(OptionMap optionMap) throws IOException {
        for (Option option : optionMap) {
            if (!this.supportsOption(option)) continue;
            try {
                this.doSetOption(option, optionMap);
            }
            catch (IOException ignored) {}
        }
    }

    private <T> void doSetOption(Option<T> option, OptionMap map) throws IOException {
        this.setOption(option, option.cast(map.get(option)));
    }

    BoundChannel getBoundChannel() {
        return new BoundChannel(){

            public SocketAddress getLocalAddress() {
                return NioTcpChannel.this.getLocalAddress();
            }

            public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
                SocketAddress address = this.getLocalAddress();
                return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
            }

            public ChannelListener.Setter<? extends BoundChannel> getCloseSetter() {
                return NioTcpChannel.this.getCloseSetter();
            }

            public boolean isOpen() {
                return NioTcpChannel.this.isOpen();
            }

            public void close() throws IOException {
                NioTcpChannel.this.close();
            }

            public boolean supportsOption(Option<?> option) {
                return NioTcpChannel.this.supportsOption(option);
            }

            public <T> T getOption(Option<T> option) throws IOException {
                return NioTcpChannel.this.getOption(option);
            }

            public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                return NioTcpChannel.this.setOption(option, value);
            }

            public XnioWorker getWorker() {
                return NioTcpChannel.this.getWorker();
            }
        };
    }

    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    protected SocketChannel getReadChannel() {
        return this.socketChannel;
    }

    @Override
    protected SocketChannel getWriteChannel() {
        return this.socketChannel;
    }

    private static int setBits(NioTcpChannel instance, int bits) {
        int old;
        int updated;
        while ((updated = (old = instance.closeBits) | bits) != old && !closeBitsUpdater.compareAndSet(instance, old, updated)) {
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (NioTcpChannel.setBits(this, 3) != 3) {
            log.tracef("Closing %s", (Object)this);
            try {
                this.socketChannel.close();
            }
            finally {
                this.cancelReadKey();
                this.cancelWriteKey();
                this.invokeCloseHandler();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReads() throws IOException {
        block15: {
            int old = NioTcpChannel.setBits(this, 2);
            if ((old & 2) == 0) {
                try {
                    log.tracef("Shutting down reads on %s", (Object)this);
                    this.socket.shutdownInput();
                }
                catch (IOException iOException) {
                    this.cancelReadKey();
                    if (old != 1) break block15;
                    try {
                        this.socketChannel.close();
                    }
                    finally {
                        this.invokeCloseHandler();
                    }
                }
                finally {
                    this.cancelReadKey();
                    if (old == 1) {
                        try {
                            this.socketChannel.close();
                        }
                        finally {
                            this.invokeCloseHandler();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownWrites() throws IOException {
        block15: {
            int old = NioTcpChannel.setBits(this, 1);
            if ((old & 1) == 0) {
                try {
                    log.tracef("Shutting down writes on %s", (Object)this);
                    this.socket.shutdownOutput();
                }
                catch (IOException iOException) {
                    this.cancelWriteKey();
                    if (old != 2) break block15;
                    try {
                        this.socketChannel.close();
                    }
                    finally {
                        this.invokeCloseHandler();
                    }
                }
                finally {
                    this.cancelWriteKey();
                    if (old == 2) {
                        try {
                            this.socketChannel.close();
                        }
                        finally {
                            this.invokeCloseHandler();
                        }
                    }
                }
            }
        }
    }

    InetSocketAddress getPeerInetAddress() {
        Socket socket = this.socket;
        return new InetSocketAddress(socket.getInetAddress(), socket.getPort());
    }

    InetSocketAddress getLocalInetAddress() {
        Socket socket = this.socket;
        return new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
    }

    public SocketAddress getPeerAddress() {
        return this.getPeerInetAddress();
    }

    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return (A)(type == InetSocketAddress.class ? (SocketAddress)type.cast(this.getPeerInetAddress()) : null);
    }

    public SocketAddress getLocalAddress() {
        return this.getLocalInetAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)(type == InetSocketAddress.class ? (SocketAddress)type.cast(this.getLocalInetAddress()) : null);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option) || super.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        if (option == Options.CLOSE_ABORT) {
            return (T)option.cast((Object)(this.socket.getSoLinger() != -1 ? 1 : 0));
        }
        if (option == Options.KEEP_ALIVE) {
            return (T)option.cast((Object)this.socket.getKeepAlive());
        }
        if (option == Options.TCP_OOB_INLINE) {
            return (T)option.cast((Object)this.socket.getOOBInline());
        }
        if (option == Options.RECEIVE_BUFFER) {
            return (T)option.cast((Object)this.socket.getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            return (T)option.cast((Object)this.socket.getSendBufferSize());
        }
        if (option == Options.TCP_NODELAY) {
            return (T)option.cast((Object)this.socket.getTcpNoDelay());
        }
        if (option == Options.IP_TRAFFIC_CLASS) {
            return (T)option.cast((Object)this.socket.getTrafficClass());
        }
        return super.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Comparable<Boolean> old;
        if (option == Options.CLOSE_ABORT) {
            old = this.socket.getSoLinger() != 0;
            this.socket.setSoLinger((Boolean)value, 0);
        } else if (option == Options.KEEP_ALIVE) {
            old = this.socket.getKeepAlive();
            this.socket.setKeepAlive((Boolean)value);
        } else if (option == Options.TCP_OOB_INLINE) {
            old = this.socket.getOOBInline();
            this.socket.setOOBInline((Boolean)value);
        } else if (option == Options.RECEIVE_BUFFER) {
            old = this.socket.getReceiveBufferSize();
            this.socket.setReceiveBufferSize((Integer)value);
        } else if (option == Options.SEND_BUFFER) {
            old = this.socket.getSendBufferSize();
            this.socket.setSendBufferSize((Integer)value);
        } else if (option == Options.TCP_NODELAY) {
            old = this.socket.getTcpNoDelay();
            this.socket.setTcpNoDelay((Boolean)value);
        } else if (option == Options.IP_TRAFFIC_CLASS) {
            old = this.socket.getTrafficClass();
            this.socket.setTrafficClass((Integer)value);
        } else {
            return super.setOption(option, value);
        }
        return (T)option.cast((Object)old);
    }

    public String toString() {
        return String.format("TCP socket channel (NIO) <%h>", this);
    }
}

