/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.WriteTimeoutException;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

abstract class AbstractNioStreamChannel<C extends AbstractNioStreamChannel<C>>
implements StreamChannel {
    private static final String FQCN = AbstractNioStreamChannel.class.getName();
    private final NioXnioWorker worker;
    private volatile NioHandle<C> readHandle;
    private volatile NioHandle<C> writeHandle;
    private volatile int readTimeout = 0;
    private volatile int writeTimeout = 0;
    private volatile long lastRead;
    private volatile long lastWrite;
    private final ChannelListener.SimpleSetter<C> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> closeSetter = new ChannelListener.SimpleSetter();
    private static final AtomicIntegerFieldUpdater<AbstractNioStreamChannel> readTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractNioStreamChannel.class, "readTimeout");
    private static final AtomicIntegerFieldUpdater<AbstractNioStreamChannel> writeTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractNioStreamChannel.class, "writeTimeout");
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.READ_TIMEOUT).add(Options.WRITE_TIMEOUT).create();

    AbstractNioStreamChannel(NioXnioWorker worker) throws ClosedChannelException {
        this.worker = worker;
    }

    void start() throws ClosedChannelException {
        WorkerThread readThread = this.worker.chooseOptional(false);
        WorkerThread writeThread = this.worker.chooseOptional(true);
        this.readHandle = readThread == null ? null : readThread.addChannel((AbstractSelectableChannel)((Object)this.getReadChannel()), this.typed(), 0, this.readSetter);
        this.writeHandle = writeThread == null ? null : writeThread.addChannel((AbstractSelectableChannel)((Object)this.getWriteChannel()), this.typed(), 0, this.writeSetter);
        this.lastRead = this.lastWrite = System.nanoTime();
    }

    protected abstract ScatteringByteChannel getReadChannel();

    protected abstract GatheringByteChannel getWriteChannel();

    public XnioWorker getWorker() {
        return this.worker;
    }

    public final ChannelListener.Setter<? extends C> getReadSetter() {
        return this.readSetter;
    }

    public final ChannelListener.Setter<? extends C> getWriteSetter() {
        return this.writeSetter;
    }

    public final ChannelListener.Setter<? extends C> getCloseSetter() {
        return this.closeSetter;
    }

    public final void suspendReads() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Suspend reads on %s", (Object)this);
        NioHandle<C> readHandle = this.readHandle;
        if (readHandle != null) {
            readHandle.suspend();
        }
    }

    public final void resumeReads() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Resume reads on %s", (Object)this);
        NioHandle<C> readHandle = this.readHandle;
        if (readHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        readHandle.resume(1);
    }

    public boolean isReadResumed() {
        NioHandle<C> readHandle = this.readHandle;
        return readHandle != null && readHandle.isResumed(1);
    }

    public void wakeupReads() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Wake up reads on %s", (Object)this);
        NioHandle<C> readHandle = this.readHandle;
        if (readHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        readHandle.resume(1);
        readHandle.execute();
    }

    public final void suspendWrites() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Suspend writes on %s", (Object)this);
        NioHandle<C> writeHandle = this.writeHandle;
        if (writeHandle != null) {
            writeHandle.resume(0);
        }
    }

    public final void resumeWrites() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Resume writes on %s", (Object)this);
        NioHandle<C> writeHandle = this.writeHandle;
        if (writeHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        writeHandle.resume(4);
    }

    public boolean isWriteResumed() {
        NioHandle<C> writeHandle = this.writeHandle;
        return writeHandle != null && writeHandle.isResumed(4);
    }

    public void wakeupWrites() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Wake up writes on %s", (Object)this);
        NioHandle<C> writeHandle = this.writeHandle;
        if (writeHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        writeHandle.resume(4);
        writeHandle.execute();
    }

    public final void awaitReadable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getReadChannel()), 1);
    }

    public final void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getReadChannel()), 1, time, timeUnit);
    }

    public XnioExecutor getReadThread() {
        NioHandle<C> handle = this.readHandle;
        return handle == null ? null : handle.getWorkerThread();
    }

    public final void awaitWritable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getWriteChannel()), 4);
    }

    public final void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getWriteChannel()), 4, time, timeUnit);
    }

    public XnioExecutor getWriteThread() {
        NioHandle<C> handle = this.writeHandle;
        return handle == null ? null : handle.getWorkerThread();
    }

    public final long transferTo(long position, long count, FileChannel target) throws IOException {
        long res = target.transferFrom(this.getReadChannel(), position, count);
        if (res > 0L) {
            this.lastRead = System.nanoTime();
        } else {
            int timeout = this.readTimeout;
            if (timeout > 0 && (this.lastRead - System.nanoTime()) / 1000000L > (long)timeout) {
                throw new ReadTimeoutException("Read timed out");
            }
        }
        return res;
    }

    public final long transferFrom(FileChannel src, long position, long count) throws IOException {
        long res = src.transferTo(position, count, this.getWriteChannel());
        if (res > 0L) {
            this.lastWrite = System.nanoTime();
        } else {
            int timeout = this.writeTimeout;
            if (timeout > 0 && (this.lastWrite - System.nanoTime()) / 1000000L > (long)timeout) {
                throw new WriteTimeoutException("Write timed out");
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long transfer(long count, ByteBuffer throughBuffer, StreamSourceChannel source, StreamSinkChannel sink) throws IOException {
        long total = 0L;
        throughBuffer.clear();
        while (total < count) {
            long res;
            if (count - total < (long)throughBuffer.remaining()) {
                throughBuffer.limit((int)(count - total));
            }
            try {
                res = source.read(throughBuffer);
                if (res <= 0L) {
                    long l = total == 0L ? res : total;
                    return l;
                }
            }
            finally {
                throughBuffer.flip();
            }
            res = sink.write(throughBuffer);
            if (res == 0L) {
                return total;
            }
            throughBuffer.compact();
        }
        return total;
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return AbstractNioStreamChannel.transfer(count, throughBuffer, (StreamSourceChannel)this, target);
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return AbstractNioStreamChannel.transfer(count, throughBuffer, source, (StreamSinkChannel)this);
    }

    public boolean flush() throws IOException {
        return true;
    }

    public int read(ByteBuffer dst) throws IOException {
        int res;
        try {
            res = this.getReadChannel().read(dst);
        }
        catch (ClosedChannelException e) {
            return -1;
        }
        if (res > 0) {
            this.lastRead = System.nanoTime();
        } else {
            int timeout = this.readTimeout;
            if (timeout > 0 && (this.lastRead - System.nanoTime()) / 1000000L > (long)timeout) {
                throw new ReadTimeoutException("Read timed out");
            }
        }
        return res;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        long res;
        try {
            res = this.getReadChannel().read(dsts);
        }
        catch (ClosedChannelException e) {
            return -1L;
        }
        if (res > 0L) {
            this.lastRead = System.nanoTime();
        } else {
            int timeout = this.readTimeout;
            if (timeout > 0 && (this.lastRead - System.nanoTime()) / 1000000L > (long)timeout) {
                throw new ReadTimeoutException("Read timed out");
            }
        }
        return res;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long res;
        try {
            res = this.getReadChannel().read(dsts, offset, length);
        }
        catch (ClosedChannelException e) {
            return -1L;
        }
        if (res > 0L) {
            this.lastRead = System.nanoTime();
        } else {
            int timeout = this.readTimeout;
            if (timeout > 0 && (this.lastRead - System.nanoTime()) / 1000000L > (long)timeout) {
                throw new ReadTimeoutException("Read timed out");
            }
        }
        return res;
    }

    public int write(ByteBuffer src) throws IOException {
        int res = this.getWriteChannel().write(src);
        if ((long)res > 0L) {
            this.lastWrite = System.nanoTime();
        } else {
            int timeout = this.writeTimeout;
            if (timeout > 0 && (this.lastWrite - System.nanoTime()) / 1000000L > (long)timeout) {
                throw new WriteTimeoutException("Write timed out");
            }
        }
        return res;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        long res = this.getWriteChannel().write(srcs);
        if (res > 0L) {
            this.lastWrite = System.nanoTime();
        } else {
            int timeout = this.writeTimeout;
            if (timeout > 0 && (this.lastWrite - System.nanoTime()) / 1000000L > (long)timeout) {
                throw new WriteTimeoutException("Write timed out");
            }
        }
        return res;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long res = this.getWriteChannel().write(srcs, offset, length);
        if (res > 0L) {
            this.lastWrite = System.nanoTime();
        } else {
            int timeout = this.writeTimeout;
            if (timeout > 0 && (this.lastWrite - System.nanoTime()) / 1000000L > (long)timeout) {
                throw new WriteTimeoutException("Write timed out");
            }
        }
        return res;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.READ_TIMEOUT) {
            int newValue = (Integer)Options.READ_TIMEOUT.cast(value);
            return (T)option.cast((Object)readTimeoutUpdater.getAndSet(this, newValue));
        }
        if (option == Options.WRITE_TIMEOUT) {
            int newValue = (Integer)Options.WRITE_TIMEOUT.cast(value);
            return (T)option.cast((Object)writeTimeoutUpdater.getAndSet(this, newValue));
        }
        return null;
    }

    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.READ_TIMEOUT) {
            return (T)option.cast((Object)this.readTimeout);
        }
        if (option == Options.WRITE_TIMEOUT) {
            return (T)option.cast((Object)this.writeTimeout);
        }
        return null;
    }

    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    private C typed() {
        return (C)this;
    }

    protected void invokeCloseHandler() {
        ChannelListeners.invokeChannelListener(this.typed(), (ChannelListener)this.closeSetter.get());
    }

    protected void cancelWriteKey() {
        if (this.writeHandle != null) {
            this.writeHandle.cancelKey();
        }
    }

    protected void cancelReadKey() {
        if (this.readHandle != null) {
            this.readHandle.cancelKey();
        }
    }

    NioHandle<C> getReadHandle() {
        return this.readHandle;
    }

    NioHandle<C> getWriteHandle() {
        return this.writeHandle;
    }
}

