/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import org.jboss.logging.Logger;
import org.xnio.AbstractChannelThread;
import org.xnio.ChannelThread;
import org.xnio.IoUtils;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioSetter;
import org.xnio.nio.SelectorTask;
import org.xnio.nio.SynchronousHolder;

abstract class AbstractNioChannelThread
extends AbstractChannelThread {
    private static final Logger log = Logger.getLogger((String)"org.xnio.nio.channel-thread");
    private static final long LONGEST_DELAY = 9223372036853L;
    private volatile int keyLoad;
    private volatile boolean shutdown;
    private final Selector selector;
    private final Object workLock = new Object();
    private final Queue<SelectorTask> selectorWorkQueue = new ArrayDeque<SelectorTask>();
    private final Set<TimeKey> delayWorkQueue = new TreeSet<TimeKey>();
    private final Thread thread;
    private final Runnable task = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            selector = AbstractNioChannelThread.access$000(AbstractNioChannelThread.this);
            lock = AbstractNioChannelThread.access$100(AbstractNioChannelThread.this);
            workQueue = AbstractNioChannelThread.access$200(AbstractNioChannelThread.this);
            delayQueue = AbstractNioChannelThread.access$300(AbstractNioChannelThread.this);
            AbstractNioChannelThread.access$400().debugf("Started channel thread '%s', selector %s", (Object)Thread.currentThread().getName(), (Object)selector);
            runQueue = new ArrayDeque<Runnable>();
            try {
                while (true) {
                    block23: {
                        var13_12 = lock;
                        synchronized (var13_12) {
                            task = (SelectorTask)workQueue.poll();
                            if (task == null) {
                                iterator = delayQueue.iterator();
                                delayTime = 0x7FFFFFFFFFFFFFFFL;
                                if (iterator.hasNext()) {
                                    now = System.nanoTime();
                                    do {
                                        if (TimeKey.access$500(key = (TimeKey)iterator.next()) > now) {
                                            delayTime = TimeKey.access$500(key) - now;
                                            break;
                                        }
                                        runQueue.add(TimeKey.access$600(key));
                                        iterator.remove();
                                    } while (iterator.hasNext());
                                }
                                break block23;
                            }
                        }
                        AbstractNioChannelThread.access$700(selector, task);
                        continue;
                    }
                    while ((command = (Runnable)runQueue.poll()) != null) {
                        AbstractNioChannelThread.access$800(command);
                    }
                    if (AbstractNioChannelThread.access$900(AbstractNioChannelThread.this)) {
                        var13_12 = lock;
                        synchronized (var13_12) {
                            block24: {
                                if (AbstractNioChannelThread.access$1002(AbstractNioChannelThread.this, selector.keys().size()) != 0 || !workQueue.isEmpty() || !delayQueue.isEmpty()) break block24;
                                return;
                            }
                            ** try [egrp 4[TRYBLOCK] [4 : 301->307)] { 
                            {
                            }
                        }
                    }
lbl47:
                    // 3 sources

                    try {
                        if (delayTime == 0x7FFFFFFFFFFFFFFFL) {
                            selector.select();
                        } else {
                            millis = 1L + delayTime / 1000000L;
                            selector.select(millis);
                        }
                    }
                    catch (IOException e) {
                        AbstractNioChannelThread.access$400().warnf("Received an I/O error on selection: %s", (Object)e);
                    }
                    selectedKeys = selector.selectedKeys();
                    keyIterator = selectedKeys.iterator();
                    while (true) {
                        if (!keyIterator.hasNext()) ** break;
                        ((NioHandle)keyIterator.next().attachment()).invoke();
                        keyIterator.remove();
                    }
                    break;
                }
            }
            finally {
                IoUtils.safeClose((Selector)selector);
                AbstractNioChannelThread.this.done();
            }
        }
    };

    private static void safeRun(Selector selector, SelectorTask task) {
        try {
            task.run(selector);
        }
        catch (Throwable t) {
            log.error((Object)"Task failed on channel thread", t);
        }
    }

    private static void safeRun(Runnable command) {
        try {
            command.run();
        }
        catch (Throwable t) {
            log.error((Object)"Task failed on channel thread", t);
        }
    }

    protected AbstractNioChannelThread(ThreadFactory threadFactory) throws IOException {
        this.thread = threadFactory.newThread(this.task);
        if (this.thread == null) {
            throw new IllegalArgumentException("Thread factory did not yield a thread");
        }
        this.selector = Selector.open();
    }

    protected void start() {
        this.thread.start();
    }

    protected void startShutdown() {
        this.shutdown = true;
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final Runnable command) {
        Object object = this.workLock;
        synchronized (object) {
            this.selectorWorkQueue.add(new SelectorTask(){

                @Override
                public void run(Selector selector) {
                    AbstractNioChannelThread.safeRun(command);
                }
            });
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelThread.Key executeAfter(Runnable command, long time) {
        if (this.shutdown) {
            throw new RejectedExecutionException("Thread is terminating");
        }
        if (time <= 0L) {
            this.execute(command);
            return ChannelThread.Key.IMMEDIATE;
        }
        Object object = this.workLock;
        synchronized (object) {
            long deadline = time > 9223372036853L ? System.nanoTime() + 9223372036853L : System.nanoTime() + time * 1000000L;
            TimeKey key = new TimeKey(deadline, command);
            this.delayWorkQueue.add(key);
            if (this.delayWorkQueue.iterator().next() == key) {
                this.selector.wakeup();
            }
            return key;
        }
    }

    void done() {
        this.shutdownFinished();
    }

    public int getLoad() {
        return this.keyLoad;
    }

    <C extends Channel> NioHandle<C> addChannel(final AbstractSelectableChannel channel, final C xnioChannel, final int ops, final NioSetter<C> setter) throws ClosedChannelException {
        log.tracef("Adding channel %s to %s for XNIO channel %s", (Object)channel, (Object)this, xnioChannel);
        if (this.thread == Thread.currentThread()) {
            if (this.shutdown) {
                throw new IllegalStateException(String.format("Cannot add channel %s to %s (stopping)", new Object[]{xnioChannel, this}));
            }
            SelectionKey key = channel.register(this.selector, ops);
            NioHandle<C> handle = new NioHandle<C>(key, this, setter, xnioChannel);
            key.attach(handle);
            key.interestOps(ops);
            return handle;
        }
        final SynchronousHolder holder = new SynchronousHolder(ClosedChannelException.class);
        this.queueTask(new SelectorTask(){

            @Override
            public void run(Selector selector) {
                try {
                    if (AbstractNioChannelThread.this.shutdown) {
                        holder.setProblem(new IllegalStateException(String.format("Cannot add channel %s to %s (stopping)", xnioChannel, this)));
                        return;
                    }
                    SelectionKey key = channel.register(selector, ops);
                    NioHandle<Channel> handle = new NioHandle<Channel>(key, AbstractNioChannelThread.this, setter, xnioChannel);
                    key.attach(handle);
                    key.interestOps(ops);
                    holder.set(handle);
                }
                catch (ClosedChannelException e) {
                    holder.setProblem(e);
                }
            }
        });
        this.selector.wakeup();
        return (NioHandle)holder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueTask(SelectorTask task) {
        Object object = this.workLock;
        synchronized (object) {
            this.selectorWorkQueue.add(task);
        }
    }

    void cancelKey(final SelectionKey key) {
        if (this.thread == Thread.currentThread()) {
            key.cancel();
        } else {
            final SynchronousHolder holder = new SynchronousHolder(RuntimeException.class);
            this.queueTask(new SelectorTask(){

                @Override
                public void run(Selector selector) {
                    key.cancel();
                    holder.set(null);
                    try {
                        selector.selectNow();
                    }
                    catch (IOException e) {
                        log.warnf("Received an I/O error on selection: %s", (Object)e);
                    }
                }
            });
            this.selector.wakeup();
            holder.get();
        }
    }

    void setOps(final SelectionKey key, final int ops) {
        if (this.thread == Thread.currentThread()) {
            key.interestOps(ops);
        } else {
            final SynchronousHolder holder = new SynchronousHolder(CancelledKeyException.class);
            this.queueTask(new SelectorTask(){

                @Override
                public void run(Selector selector) {
                    try {
                        key.interestOps(ops);
                        holder.set(null);
                    }
                    catch (RuntimeException e) {
                        holder.setProblem(e);
                    }
                }
            });
            this.selector.wakeup();
            holder.get();
        }
    }

    static /* synthetic */ Selector access$000(AbstractNioChannelThread x0) {
        return x0.selector;
    }

    static /* synthetic */ Queue access$200(AbstractNioChannelThread x0) {
        return x0.selectorWorkQueue;
    }

    static /* synthetic */ void access$700(Selector x0, SelectorTask x1) {
        AbstractNioChannelThread.safeRun(x0, x1);
    }

    static /* synthetic */ int access$1002(AbstractNioChannelThread x0, int x1) {
        x0.keyLoad = x1;
        return x0.keyLoad;
    }

    final class TimeKey
    implements ChannelThread.Key {
        private final long deadline;
        private final Runnable command;

        TimeKey(long deadline, Runnable command) {
            this.deadline = deadline;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove() {
            Object object = AbstractNioChannelThread.this.workLock;
            synchronized (object) {
                return AbstractNioChannelThread.this.delayWorkQueue.remove(this);
            }
        }

        static /* synthetic */ long access$500(TimeKey x0) {
            return x0.deadline;
        }

        static /* synthetic */ Runnable access$600(TimeKey x0) {
            return x0.command;
        }
    }
}

