/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.Options;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.management.TcpConnectionMBean;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioXnio;
import org.jboss.xnio.nio.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NioTcpChannel
implements TcpChannel,
Closeable {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.tcp.channel");
    private final SocketChannel socketChannel;
    private final Socket socket;
    private volatile ChannelListener<? super TcpChannel> readListener = null;
    private volatile ChannelListener<? super TcpChannel> writeListener = null;
    private volatile ChannelListener<? super TcpChannel> closeListener = null;
    private static final AtomicReferenceFieldUpdater<NioTcpChannel, ChannelListener> readListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioTcpChannel.class, ChannelListener.class, "readListener");
    private static final AtomicReferenceFieldUpdater<NioTcpChannel, ChannelListener> writeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioTcpChannel.class, ChannelListener.class, "writeListener");
    private static final AtomicReferenceFieldUpdater<NioTcpChannel, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioTcpChannel.class, ChannelListener.class, "closeListener");
    private final ChannelListener.Setter<TcpChannel> readSetter = IoUtils.getSetter((Object)this, readListenerUpdater);
    private final ChannelListener.Setter<TcpChannel> writeSetter = IoUtils.getSetter((Object)this, writeListenerUpdater);
    private final ChannelListener.Setter<TcpChannel> closeSetter = IoUtils.getSetter((Object)this, closeListenerUpdater);
    private final NioHandle readHandle;
    private final NioHandle writeHandle;
    private final NioXnio nioXnio;
    private volatile int closeCalled = 0;
    private volatile long bytesRead = 0L;
    private volatile long bytesWritten = 0L;
    private volatile long msgsRead = 0L;
    private volatile long msgsWritten = 0L;
    private static final AtomicIntegerFieldUpdater<NioTcpChannel> closeCalledUpdater = AtomicIntegerFieldUpdater.newUpdater(NioTcpChannel.class, "closeCalled");
    private static final AtomicLongFieldUpdater<NioTcpChannel> bytesReadUpdater = AtomicLongFieldUpdater.newUpdater(NioTcpChannel.class, "bytesRead");
    private static final AtomicLongFieldUpdater<NioTcpChannel> bytesWrittenUpdater = AtomicLongFieldUpdater.newUpdater(NioTcpChannel.class, "bytesWritten");
    private static final AtomicLongFieldUpdater<NioTcpChannel> msgsReadUpdater = AtomicLongFieldUpdater.newUpdater(NioTcpChannel.class, "msgsRead");
    private static final AtomicLongFieldUpdater<NioTcpChannel> msgsWrittenUpdater = AtomicLongFieldUpdater.newUpdater(NioTcpChannel.class, "msgsWritten");
    private final Closeable mbeanHandle;
    private static final Set<Option<?>> OPTIONS = Collections.singleton(Options.CLOSE_ABORT);

    public NioTcpChannel(NioXnio nioXnio, SocketChannel socketChannel, Executor executor, boolean manage, InetSocketAddress bindAddress, InetSocketAddress peerAddress) throws IOException {
        this.socketChannel = socketChannel;
        this.nioXnio = nioXnio;
        this.socket = socketChannel.socket();
        if (executor != null) {
            this.readHandle = nioXnio.addReadHandler(socketChannel, new ReadHandler(), executor);
            this.writeHandle = nioXnio.addWriteHandler(socketChannel, new WriteHandler(), executor);
        } else {
            this.readHandle = nioXnio.addReadHandler(socketChannel, new ReadHandler());
            this.writeHandle = nioXnio.addWriteHandler(socketChannel, new WriteHandler());
        }
        try {
            this.mbeanHandle = manage ? nioXnio.registerMBean(new MBean(bindAddress, peerAddress)) : IoUtils.nullCloseable();
        }
        catch (NotCompliantMBeanException e) {
            throw new IOException("Failed to register channel mbean: " + e);
        }
    }

    BoundChannel<InetSocketAddress> getBoundChannel() {
        return new BoundChannel<InetSocketAddress>(){

            public InetSocketAddress getLocalAddress() {
                return NioTcpChannel.this.getLocalAddress();
            }

            public ChannelListener.Setter<? extends BoundChannel<InetSocketAddress>> getCloseSetter() {
                return NioTcpChannel.this.getCloseSetter();
            }

            public boolean isOpen() {
                return NioTcpChannel.this.isOpen();
            }

            public void close() throws IOException {
                NioTcpChannel.this.close();
            }

            public boolean supportsOption(Option<?> option) {
                return NioTcpChannel.this.supportsOption(option);
            }

            public <T> T getOption(Option<T> option) throws IOException {
                return NioTcpChannel.this.getOption(option);
            }

            public <T> Configurable setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                NioTcpChannel.this.setOption(option, value);
                return this;
            }
        };
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(this.socketChannel, position, count);
    }

    public ChannelListener.Setter<TcpChannel> getReadSetter() {
        return this.readSetter;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this.socketChannel);
    }

    public ChannelListener.Setter<TcpChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<TcpChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public boolean flush() throws IOException {
        return true;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long written = this.socketChannel.write(srcs, offset, length);
        if (written > 0L) {
            bytesWrittenUpdater.addAndGet(this, written);
            msgsWrittenUpdater.incrementAndGet(this);
        }
        return written;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        long written = this.socketChannel.write(srcs);
        if (written > 0L) {
            bytesWrittenUpdater.addAndGet(this, written);
            msgsWrittenUpdater.incrementAndGet(this);
        }
        return written;
    }

    public int write(ByteBuffer src) throws IOException {
        int written = this.socketChannel.write(src);
        if (written > 0) {
            bytesWrittenUpdater.addAndGet(this, written);
            msgsWrittenUpdater.incrementAndGet(this);
        }
        return written;
    }

    public boolean isOpen() {
        return this.closeCalled == 0 && this.socketChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (closeCalledUpdater.compareAndSet(this, 0, 1)) {
            log.trace("Closing %s", (Object)this);
            IoUtils.invokeChannelListener((Channel)((Object)this), this.closeListener);
            this.nioXnio.removeManaged(this);
            IoUtils.safeClose((Closeable)this.mbeanHandle);
            this.socketChannel.close();
        }
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long read = this.socketChannel.read(dsts, offset, length);
        if (read > 0L) {
            bytesReadUpdater.addAndGet(this, read);
            msgsReadUpdater.incrementAndGet(this);
        }
        return read;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        long read = this.socketChannel.read(dsts);
        if (read > 0L) {
            bytesReadUpdater.addAndGet(this, read);
            msgsReadUpdater.incrementAndGet(this);
        }
        return read;
    }

    public int read(ByteBuffer dst) throws IOException {
        int read = this.socketChannel.read(dst);
        if (read > 0) {
            bytesReadUpdater.addAndGet(this, read);
            msgsReadUpdater.incrementAndGet(this);
        }
        return read;
    }

    public void suspendReads() {
        try {
            this.readHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void suspendWrites() {
        try {
            this.writeHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeReads() {
        try {
            this.readHandle.resume(1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeWrites() {
        try {
            this.writeHandle.resume(4);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void shutdownReads() throws IOException {
        this.socket.shutdownInput();
    }

    public boolean shutdownWrites() throws IOException {
        if (this.flush()) {
            this.socket.shutdownOutput();
            return true;
        }
        return false;
    }

    public void awaitReadable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.socketChannel, 1);
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.socketChannel, 1, time, timeUnit);
    }

    public void awaitWritable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.socketChannel, 4);
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.socketChannel, 4, time, timeUnit);
    }

    public InetSocketAddress getPeerAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        if (Options.CLOSE_ABORT.equals(option)) {
            return (T)Boolean.valueOf(this.socket.getSoLinger() != -1);
        }
        return null;
    }

    public <T> NioTcpChannel setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (Options.CLOSE_ABORT.equals(option)) {
            if (value == null) {
                throw new NullPointerException("value is null");
            }
            this.socket.setSoLinger((Boolean)value, 0);
        }
        return this;
    }

    public String toString() {
        return String.format("TCP socket channel (NIO) <%s> (local: %s, remote: %s)", Integer.toString(this.hashCode(), 16), this.getLocalAddress(), this.getPeerAddress());
    }

    public final class MBean
    extends StandardMBean
    implements TcpConnectionMBean {
        private final InetSocketAddress bindAddress;
        private final InetSocketAddress peerAddress;

        public MBean(InetSocketAddress bindAddress, InetSocketAddress peerAddress) throws NotCompliantMBeanException {
            super(TcpConnectionMBean.class);
            this.bindAddress = bindAddress;
            this.peerAddress = peerAddress;
        }

        public long getBytesRead() {
            return NioTcpChannel.this.bytesRead;
        }

        public long getBytesWritten() {
            return NioTcpChannel.this.bytesWritten;
        }

        public long getMessagesRead() {
            return NioTcpChannel.this.msgsRead;
        }

        public long getMessagesWritten() {
            return NioTcpChannel.this.msgsWritten;
        }

        public String toString() {
            return "ChannelMBean";
        }

        public InetSocketAddress getPeerAddress() {
            return this.peerAddress;
        }

        public InetSocketAddress getBindAddress() {
            return this.bindAddress;
        }

        public void close() {
            IoUtils.safeClose((Closeable)NioTcpChannel.this);
        }
    }

    private final class WriteHandler
    implements Runnable {
        private WriteHandler() {
        }

        public void run() {
            IoUtils.invokeChannelListener((Channel)((Object)NioTcpChannel.this), (ChannelListener)NioTcpChannel.this.writeListener);
        }
    }

    private final class ReadHandler
    implements Runnable {
        private ReadHandler() {
        }

        public void run() {
            IoUtils.invokeChannelListener((Channel)((Object)NioTcpChannel.this), (ChannelListener)NioTcpChannel.this.readListener);
        }
    }
}

