/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.SelectorTask;

final class NioSelectorRunnable
implements Runnable {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.selector");
    private final Selector selector;
    private final Queue<SelectorTask> selectorWorkQueue = new ConcurrentLinkedQueue<SelectorTask>();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicBoolean selecting = new AtomicBoolean(true);
    private volatile int keyLoad;
    private volatile Thread thread;

    protected NioSelectorRunnable() throws IOException {
        this.selector = Selector.open();
    }

    public void runTask(SelectorTask task) {
        if (Thread.currentThread() == this.thread) {
            task.run(this.selector);
        } else {
            this.selectorWorkQueue.add(task);
            if (this.selecting.getAndSet(false)) {
                this.selector.wakeup();
            }
        }
    }

    public void wakeup() {
        if (this.selecting.getAndSet(false) && Thread.currentThread() != this.thread) {
            this.selector.wakeup();
        }
    }

    public int getKeyLoad() {
        return this.keyLoad;
    }

    public void shutdown() {
        if (!this.shutdown.getAndSet(true)) {
            try {
                this.selector.close();
            }
            catch (Throwable t) {
                log.trace(t, "Failed to close selector", new Object[0]);
            }
            Thread thread = this.thread;
            if (thread != null && thread != Thread.currentThread()) {
                try {
                    thread.interrupt();
                }
                catch (Throwable t) {
                    log.trace(t, "Failed to interrupt selector thread", new Object[0]);
                }
            }
        }
    }

    public void run() {
        this.thread = Thread.currentThread();
        Selector selector = this.selector;
        Queue<SelectorTask> queue = this.selectorWorkQueue;
        while (true) {
            try {
                if (this.shutdown.get()) {
                    return;
                }
                this.keyLoad = selector.keys().size();
                selector.select();
                this.selecting.set(true);
                SelectorTask task = queue.poll();
                while (task != null) {
                    try {
                        task.run(selector);
                    }
                    catch (Throwable t) {
                        log.trace(t, "NIO selector task failed", new Object[0]);
                    }
                    task = queue.poll();
                }
                Set<SelectionKey> selectedKeys = selector.selectedKeys();
                Iterator<SelectionKey> iterator = selectedKeys.iterator();
                while (iterator.hasNext()) {
                    SelectionKey key = iterator.next();
                    iterator.remove();
                    try {
                        NioHandle handle = (NioHandle)key.attachment();
                        if (handle.isOneshot()) {
                            key.interestOps(0);
                        }
                        handle.getHandlerExecutor().execute(handle.getHandler());
                    }
                    catch (CancelledKeyException e) {
                        log.trace("Key %s cancelled", (Object)key);
                    }
                    catch (Throwable t) {
                        log.trace(t, "Failed to execute handler", new Object[0]);
                    }
                }
            }
            catch (ClosedSelectorException e) {
                log.trace("Selector %s closed", (Object)selector);
                return;
            }
            catch (IOException e) {
                log.trace((Throwable)e, "I/O error in selector loop", new Object[0]);
            }
            if (!Thread.interrupted()) continue;
            log.trace("Selector thread interrupted");
        }
    }
}

