/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import org.jboss.xnio.AbstractFutureConnection;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.FailedFutureConnection;
import org.jboss.xnio.FinishedFutureConnection;
import org.jboss.xnio.FutureConnection;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.TcpChannelSource;
import org.jboss.xnio.TcpConnector;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioTcpChannel;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NioTcpConnector
implements TcpConnector {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.tcp.connector");
    private final NioXnio nioXnio;
    private final Executor executor;
    private final Boolean keepAlive;
    private final Boolean oobInline;
    private final Integer receiveBufferSize;
    private final Boolean reuseAddress;
    private final Integer sendBufferSize;
    private final Boolean tcpNoDelay;
    private final boolean manageConnections;

    private NioTcpConnector(NioXnio nioXnio, Executor executor, OptionMap optionMap) {
        if (nioXnio == null) {
            throw new NullPointerException("nioXnio is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        this.nioXnio = nioXnio;
        this.executor = executor;
        this.reuseAddress = (Boolean)optionMap.get(Options.REUSE_ADDRESSES);
        this.receiveBufferSize = (Integer)optionMap.get(Options.RECEIVE_BUFFER);
        this.sendBufferSize = (Integer)optionMap.get(Options.SEND_BUFFER);
        this.keepAlive = (Boolean)optionMap.get(Options.KEEP_ALIVE);
        this.oobInline = (Boolean)optionMap.get(Options.TCP_OOB_INLINE);
        this.tcpNoDelay = (Boolean)optionMap.get(Options.TCP_NODELAY);
        this.manageConnections = !optionMap.contains(Options.MANAGE_CONNECTIONS) || (Boolean)optionMap.get(Options.MANAGE_CONNECTIONS) != false;
    }

    private void configureStream(Socket socket) throws SocketException {
        if (this.keepAlive != null) {
            socket.setKeepAlive(this.keepAlive);
        }
        if (this.oobInline != null) {
            socket.setOOBInline(this.oobInline);
        }
        if (this.receiveBufferSize != null) {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.reuseAddress != null) {
            socket.setReuseAddress(this.reuseAddress);
        }
        if (this.sendBufferSize != null) {
            socket.setSendBufferSize(this.sendBufferSize);
        }
        if (this.tcpNoDelay != null) {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
    }

    public FutureConnection<InetSocketAddress, TcpChannel> connectTo(InetSocketAddress dest, ChannelListener<? super TcpChannel> handler) {
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        return this.doConnectTo(null, dest, handler);
    }

    public FutureConnection<InetSocketAddress, TcpChannel> connectTo(InetSocketAddress src, InetSocketAddress dest, ChannelListener<? super TcpChannel> handler) {
        if (src == null) {
            throw new NullPointerException("src is null");
        }
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        return this.doConnectTo(src, dest, handler);
    }

    public TcpChannelSource createChannelSource(final InetSocketAddress dest) {
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        return new TcpChannelSource(){

            public FutureConnection<InetSocketAddress, TcpChannel> open(ChannelListener<? super TcpChannel> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is null");
                }
                return NioTcpConnector.this.doConnectTo(null, dest, (ChannelListener<? super TcpChannel>)handler);
            }
        };
    }

    public TcpChannelSource createChannelSource(final InetSocketAddress src, final InetSocketAddress dest) {
        if (src == null) {
            throw new NullPointerException("src is null");
        }
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        return new TcpChannelSource(){

            public FutureConnection<InetSocketAddress, TcpChannel> open(ChannelListener<? super TcpChannel> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is null");
                }
                return NioTcpConnector.this.doConnectTo(src, dest, (ChannelListener<? super TcpChannel>)handler);
            }
        };
    }

    private FutureConnection<InetSocketAddress, TcpChannel> doConnectTo(final InetSocketAddress src, final InetSocketAddress dest, final ChannelListener<? super TcpChannel> handler) {
        try {
            log.trace("Connecting from %s to %s", src == null ? "-any-" : src, (Object)dest);
            final SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            Socket socket = socketChannel.socket();
            if (src != null) {
                socket.bind(src);
            }
            this.configureStream(socket);
            if (socketChannel.connect(dest)) {
                final NioTcpChannel channel = new NioTcpChannel(this.nioXnio, socketChannel, this.executor, this.manageConnections);
                this.nioXnio.addManaged(channel);
                this.executor.execute(new Runnable(){

                    public void run() {
                        log.trace("Connection from %s to %s is up (immediate)", src == null ? "-any-" : src, (Object)dest);
                        if (!IoUtils.invokeChannelListener((Channel)((Object)channel), (ChannelListener)handler)) {
                            IoUtils.safeClose((Closeable)socketChannel);
                            NioTcpConnector.this.nioXnio.removeManaged(channel);
                        }
                    }
                });
                return new FinishedFutureConnection((BoundChannel)channel);
            }
            ConnectionHandler connectionHandler = new ConnectionHandler(this.executor, socketChannel, this.nioXnio, handler);
            connectionHandler.handle.resume(8);
            return connectionHandler.future;
        }
        catch (IOException e) {
            return new FailedFutureConnection(e, (Object)src);
        }
    }

    public String toString() {
        return String.format("TCP connector (NIO) <%s>", Integer.toHexString(this.hashCode()));
    }

    static TcpConnector create(NioXnio nioXnio, Executor executor, OptionMap optionMap) {
        return new NioTcpConnector(nioXnio, executor, optionMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConnectionHandler
    implements Runnable {
        private final FutureImpl future;
        private final SocketChannel socketChannel;
        private final NioHandle handle;
        private final ChannelListener<? super TcpChannel> handler;

        public ConnectionHandler(Executor executor, SocketChannel socketChannel, NioXnio nioXnio, ChannelListener<? super TcpChannel> handler) throws IOException {
            this.socketChannel = socketChannel;
            this.handler = handler;
            this.handle = nioXnio.addConnectHandler(socketChannel, this, true);
            this.future = new FutureImpl(executor, (InetSocketAddress)socketChannel.socket().getLocalSocketAddress());
        }

        @Override
        public void run() {
            try {
                if (this.socketChannel.finishConnect()) {
                    log.trace("Connection is up (deferred)");
                    NioTcpChannel channel = new NioTcpChannel(NioTcpConnector.this.nioXnio, this.socketChannel, NioTcpConnector.this.executor, NioTcpConnector.this.manageConnections);
                    this.future.setResult(channel);
                    if (!IoUtils.invokeChannelListener((Channel)((Object)channel), this.handler)) {
                        IoUtils.safeClose((Closeable)this.socketChannel);
                        NioTcpConnector.this.nioXnio.removeManaged(channel);
                    }
                } else {
                    log.trace("Connection is not yet up (deferred)");
                    this.handle.resume(8);
                    return;
                }
                this.handle.cancelKey();
            }
            catch (IOException e) {
                this.future.setException(e);
                this.handle.cancelKey();
            }
            catch (Exception e) {
                String message = e.getMessage();
                IOException ioexception = new IOException("Connection failed unexpectedly: " + message);
                ioexception.setStackTrace(e.getStackTrace());
                this.future.setException(ioexception);
                this.handle.cancelKey();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class FutureImpl
        extends AbstractFutureConnection<InetSocketAddress, TcpChannel> {
            private final Executor executor;
            private final InetSocketAddress localAddress;

            public FutureImpl(Executor executor, InetSocketAddress address) {
                this.executor = executor;
                this.localAddress = address;
            }

            protected boolean setException(IOException exception) {
                return super.setException(exception);
            }

            protected boolean setResult(TcpChannel result) {
                return super.setResult((Object)result);
            }

            protected boolean finishCancel() {
                return super.finishCancel();
            }

            protected Executor getNotifierExecutor() {
                return this.executor;
            }

            public InetSocketAddress getLocalAddress() {
                return this.localAddress;
            }

            public FutureConnection<InetSocketAddress, TcpChannel> cancel() {
                if (this.finishCancel()) {
                    IoUtils.safeClose((Closeable)ConnectionHandler.this.socketChannel);
                }
                return this;
            }
        }
    }
}

