/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.FailedIoFuture;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.UdpServer;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.management.UdpServerMBean;
import org.jboss.xnio.nio.BioMulticastUdpChannel;
import org.jboss.xnio.nio.FutureUdpChannel;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BioUdpServer
implements UdpServer {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.udp.bio-server");
    private volatile ChannelListener<? super UdpChannel> bindListener = null;
    private volatile ChannelListener<? super UdpServer> closeListener = null;
    private static final AtomicReferenceFieldUpdater<BioUdpServer, ChannelListener> bindListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(BioUdpServer.class, ChannelListener.class, "bindListener");
    private static final AtomicReferenceFieldUpdater<BioUdpServer, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(BioUdpServer.class, ChannelListener.class, "closeListener");
    private final ChannelListener.Setter<UdpChannel> bindSetter = IoUtils.getSetter((Object)this, bindListenerUpdater);
    private final ChannelListener.Setter<UdpServer> closeSetter = IoUtils.getSetter((Object)this, closeListenerUpdater);
    private final Executor executor;
    private final Object lock = new Object();
    private final Set<BioMulticastUdpChannel> boundChannels = new LinkedHashSet<BioMulticastUdpChannel>();
    private boolean closed;
    private Boolean reuseAddress;
    private Integer receiveBufferSize;
    private Integer sendBufferSize;
    private Integer trafficClass;
    private Boolean broadcast;
    private final Closeable mbeanHandle;
    private final AtomicLong globalBytesRead = new AtomicLong();
    private final AtomicLong globalBytesWritten = new AtomicLong();
    private final AtomicLong globalMessagesRead = new AtomicLong();
    private final AtomicLong globalMessagesWritten = new AtomicLong();
    protected static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.RECEIVE_BUFFER).add(Options.REUSE_ADDRESSES).add(Options.SEND_BUFFER).add(Options.IP_TRAFFIC_CLASS).add(Options.BROADCAST).create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BioUdpServer(NioXnio nioXnio, Executor executor, ChannelListener<? super UdpChannel> bindListener, OptionMap config) {
        Object object = this.lock;
        synchronized (object) {
            this.bindListener = bindListener;
            this.executor = executor;
            this.reuseAddress = (Boolean)config.get(Options.REUSE_ADDRESSES);
            this.receiveBufferSize = (Integer)config.get(Options.RECEIVE_BUFFER);
            this.sendBufferSize = (Integer)config.get(Options.SEND_BUFFER);
            this.trafficClass = (Integer)config.get(Options.IP_TRAFFIC_CLASS);
            this.broadcast = (Boolean)config.get(Options.BROADCAST);
            Closeable closeable = IoUtils.nullCloseable();
            try {
                closeable = nioXnio.registerMBean(new MBean());
            }
            catch (NotCompliantMBeanException e) {
                log.trace((Throwable)e, "Failed to register MBean", new Object[0]);
            }
            this.mbeanHandle = closeable;
        }
    }

    public ChannelListener.Setter<UdpChannel> getBindSetter() {
        return this.bindSetter;
    }

    public ChannelListener.Setter<UdpServer> getCloseSetter() {
        return this.closeSetter;
    }

    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        if (Options.RECEIVE_BUFFER.equals(option)) {
            return (T)option.cast((Object)this.receiveBufferSize);
        }
        if (Options.REUSE_ADDRESSES.equals(option)) {
            return (T)option.cast((Object)this.reuseAddress);
        }
        if (Options.SEND_BUFFER.equals(option)) {
            return (T)option.cast((Object)this.sendBufferSize);
        }
        if (Options.IP_TRAFFIC_CLASS.equals(option)) {
            return (T)option.cast((Object)this.trafficClass);
        }
        if (Options.BROADCAST.equals(option)) {
            return (T)option.cast((Object)this.broadcast);
        }
        return null;
    }

    public <T> Configurable setOption(Option<T> option, T value) throws IOException {
        if (Options.RECEIVE_BUFFER.equals(option)) {
            this.receiveBufferSize = (Integer)Options.RECEIVE_BUFFER.cast(value);
        } else if (Options.REUSE_ADDRESSES.equals(option)) {
            this.reuseAddress = (Boolean)Options.REUSE_ADDRESSES.cast(value);
        } else if (Options.SEND_BUFFER.equals(option)) {
            this.sendBufferSize = (Integer)Options.SEND_BUFFER.cast(value);
        } else if (Options.IP_TRAFFIC_CLASS.equals(option)) {
            this.trafficClass = (Integer)Options.IP_TRAFFIC_CLASS.cast(value);
        } else if (Options.BROADCAST.equals(option)) {
            this.broadcast = (Boolean)Options.BROADCAST.cast(value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UdpChannel> getChannels() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<UdpChannel>(this.boundChannels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoFuture<UdpChannel> bind(final InetSocketAddress address) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.closed) {
                    throw new ClosedChannelException();
                }
                final MulticastSocket socket = new MulticastSocket(null);
                if (this.broadcast != null) {
                    socket.setBroadcast(this.broadcast);
                }
                if (this.receiveBufferSize != null) {
                    socket.setReceiveBufferSize(this.receiveBufferSize);
                }
                if (this.sendBufferSize != null) {
                    socket.setSendBufferSize(this.sendBufferSize);
                }
                if (this.reuseAddress != null) {
                    socket.setReuseAddress(this.reuseAddress);
                }
                if (this.trafficClass != null) {
                    socket.setTrafficClass(this.trafficClass);
                }
                socket.bind(address);
                final BioMulticastUdpChannel channel = new BioMulticastUdpChannel(socket.getSendBufferSize(), socket.getReceiveBufferSize(), this.executor, socket, this.globalBytesRead, this.globalBytesWritten, this.globalMessagesRead, this.globalMessagesWritten);
                final FutureUdpChannel futureUdpChannel = new FutureUdpChannel(channel, new Closeable(){

                    public void close() throws IOException {
                        socket.close();
                    }
                });
                this.boundChannels.add(channel);
                this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block6: {
                            try {
                                BioUdpServer.this.bindListener.handleEvent((Channel)((Object)channel));
                                if (!futureUdpChannel.done()) {
                                    IoUtils.safeClose((Closeable)((Object)channel));
                                }
                                channel.open();
                                log.trace("Successfully bound to %s on %s", (Object)address, (Object)BioUdpServer.this);
                            }
                            catch (Throwable t) {
                                IoUtils.safeClose((DatagramSocket)socket);
                                Object object = BioUdpServer.this.lock;
                                synchronized (object) {
                                    BioUdpServer.this.boundChannels.remove(channel);
                                }
                                IOException ioe = new IOException("Failed to open UDP channel: " + t.toString());
                                ioe.initCause(t);
                                if (futureUdpChannel.setException(ioe)) break block6;
                                log.trace((Throwable)ioe, "UDP channel open failed, but the operation was cancelled before the exception could be relayed", new Object[0]);
                            }
                        }
                    }
                });
                return futureUdpChannel;
            }
            catch (IOException e) {
                return new FailedIoFuture(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                log.trace("Closing %s", (Object)this);
                this.closed = true;
                IoUtils.safeClose((Closeable)this.mbeanHandle);
                Iterator<BioMulticastUdpChannel> it = this.boundChannels.iterator();
                while (it.hasNext()) {
                    IoUtils.safeClose((Closeable)((Closeable)((Object)it.next())));
                    it.remove();
                }
                IoUtils.invokeChannelListener((Channel)((Object)this), this.closeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return !this.closed;
        }
    }

    private final class MBean
    extends StandardMBean
    implements UdpServerMBean {
        private MBean() throws NotCompliantMBeanException {
            super(UdpServerMBean.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UdpServerMBean.Channel[] getBoundChannels() {
            Object object = BioUdpServer.this.lock;
            synchronized (object) {
                UdpServerMBean.Channel[] channels = new UdpServerMBean.Channel[BioUdpServer.this.boundChannels.size()];
                int i = 0;
                for (final BioMulticastUdpChannel channel : BioUdpServer.this.boundChannels) {
                    channels[i++] = new UdpServerMBean.Channel(){

                        public long getBytesRead() {
                            return channel.bytesRead.get();
                        }

                        public long getBytesWritten() {
                            return channel.bytesWritten.get();
                        }

                        public long getMessagesRead() {
                            return channel.messagesRead.get();
                        }

                        public long getMessagesWritten() {
                            return channel.messagesWritten.get();
                        }

                        public InetSocketAddress getBindAddress() {
                            return channel.getLocalAddress();
                        }

                        public void close() {
                            IoUtils.safeClose((Closeable)((Object)channel));
                        }
                    };
                }
                return channels;
            }
        }

        public long getBytesRead() {
            return BioUdpServer.this.globalBytesRead.get();
        }

        public long getBytesWritten() {
            return BioUdpServer.this.globalBytesWritten.get();
        }

        public long getMessagesRead() {
            return BioUdpServer.this.globalMessagesRead.get();
        }

        public long getMessagesWritten() {
            return BioUdpServer.this.globalMessagesWritten.get();
        }

        public void close() {
            IoUtils.safeClose((Closeable)((Object)BioUdpServer.this));
        }
    }
}

