/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.Options;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.MultipointReadResult;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BioDatagramUdpChannel
implements UdpChannel {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.udp.bio-server.channel");
    private final DatagramSocket datagramSocket;
    private final DatagramPacket receivePacket;
    private final ByteBuffer receiveBuffer;
    private final DatagramPacket sendPacket;
    private final ByteBuffer sendBuffer;
    private final Executor handlerExecutor;
    private final Runnable readHandlerTask = new ReadHandlerTask();
    private final Runnable writeHandlerTask = new WriteHandlerTask();
    private final ReaderTask readerTask = new ReaderTask();
    private final WriterTask writerTask = new WriterTask();
    private volatile ChannelListener<? super UdpChannel> readListener = null;
    private volatile ChannelListener<? super UdpChannel> writeListener = null;
    private volatile ChannelListener<? super UdpChannel> closeListener = null;
    private static final AtomicReferenceFieldUpdater<BioDatagramUdpChannel, ChannelListener> readListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(BioDatagramUdpChannel.class, ChannelListener.class, "readListener");
    private static final AtomicReferenceFieldUpdater<BioDatagramUdpChannel, ChannelListener> writeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(BioDatagramUdpChannel.class, ChannelListener.class, "writeListener");
    private static final AtomicReferenceFieldUpdater<BioDatagramUdpChannel, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(BioDatagramUdpChannel.class, ChannelListener.class, "closeListener");
    private final ChannelListener.Setter<UdpChannel> readSetter = IoUtils.getSetter((Object)this, readListenerUpdater);
    private final ChannelListener.Setter<UdpChannel> writeSetter = IoUtils.getSetter((Object)this, writeListenerUpdater);
    private final ChannelListener.Setter<UdpChannel> closeSetter = IoUtils.getSetter((Object)this, closeListenerUpdater);
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private boolean enableRead;
    private boolean enableWrite;
    private boolean readable;
    private boolean writable;
    private IOException readException;
    private final AtomicBoolean closeCalled = new AtomicBoolean(false);
    private final AtomicLong globalBytesRead;
    private final AtomicLong globalBytesWritten;
    private final AtomicLong globalMessagesRead;
    private final AtomicLong globalMessagesWritten;
    final AtomicLong bytesRead = new AtomicLong();
    final AtomicLong bytesWritten = new AtomicLong();
    final AtomicLong messagesRead = new AtomicLong();
    final AtomicLong messagesWritten = new AtomicLong();
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.BROADCAST).add(Options.IP_TRAFFIC_CLASS).create();

    BioDatagramUdpChannel(int sendBufSize, int recvBufSize, Executor handlerExecutor, DatagramSocket datagramSocket, AtomicLong globalBytesRead, AtomicLong globalBytesWritten, AtomicLong globalMessagesRead, AtomicLong globalMessagesWritten) {
        this.datagramSocket = datagramSocket;
        this.handlerExecutor = handlerExecutor;
        this.globalBytesRead = globalBytesRead;
        this.globalBytesWritten = globalBytesWritten;
        this.globalMessagesRead = globalMessagesRead;
        this.globalMessagesWritten = globalMessagesWritten;
        if (sendBufSize == -1) {
            sendBufSize = 4096;
        } else if (sendBufSize < 0) {
            throw new IllegalArgumentException("sendBufSize is less than 0");
        }
        if (recvBufSize == -1) {
            recvBufSize = 4096;
        } else if (recvBufSize < 0) {
            throw new IllegalArgumentException("recvBufSize is less than 0");
        }
        byte[] sendBufferBytes = new byte[sendBufSize];
        this.sendBuffer = ByteBuffer.wrap(sendBufferBytes);
        byte[] recvBufferBytes = new byte[recvBufSize];
        this.receiveBuffer = ByteBuffer.wrap(recvBufferBytes);
        this.sendPacket = new DatagramPacket(sendBufferBytes, sendBufSize);
        this.receivePacket = new DatagramPacket(recvBufferBytes, recvBufSize);
        log.trace("Constructed a new channel (%s); send buffer size %d, receive buffer size %d", (Object)this, (Object)sendBufSize, (Object)recvBufSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() {
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        Thread readThread = threadFactory.newThread(this.readerTask);
        boolean ok = false;
        try {
            Thread writeThread = threadFactory.newThread(this.writerTask);
            try {
                readThread.start();
                writeThread.start();
                ok = true;
            }
            finally {
                if (!ok) {
                    this.writerTask.cancel();
                }
            }
        }
        finally {
            if (!ok) {
                this.readerTask.cancel();
            }
        }
        log.trace("Channel %s opened", (Object)this);
    }

    public ChannelListener.Setter<UdpChannel> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<UdpChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<UdpChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public boolean flush() throws IOException {
        return true;
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.datagramSocket.getLocalSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultipointReadResult<InetSocketAddress> receive(ByteBuffer buffer) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (!this.readable) {
                return null;
            }
            this.readable = false;
            if (this.readException != null) {
                try {
                    this.readException.setStackTrace(new Throwable().getStackTrace());
                    throw this.readException;
                }
                catch (Throwable throwable) {
                    this.readException = null;
                    throw throwable;
                }
            }
            int size = Math.min(buffer.remaining(), this.receiveBuffer.remaining());
            this.receiveBuffer.limit(size);
            buffer.put(this.receiveBuffer);
            this.readLock.notify();
            final InetSocketAddress socketAddress = (InetSocketAddress)this.receivePacket.getSocketAddress();
            this.bytesRead.addAndGet(size);
            this.globalBytesRead.addAndGet(size);
            this.messagesRead.incrementAndGet();
            this.globalMessagesRead.incrementAndGet();
            return new MultipointReadResult<InetSocketAddress>(){

                public InetSocketAddress getSourceAddress() {
                    return socketAddress;
                }

                public InetSocketAddress getDestinationAddress() {
                    return null;
                }
            };
        }
    }

    public boolean isOpen() {
        return !this.datagramSocket.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closeCalled.getAndSet(true)) {
            Object object = this.writeLock;
            synchronized (object) {
                this.enableWrite = false;
            }
            object = this.readLock;
            synchronized (object) {
                this.enableRead = false;
            }
            try {
                this.readerTask.cancel();
            }
            catch (Throwable t) {
                log.trace(t, "Reader task cancel failed", new Object[0]);
            }
            try {
                this.writerTask.cancel();
            }
            catch (Throwable t) {
                log.trace(t, "Writer task cancel failed", new Object[0]);
            }
            object = this.writeLock;
            synchronized (object) {
                this.writable = false;
            }
            object = this.readLock;
            synchronized (object) {
                this.readable = false;
            }
            this.datagramSocket.close();
            IoUtils.invokeChannelListener((Channel)((Object)this), this.closeListener);
            log.trace("Closing channel %s", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(InetSocketAddress target, ByteBuffer buffer) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (!this.writable) {
                return false;
            }
            this.sendBuffer.clear();
            if (this.sendBuffer.remaining() < buffer.remaining()) {
                throw new IOException("Insufficient room in send buffer (send will never succeed); send buffer is " + this.sendBuffer.remaining() + " bytes, but transmitted datagram is " + buffer.remaining() + " bytes");
            }
            int cnt = buffer.remaining();
            this.bytesWritten.addAndGet(cnt);
            this.globalBytesWritten.addAndGet(cnt);
            this.messagesWritten.incrementAndGet();
            this.globalMessagesWritten.incrementAndGet();
            this.sendBuffer.put(buffer);
            this.sendPacket.setSocketAddress(target);
            this.sendPacket.setData(this.sendBuffer.array(), this.sendBuffer.arrayOffset(), this.sendBuffer.position());
            this.writeLock.notifyAll();
            this.writable = false;
            return true;
        }
    }

    public boolean send(InetSocketAddress target, ByteBuffer[] dsts) throws IOException {
        return this.send(target, dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(InetSocketAddress target, ByteBuffer[] dsts, int offset, int length) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            int i;
            if (!this.writable) {
                return false;
            }
            this.sendBuffer.clear();
            long t = 0L;
            for (i = 0; i < length; ++i) {
                t += (long)dsts[i + offset].remaining();
            }
            if ((long)this.sendBuffer.remaining() < t) {
                throw new IOException("Insufficient room in send buffer (send will never succeed); send buffer is " + this.sendBuffer.remaining() + " bytes, but transmitted datagram is " + t + " bytes");
            }
            for (i = 0; i < length; ++i) {
                this.sendBuffer.put(dsts[i + offset]);
            }
            this.sendPacket.setSocketAddress(target);
            this.sendPacket.setData(this.sendBuffer.array(), this.sendBuffer.arrayOffset(), this.sendBuffer.position());
            this.writeLock.notifyAll();
            this.writable = false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendReads() {
        Object object = this.readLock;
        synchronized (object) {
            this.enableRead = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendWrites() {
        Object object = this.readLock;
        synchronized (object) {
            this.enableWrite = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeReads() {
        Object object = this.readLock;
        synchronized (object) {
            this.enableRead = true;
            if (this.readable) {
                this.handlerExecutor.execute(this.readHandlerTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeWrites() {
        Object object = this.writeLock;
        synchronized (object) {
            this.enableWrite = true;
            if (this.writable) {
                this.handlerExecutor.execute(this.writeHandlerTask);
            }
        }
    }

    public void shutdownReads() throws IOException {
        throw new UnsupportedOperationException("Shutdown reads");
    }

    public void shutdownWrites() throws IOException {
        throw new UnsupportedOperationException("Shutdown writes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable() throws IOException {
        try {
            Object object = this.readLock;
            synchronized (object) {
                if (!this.isOpen()) {
                    return;
                }
                while (!this.readable) {
                    this.readLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        try {
            Object object = this.readLock;
            synchronized (object) {
                if (!this.isOpen()) {
                    return;
                }
                if (!this.readable) {
                    timeUnit.timedWait(this.readLock, time);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable() throws IOException {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                if (!this.isOpen()) {
                    return;
                }
                while (!this.writable) {
                    this.writeLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                if (!this.isOpen()) {
                    return;
                }
                if (!this.writable) {
                    timeUnit.timedWait(this.writeLock, time);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        if (Options.BROADCAST.equals(option)) {
            return (T)Boolean.valueOf(this.datagramSocket.getBroadcast());
        }
        if (Options.IP_TRAFFIC_CLASS.equals(option)) {
            int v = this.datagramSocket.getTrafficClass();
            return (T)(v == -1 ? null : Integer.valueOf(v));
        }
        return null;
    }

    public <T> Configurable setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (Options.BROADCAST.equals(option)) {
            this.datagramSocket.setBroadcast((Boolean)Options.BROADCAST.cast(value));
        } else if (Options.IP_TRAFFIC_CLASS.equals(option)) {
            this.datagramSocket.setTrafficClass((Integer)Options.IP_TRAFFIC_CLASS.cast(value));
        }
        return this;
    }

    public UdpChannel.Key join(InetAddress group, NetworkInterface iface) throws IOException {
        throw new UnsupportedOptionException("Multicast not supported");
    }

    public UdpChannel.Key join(InetAddress group, NetworkInterface iface, InetAddress source) throws IOException {
        throw new UnsupportedOptionException("Multicast not supported");
    }

    private final class WriteHandlerTask
    implements Runnable {
        private WriteHandlerTask() {
        }

        public void run() {
            IoUtils.invokeChannelListener((Channel)((Object)BioDatagramUdpChannel.this), (ChannelListener)BioDatagramUdpChannel.this.writeListener);
        }
    }

    private final class ReadHandlerTask
    implements Runnable {
        private ReadHandlerTask() {
        }

        public void run() {
            IoUtils.invokeChannelListener((Channel)((Object)BioDatagramUdpChannel.this), (ChannelListener)BioDatagramUdpChannel.this.readListener);
        }
    }

    private final class WriterTask
    implements Runnable {
        private volatile Thread thread;

        private WriterTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.thread = Thread.currentThread();
            try {
                while (true) {
                    Object object = BioDatagramUdpChannel.this.writeLock;
                    synchronized (object) {
                        BioDatagramUdpChannel.this.writable = true;
                        while (BioDatagramUdpChannel.this.writable) {
                            if (BioDatagramUdpChannel.this.enableWrite) {
                                BioDatagramUdpChannel.this.enableWrite = false;
                                BioDatagramUdpChannel.this.handlerExecutor.execute(BioDatagramUdpChannel.this.writeHandlerTask);
                            }
                            if (!BioDatagramUdpChannel.this.writable) continue;
                            try {
                                BioDatagramUdpChannel.this.writeLock.wait();
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                    }
                    try {
                        BioDatagramUdpChannel.this.datagramSocket.send(BioDatagramUdpChannel.this.sendPacket);
                    }
                    catch (IOException e) {
                        log.trace("Packet send failed: %s", (Object)e);
                    }
                }
            }
            finally {
                this.thread = null;
            }
        }

        public void cancel() {
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
        }
    }

    private final class ReaderTask
    implements Runnable {
        private volatile Thread thread;

        private ReaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.thread = Thread.currentThread();
            try {
                while (true) {
                    Object object = BioDatagramUdpChannel.this.readLock;
                    synchronized (object) {
                        while (BioDatagramUdpChannel.this.readable) {
                            try {
                                BioDatagramUdpChannel.this.readLock.wait();
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                    }
                    try {
                        BioDatagramUdpChannel.this.datagramSocket.receive(BioDatagramUdpChannel.this.receivePacket);
                    }
                    catch (IOException e) {
                        Object object2 = BioDatagramUdpChannel.this.readLock;
                        synchronized (object2) {
                            BioDatagramUdpChannel.this.readException = e;
                            BioDatagramUdpChannel.this.readable = true;
                            if (BioDatagramUdpChannel.this.enableRead) {
                                BioDatagramUdpChannel.this.handlerExecutor.execute(BioDatagramUdpChannel.this.readHandlerTask);
                            }
                            continue;
                        }
                    }
                    object = BioDatagramUdpChannel.this.readLock;
                    synchronized (object) {
                        BioDatagramUdpChannel.this.receiveBuffer.limit(BioDatagramUdpChannel.this.receivePacket.getLength());
                        BioDatagramUdpChannel.this.receiveBuffer.position(0);
                        BioDatagramUdpChannel.this.readable = true;
                        if (BioDatagramUdpChannel.this.enableRead) {
                            BioDatagramUdpChannel.this.handlerExecutor.execute(BioDatagramUdpChannel.this.readHandlerTask);
                        }
                    }
                }
            }
            finally {
                this.thread = null;
            }
        }

        public void cancel() {
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
        }
    }
}

