/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.CloseableTcpAcceptor;
import org.jboss.xnio.CloseableTcpConnector;
import org.jboss.xnio.ConfigurableFactory;
import org.jboss.xnio.FailedIoFuture;
import org.jboss.xnio.FinishedIoFuture;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Xnio;
import org.jboss.xnio.XnioConfiguration;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.BoundServer;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.channels.StreamSourceChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.management.OneWayPipeConnectionMBean;
import org.jboss.xnio.management.PipeConnectionMBean;
import org.jboss.xnio.management.PipeServerMBean;
import org.jboss.xnio.management.PipeSinkServerMBean;
import org.jboss.xnio.management.PipeSourceServerMBean;
import org.jboss.xnio.management.TcpConnectionMBean;
import org.jboss.xnio.management.TcpServerMBean;
import org.jboss.xnio.management.UdpServerMBean;
import org.jboss.xnio.nio.BioUdpServerFactory;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioOneWayPipeConnection;
import org.jboss.xnio.nio.NioPipeConnection;
import org.jboss.xnio.nio.NioSelectorRunnable;
import org.jboss.xnio.nio.NioTcpAcceptorFactory;
import org.jboss.xnio.nio.NioTcpConnectorFactory;
import org.jboss.xnio.nio.NioTcpServerFactory;
import org.jboss.xnio.nio.NioUdpServerFactory;
import org.jboss.xnio.nio.NioXnioConfiguration;
import org.jboss.xnio.nio.SelectorTask;
import org.jboss.xnio.nio.SynchronousHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioXnio
extends Xnio {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio");
    private final Object lock = new Object();
    private boolean closed;
    private final Executor executor;
    private final List<NioSelectorRunnable> readers = new ArrayList<NioSelectorRunnable>();
    private final List<NioSelectorRunnable> writers = new ArrayList<NioSelectorRunnable>();
    private final List<NioSelectorRunnable> connectors = new ArrayList<NioSelectorRunnable>();
    private final Set<Closeable> managedSet = new HashSet<Closeable>();
    private final AtomicInteger loadSequence = new AtomicInteger();
    private final int selectorCacheSize;
    private final LinkedList<Selector> selectorCache = new LinkedList();
    private final Lock selectorCacheLock = new ReentrantLock();

    public static Xnio create(NioXnioConfiguration configuration) throws IOException {
        return new NioXnio(configuration);
    }

    public static Xnio create() throws IOException {
        NioXnioConfiguration configuration = new NioXnioConfiguration();
        configuration.setReadSelectorThreads(1);
        configuration.setWriteSelectorThreads(1);
        configuration.setConnectSelectorThreads(1);
        return new NioXnio(configuration);
    }

    public static Xnio create(int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        NioXnioConfiguration configuration = new NioXnioConfiguration();
        configuration.setReadSelectorThreads(readSelectorThreads);
        configuration.setWriteSelectorThreads(writeSelectorThreads);
        configuration.setConnectSelectorThreads(connectSelectorThreads);
        return new NioXnio(configuration);
    }

    public static Xnio create(Executor handlerExecutor, int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        if (handlerExecutor == null) {
            throw new NullPointerException("handlerExecutor is null");
        }
        NioXnioConfiguration configuration = new NioXnioConfiguration();
        configuration.setExecutor(handlerExecutor);
        configuration.setReadSelectorThreads(readSelectorThreads);
        configuration.setWriteSelectorThreads(writeSelectorThreads);
        configuration.setConnectSelectorThreads(connectSelectorThreads);
        return new NioXnio(configuration);
    }

    public static Xnio create(Executor handlerExecutor, ThreadFactory selectorThreadFactory, int readSelectorThreads, int writeSelectorThreads, int connectSelectorThreads) throws IOException, IllegalArgumentException {
        if (handlerExecutor == null) {
            throw new NullPointerException("handlerExecutor is null");
        }
        if (selectorThreadFactory == null) {
            throw new NullPointerException("selectorThreadFactory is null");
        }
        NioXnioConfiguration configuration = new NioXnioConfiguration();
        configuration.setExecutor(handlerExecutor);
        configuration.setSelectorThreadFactory(selectorThreadFactory);
        configuration.setReadSelectorThreads(readSelectorThreads);
        configuration.setWriteSelectorThreads(writeSelectorThreads);
        configuration.setConnectSelectorThreads(connectSelectorThreads);
        return new NioXnio(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NioXnio(NioXnioConfiguration configuration) throws IOException {
        super((XnioConfiguration)configuration);
        ThreadFactory selectorThreadFactory = configuration.getSelectorThreadFactory();
        Executor executor = configuration.getExecutor();
        int readSelectorThreads = configuration.getReadSelectorThreads();
        int writeSelectorThreads = configuration.getWriteSelectorThreads();
        int connectSelectorThreads = configuration.getConnectSelectorThreads();
        int selectorCacheSize = configuration.getSelectorCacheSize();
        if (selectorThreadFactory == null) {
            selectorThreadFactory = Executors.defaultThreadFactory();
        }
        if (readSelectorThreads < 1) {
            throw new IllegalArgumentException("readSelectorThreads must be >= 1");
        }
        if (writeSelectorThreads < 1) {
            throw new IllegalArgumentException("writeSelectorThreads must be >= 1");
        }
        if (connectSelectorThreads < 1) {
            throw new IllegalArgumentException("connectSelectorThreads must be >= 1");
        }
        if (selectorCacheSize < 0) {
            throw new IllegalArgumentException("selectorCacheSize must be >= 0");
        }
        this.selectorCacheSize = selectorCacheSize;
        Object object = this.lock;
        synchronized (object) {
            int i;
            this.executor = executor == null ? IoUtils.directExecutor() : executor;
            for (i = 0; i < readSelectorThreads; ++i) {
                this.readers.add(new NioSelectorRunnable());
            }
            for (i = 0; i < writeSelectorThreads; ++i) {
                this.writers.add(new NioSelectorRunnable());
            }
            for (i = 0; i < connectSelectorThreads; ++i) {
                this.connectors.add(new NioSelectorRunnable());
            }
            for (NioSelectorRunnable runnable : this.readers) {
                selectorThreadFactory.newThread(runnable).start();
            }
            for (NioSelectorRunnable runnable : this.writers) {
                selectorThreadFactory.newThread(runnable).start();
            }
            for (NioSelectorRunnable runnable : this.connectors) {
                selectorThreadFactory.newThread(runnable).start();
            }
            log.debug("Creating NioXnio instance using executor %s, %d read threads, %d write threads, %d connect threads", new Object[]{this.executor, readSelectorThreads, writeSelectorThreads, connectSelectorThreads});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableFactory<BoundServer<SocketAddress, BoundChannel<SocketAddress>>> createTcpServer(Executor executor, IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (bindAddresses == null) {
            throw new NullPointerException("bindAddresses is null");
        }
        if (bindAddresses.length == 0) {
            throw new IllegalArgumentException("no bind addresses specified");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return new NioTcpServerFactory(this, executor, handlerFactory, bindAddresses);
        }
    }

    public ConfigurableFactory<BoundServer<SocketAddress, BoundChannel<SocketAddress>>> createTcpServer(IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        return this.createTcpServer(this.executor, handlerFactory, bindAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableFactory<CloseableTcpConnector> createTcpConnector(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return new NioTcpConnectorFactory(this, executor);
        }
    }

    public ConfigurableFactory<CloseableTcpConnector> createTcpConnector() {
        return this.createTcpConnector(this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableFactory<BoundServer<SocketAddress, UdpChannel>> createUdpServer(Executor executor, boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        if (bindAddresses == null) {
            throw new NullPointerException("bindAddresses is null");
        }
        if (bindAddresses.length == 0) {
            throw new IllegalArgumentException("no bind addresses specified");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            if (multicast) {
                return new BioUdpServerFactory(this, executor, handlerFactory, bindAddresses);
            }
            return new NioUdpServerFactory(this, executor, handlerFactory, bindAddresses);
        }
    }

    public ConfigurableFactory<BoundServer<SocketAddress, UdpChannel>> createUdpServer(boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        return this.createUdpServer(this.executor, multicast, handlerFactory, bindAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelSource<StreamChannel> createPipeServer(final Executor executor, final IoHandlerFactory<? super StreamChannel> handlerFactory) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return new ChannelSource<StreamChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IoFuture<StreamChannel> open(IoHandler<? super StreamChannel> handler) {
                    Object object = NioXnio.this.lock;
                    synchronized (object) {
                        NioPipeConnection nioPipeConnection;
                        if (NioXnio.this.closed) {
                            throw NioXnio.notOpen();
                        }
                        try {
                            nioPipeConnection = new NioPipeConnection(NioXnio.this, handler, (IoHandler<? super StreamChannel>)handlerFactory.createHandler(), executor);
                        }
                        catch (IOException e) {
                            return new FailedIoFuture(e);
                        }
                        return new FinishedIoFuture((Object)nioPipeConnection.getLeftSide());
                    }
                }
            };
        }
    }

    public ChannelSource<StreamChannel> createPipeServer(IoHandlerFactory<? super StreamChannel> handlerFactory) {
        return this.createPipeServer(this.executor, handlerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelSource<StreamSourceChannel> createPipeSourceServer(final Executor executor, final IoHandlerFactory<? super StreamSinkChannel> handlerFactory) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return new ChannelSource<StreamSourceChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IoFuture<StreamSourceChannel> open(IoHandler<? super StreamSourceChannel> handler) {
                    Object object = NioXnio.this.lock;
                    synchronized (object) {
                        NioOneWayPipeConnection nioPipeConnection;
                        if (NioXnio.this.closed) {
                            throw NioXnio.notOpen();
                        }
                        try {
                            nioPipeConnection = new NioOneWayPipeConnection(NioXnio.this, handler, (IoHandler<? super StreamSinkChannel>)handlerFactory.createHandler(), executor);
                        }
                        catch (IOException e) {
                            return new FailedIoFuture(e);
                        }
                        return new FinishedIoFuture((Object)nioPipeConnection.getSourceSide());
                    }
                }
            };
        }
    }

    public ChannelSource<StreamSourceChannel> createPipeSourceServer(IoHandlerFactory<? super StreamSinkChannel> handlerFactory) {
        return this.createPipeSourceServer(this.executor, handlerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelSource<StreamSinkChannel> createPipeSinkServer(final Executor executor, final IoHandlerFactory<? super StreamSourceChannel> handlerFactory) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return new ChannelSource<StreamSinkChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IoFuture<StreamSinkChannel> open(IoHandler<? super StreamSinkChannel> handler) {
                    Object object = NioXnio.this.lock;
                    synchronized (object) {
                        NioOneWayPipeConnection nioPipeConnection;
                        if (NioXnio.this.closed) {
                            throw NioXnio.notOpen();
                        }
                        try {
                            nioPipeConnection = new NioOneWayPipeConnection(NioXnio.this, (IoHandler<? super StreamSourceChannel>)handlerFactory.createHandler(), handler, executor);
                        }
                        catch (IOException e) {
                            return new FailedIoFuture(e);
                        }
                        return new FinishedIoFuture((Object)nioPipeConnection.getSinkSide());
                    }
                }
            };
        }
    }

    public ChannelSource<StreamSinkChannel> createPipeSinkServer(IoHandlerFactory<? super StreamSourceChannel> handlerFactory) {
        return this.createPipeSinkServer(this.executor, handlerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoFuture<Closeable> createPipeConnection(Executor executor, IoHandler<? super StreamChannel> leftHandler, IoHandler<? super StreamChannel> rightHandler) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (leftHandler == null) {
            throw new NullPointerException("leftHandler is null");
        }
        if (rightHandler == null) {
            throw new NullPointerException("rightHandler is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            try {
                return new FinishedIoFuture((Object)new NioPipeConnection(this, leftHandler, rightHandler, executor));
            }
            catch (IOException e) {
                return new FailedIoFuture(e);
            }
        }
    }

    public IoFuture<Closeable> createPipeConnection(IoHandler<? super StreamChannel> leftHandler, IoHandler<? super StreamChannel> rightHandler) {
        return this.createPipeConnection(this.executor, leftHandler, rightHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoFuture<Closeable> createOneWayPipeConnection(Executor executor, IoHandler<? super StreamSourceChannel> sourceHandler, IoHandler<? super StreamSinkChannel> sinkHandler) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (sourceHandler == null) {
            throw new NullPointerException("sourceHandler is null");
        }
        if (sinkHandler == null) {
            throw new NullPointerException("sinkHandler is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            try {
                return new FinishedIoFuture((Object)new NioOneWayPipeConnection(this, sourceHandler, sinkHandler, executor));
            }
            catch (IOException e) {
                return new FailedIoFuture(e);
            }
        }
    }

    public IoFuture<Closeable> createOneWayPipeConnection(IoHandler<? super StreamSourceChannel> sourceHandler, IoHandler<? super StreamSinkChannel> sinkHandler) {
        return this.createOneWayPipeConnection(this.executor, sourceHandler, sinkHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableFactory<CloseableTcpAcceptor> createTcpAcceptor(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw NioXnio.notOpen();
            }
            return new NioTcpAcceptorFactory(this, executor);
        }
    }

    public ConfigurableFactory<CloseableTcpAcceptor> createTcpAcceptor() {
        return this.createTcpAcceptor(this.executor);
    }

    public void awaken(Thread targetThread) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                Iterator<Closeable> it = this.managedSet.iterator();
                while (it.hasNext()) {
                    Closeable closeable = it.next();
                    it.remove();
                    IoUtils.safeClose((Closeable)closeable);
                }
                for (NioSelectorRunnable runnable : this.readers) {
                    runnable.shutdown();
                }
                for (NioSelectorRunnable runnable : this.writers) {
                    runnable.shutdown();
                }
                for (NioSelectorRunnable runnable : this.connectors) {
                    runnable.shutdown();
                }
                this.readers.clear();
                this.writers.clear();
                this.connectors.clear();
            }
        }
    }

    public String toString() {
        return "NIO " + super.toString();
    }

    protected Closeable registerMBean(TcpServerMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(TcpConnectionMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(UdpServerMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(OneWayPipeConnectionMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(PipeConnectionMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(PipeServerMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(PipeSourceServerMBean mBean) {
        return super.registerMBean(mBean);
    }

    protected Closeable registerMBean(PipeSinkServerMBean mBean) {
        return super.registerMBean(mBean);
    }

    private NioHandle doAdd(final SelectableChannel channel, List<NioSelectorRunnable> runnableSet, final Runnable handler, final boolean oneshot, Executor executor) throws IOException {
        NioSelectorRunnable nioSelectorRunnable;
        final SynchronousHolder holder = new SynchronousHolder();
        final NioSelectorRunnable actualSelectorRunnable = nioSelectorRunnable = runnableSet.get(this.loadSequence.getAndIncrement() % runnableSet.size());
        nioSelectorRunnable.runTask(new SelectorTask(){

            public void run(Selector selector) {
                try {
                    SelectionKey selectionKey = channel.register(selector, 0);
                    NioHandle handle = new NioHandle(selectionKey, actualSelectorRunnable, handler, NioXnio.this.executor, oneshot);
                    selectionKey.attach(handle);
                    holder.set(handle);
                }
                catch (ClosedChannelException e) {
                    holder.setProblem(e);
                }
            }
        });
        return (NioHandle)holder.get();
    }

    NioHandle addConnectHandler(SelectableChannel channel, Runnable handler, boolean oneshot) throws IOException {
        return this.doAdd(channel, this.connectors, handler, oneshot, this.executor);
    }

    NioHandle addConnectHandler(SelectableChannel channel, Runnable handler, boolean oneshot, Executor executor) throws IOException {
        return this.doAdd(channel, this.connectors, handler, oneshot, executor);
    }

    NioHandle addReadHandler(SelectableChannel channel, Runnable handler) throws IOException {
        return this.doAdd(channel, this.readers, handler, true, this.executor);
    }

    NioHandle addReadHandler(SelectableChannel channel, Runnable handler, Executor executor) throws IOException {
        return this.doAdd(channel, this.readers, handler, true, executor);
    }

    NioHandle addWriteHandler(SelectableChannel channel, Runnable handler) throws IOException {
        return this.doAdd(channel, this.writers, handler, true, this.executor);
    }

    NioHandle addWriteHandler(SelectableChannel channel, Runnable handler, Executor executor) throws IOException {
        return this.doAdd(channel, this.writers, handler, true, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addManaged(Closeable closeable) {
        Object object = this.lock;
        synchronized (object) {
            this.managedSet.add(closeable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeManaged(Closeable closeable) {
        Object object = this.lock;
        synchronized (object) {
            this.managedSet.remove(closeable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Selector getSelector() throws IOException {
        this.selectorCacheLock.lock();
        try {
            Selector selector = this.selectorCache.pop();
            Selector selector2 = selector == null ? Selector.open() : selector;
            return selector2;
        }
        finally {
            this.selectorCacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnSelector(Selector selector) {
        this.selectorCacheLock.lock();
        try {
            if (this.selectorCache.size() >= this.selectorCacheSize) {
                IoUtils.safeClose((Selector)selector);
            } else {
                this.selectorCache.push(selector);
            }
        }
        finally {
            this.selectorCacheLock.unlock();
        }
    }

    private static IllegalStateException notOpen() {
        return new IllegalStateException("XNIO provider not open");
    }

    static {
        log.info("XNIO NIO Implementation Version 1.2.0.CR1");
    }
}

