/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import org.jboss.xnio.AbstractFutureConnection;
import org.jboss.xnio.CloseableTcpConnector;
import org.jboss.xnio.FailedFutureConnection;
import org.jboss.xnio.FinishedFutureConnection;
import org.jboss.xnio.FutureConnection;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.TcpChannelSource;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioTcpChannel;
import org.jboss.xnio.nio.NioTcpConnectorConfig;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioTcpConnector
implements CloseableTcpConnector {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.tcp.connector");
    private final NioXnio nioXnio;
    private final Executor executor;
    private final Object lock = new Object();
    private boolean closed;
    private final Boolean keepAlive;
    private final Boolean oobInline;
    private final Integer receiveBufferSize;
    private final Boolean reuseAddress;
    private final Integer sendBufferSize;
    private final Boolean tcpNoDelay;
    private final boolean manageConnections;

    private NioTcpConnector(NioTcpConnectorConfig config) {
        this.nioXnio = config.getXnio();
        this.executor = config.getExecutor();
        if (this.nioXnio == null) {
            throw new NullPointerException("nioXnio is null");
        }
        if (this.executor == null) {
            throw new NullPointerException("executor is null");
        }
        this.keepAlive = config.getKeepAlive();
        this.oobInline = config.getOobInline();
        this.receiveBufferSize = config.getReceiveBuffer();
        this.reuseAddress = config.getReuseAddresses();
        this.sendBufferSize = config.getSendBuffer();
        this.tcpNoDelay = config.getNoDelay();
        this.manageConnections = config.isManageConnections();
    }

    private void configureStream(Socket socket) throws SocketException {
        if (this.keepAlive != null) {
            socket.setKeepAlive(this.keepAlive);
        }
        if (this.oobInline != null) {
            socket.setOOBInline(this.oobInline);
        }
        if (this.receiveBufferSize != null) {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.reuseAddress != null) {
            socket.setReuseAddress(this.reuseAddress);
        }
        if (this.sendBufferSize != null) {
            socket.setSendBufferSize(this.sendBufferSize);
        }
        if (this.tcpNoDelay != null) {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
    }

    public FutureConnection<SocketAddress, TcpChannel> connectTo(SocketAddress dest, IoHandler<? super TcpChannel> handler) {
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        return this.doConnectTo(null, dest, handler);
    }

    public FutureConnection<SocketAddress, TcpChannel> connectTo(SocketAddress src, SocketAddress dest, IoHandler<? super TcpChannel> handler) {
        if (src == null) {
            throw new NullPointerException("src is null");
        }
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        return this.doConnectTo(src, dest, handler);
    }

    public TcpChannelSource createChannelSource(final SocketAddress dest) {
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        return new TcpChannelSource(){

            public FutureConnection<SocketAddress, TcpChannel> open(IoHandler<? super TcpChannel> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is null");
                }
                return NioTcpConnector.this.doConnectTo(null, dest, (IoHandler<? super TcpChannel>)handler);
            }
        };
    }

    public TcpChannelSource createChannelSource(final SocketAddress src, final SocketAddress dest) {
        if (src == null) {
            throw new NullPointerException("src is null");
        }
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        return new TcpChannelSource(){

            public FutureConnection<SocketAddress, TcpChannel> open(IoHandler<? super TcpChannel> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is null");
                }
                return NioTcpConnector.this.doConnectTo(src, dest, (IoHandler<? super TcpChannel>)handler);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureConnection<SocketAddress, TcpChannel> doConnectTo(final SocketAddress src, final SocketAddress dest, final IoHandler<? super TcpChannel> handler) {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    throw new ClosedChannelException();
                }
                log.trace("Connecting from %s to %s", src == null ? "-any-" : src, (Object)dest);
                final SocketChannel socketChannel = SocketChannel.open();
                socketChannel.configureBlocking(false);
                Socket socket = socketChannel.socket();
                if (src != null) {
                    socket.bind(src);
                }
                this.configureStream(socket);
                if (socketChannel.connect(dest)) {
                    final NioTcpChannel channel = new NioTcpChannel(this.nioXnio, socketChannel, handler, this.executor, this.manageConnections);
                    this.nioXnio.addManaged(channel);
                    this.executor.execute(new Runnable(){

                        public void run() {
                            log.trace("Connection from %s to %s is up (immediate)", src == null ? "-any-" : src, (Object)dest);
                            if (!HandlerUtils.handleOpened(handler, channel)) {
                                IoUtils.safeClose((Closeable)socketChannel);
                                NioTcpConnector.this.nioXnio.removeManaged(channel);
                            }
                        }
                    });
                    return new FinishedFutureConnection((BoundChannel)channel);
                }
                ConnectionHandler connectionHandler = new ConnectionHandler(this.executor, socketChannel, this.nioXnio, handler);
                connectionHandler.handle.resume(8);
                return connectionHandler.future;
            }
        }
        catch (IOException e) {
            return new FailedFutureConnection(e, (Object)src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            log.trace("Closing %s", (Object)this);
            this.closed = true;
        }
    }

    public String toString() {
        return String.format("TCP connector (NIO) <%s>", Integer.toHexString(this.hashCode()));
    }

    static NioTcpConnector create(NioTcpConnectorConfig config) {
        return new NioTcpConnector(config);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConnectionHandler
    implements Runnable {
        private final FutureImpl future;
        private final SocketChannel socketChannel;
        private final NioHandle handle;
        private final IoHandler<? super TcpChannel> handler;

        public ConnectionHandler(Executor executor, SocketChannel socketChannel, NioXnio nioXnio, IoHandler<? super TcpChannel> handler) throws IOException {
            this.socketChannel = socketChannel;
            this.handler = handler;
            this.handle = nioXnio.addConnectHandler(socketChannel, this, true);
            this.future = new FutureImpl(executor, socketChannel.socket().getLocalSocketAddress());
        }

        @Override
        public void run() {
            try {
                if (!this.socketChannel.finishConnect()) {
                    log.trace("Connection is not yet up (deferred)");
                    this.handle.resume(8);
                    return;
                }
                log.trace("Connection is up (deferred)");
                NioTcpChannel channel = new NioTcpChannel(NioTcpConnector.this.nioXnio, this.socketChannel, this.handler, NioTcpConnector.this.executor, NioTcpConnector.this.manageConnections);
                this.future.setResult(channel);
                this.handler.handleOpened((Channel)((Object)channel));
                this.handle.cancelKey();
            }
            catch (IOException e) {
                this.future.setException(e);
                this.handle.cancelKey();
            }
            catch (Exception e) {
                String message = e.getMessage();
                IOException ioexception = new IOException("Connection failed unexpectedly: " + message);
                ioexception.setStackTrace(e.getStackTrace());
                this.future.setException(ioexception);
                this.handle.cancelKey();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class FutureImpl
        extends AbstractFutureConnection<SocketAddress, TcpChannel> {
            private final Executor executor;
            private final SocketAddress localAddress;

            public FutureImpl(Executor executor, SocketAddress address) {
                this.executor = executor;
                this.localAddress = address;
            }

            protected boolean setException(IOException exception) {
                return super.setException(exception);
            }

            protected boolean setResult(TcpChannel result) {
                return super.setResult((Object)result);
            }

            protected boolean finishCancel() {
                return super.finishCancel();
            }

            protected void runNotifier(final IoFuture.Notifier<TcpChannel> streamChannelNotifier) {
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            streamChannelNotifier.notify((IoFuture)FutureImpl.this);
                        }
                        catch (Throwable t) {
                            log.error(t, "Completion handler \"%s\" failed", (Object)streamChannelNotifier);
                        }
                    }
                });
            }

            public SocketAddress getLocalAddress() {
                return this.localAddress;
            }

            public FutureConnection<SocketAddress, TcpChannel> cancel() {
                if (this.finishCancel()) {
                    IoUtils.safeClose((Closeable)ConnectionHandler.this.socketChannel);
                }
                return this;
            }
        }
    }
}

