/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.xnio.IoFuture;

@MessageLogger(projectCode="XNIO")
interface Messages {
    public static final Messages msg = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.xnio");
    public static final Messages futureMsg = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.xnio.future");
    public static final Messages optionParseMsg = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.xnio.option.parse");
    public static final Messages closeMsg = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.xnio.safe-close");

    @Message(id=0, value="Method parameter '%s' cannot be null")
    public IllegalArgumentException nullParameter(String var1);

    @Message(id=1, value="Method parameter '%s' must be greater than %d")
    public IllegalArgumentException minRange(String var1, int var2);

    @Message(id=2, value="Unsupported socket address %s")
    public IllegalArgumentException badSockType(Class<? extends SocketAddress> var1);

    @Message(id=3, value="Method parameter '%s' contains disallowed null value at index %d")
    public IllegalArgumentException nullArrayIndex(String var1, int var2);

    @Message(id=4, value="Bind address %s is not the same type as destination address %s")
    public IllegalArgumentException mismatchSockType(Class<? extends SocketAddress> var1, Class<? extends SocketAddress> var2);

    @Message(id=5, value="No such field named \"%s\" in %s")
    public IllegalArgumentException noField(String var1, Class<?> var2);

    @Message(id=6, value="Class \"%s\" not found in %s")
    public IllegalArgumentException optionClassNotFound(String var1, ClassLoader var2);

    @Message(id=7, value="Field named \"%s\" is not accessible (public) in %s")
    public IllegalArgumentException fieldNotAccessible(String var1, Class<?> var2);

    @Message(id=8, value="Field named \"%s\" is not static in %s")
    public IllegalArgumentException fieldNotStatic(String var1, Class<?> var2);

    @Message(id=9, value="Copy with negative count is not supported")
    public UnsupportedOperationException copyNegative();

    @Message(id=10, value="Invalid option '%s' in property '%s': %s")
    @LogMessage(level=Logger.Level.WARN)
    public void invalidOptionInProperty(String var1, String var2, Throwable var3);

    @Message(id=100, value="Blocking I/O is not allowed on the current thread")
    public IllegalStateException blockingNotAllowed();

    @Message(id=101, value="No XNIO provider found")
    public IllegalArgumentException noProviderFound();

    @Message(id=102, value="Operation was cancelled")
    public CancellationException opCancelled();

    @Message(id=103, value="Running IoFuture notifier %s failed")
    @LogMessage(level=Logger.Level.WARN)
    public void notifierFailed(@Cause Throwable var1, IoFuture.Notifier<?, ?> var2);

    @Message(id=104, value="Operation timed out")
    public TimeoutException opTimedOut();

    @Message(id=105, value="Not allowed to read non-XNIO properties")
    public SecurityException propReadForbidden();

    @Message(value="Closing resource %s")
    @LogMessage(level=Logger.Level.TRACE)
    public void closingResource(Object var1);

    @Message(value="Closing resource %s failed")
    @LogMessage(level=Logger.Level.TRACE)
    public void resourceCloseFailed(@Cause Throwable var1, Object var2);

    @Message(value="Shutting down reads on %s failed")
    @LogMessage(level=Logger.Level.TRACE)
    public void resourceReadShutdownFailed(@Cause Throwable var1, Object var2);
}

