/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.ssl.SslConduitEngine;

public class SslStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final SslConduitEngine sslEngine;

    protected SslStreamSinkConduit(StreamSinkConduit next, SslConduitEngine sslEngine) {
        super(next);
        this.sslEngine = sslEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        ByteBuffer wrapBuffer = this.sslEngine.getWrappedBuffer();
        while (this.sslEngine.wrap(src)) {
            wrapBuffer.flip();
            try {
                int res;
                while (wrapBuffer.hasRemaining() && (res = super.write(wrapBuffer)) != 0) {
                }
            }
            finally {
                wrapBuffer.compact();
            }
        }
        return (int)this.sslEngine.resetBytesConsumed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        ByteBuffer wrapBuffer = this.sslEngine.getWrappedBuffer();
        while (this.sslEngine.wrap(srcs, offs, len)) {
            wrapBuffer.flip();
            try {
                int res;
                while (wrapBuffer.hasRemaining() && (res = super.write(wrapBuffer)) != 0) {
                }
            }
            finally {
                wrapBuffer.compact();
            }
        }
        return (int)this.sslEngine.resetBytesConsumed();
    }

    @Override
    public void terminateWrites() throws IOException {
        this.sslEngine.closeOutbound();
        super.terminateWrites();
    }

    @Override
    public void awaitWritable() throws IOException {
        this.sslEngine.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.sslEngine.awaitWritable(time, timeUnit);
    }

    @Override
    public void truncateWrites() throws IOException {
        this.sslEngine.closeOutbound();
        super.truncateWrites();
    }

    @Override
    public boolean flush() throws IOException {
        return this.sslEngine.flush();
    }
}

