/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.util.AbstractQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.BufferAllocator;
import org.xnio.Pool;
import org.xnio.PoolDepletedException;
import org.xnio.Pooled;

public final class ByteBufferSlicePool
implements Pool<ByteBuffer> {
    private final Set<Ref> refSet = Collections.synchronizedSet(new HashSet());
    private final Queue<Slice> sliceQueue;
    private final BufferAllocator<ByteBuffer> allocator;
    private final int bufferSize;
    private final int buffersPerRegion;
    private static final AtomicReferenceFieldUpdater<PooledByteBuffer, ByteBuffer> bufferUpdater = AtomicReferenceFieldUpdater.newUpdater(PooledByteBuffer.class, ByteBuffer.class, "buffer");

    public ByteBufferSlicePool(BufferAllocator<ByteBuffer> allocator, int bufferSize, int maxRegionSize) {
        AbstractQueue queue;
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than zero");
        }
        if (maxRegionSize < bufferSize) {
            throw new IllegalArgumentException("Maximum region size must be greater than or equal to the buffer size");
        }
        this.buffersPerRegion = maxRegionSize / bufferSize;
        this.bufferSize = bufferSize;
        this.allocator = allocator;
        try {
            queue = new LinkedTransferQueue();
        }
        catch (Throwable ignored) {
            queue = new ConcurrentLinkedQueue();
        }
        this.sliceQueue = queue;
    }

    public ByteBufferSlicePool(int bufferSize, int maxRegionSize) {
        this(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, bufferSize, maxRegionSize);
    }

    @Override
    public Pooled<ByteBuffer> allocate() {
        Queue<Slice> sliceQueue = this.sliceQueue;
        Slice slice = sliceQueue.poll();
        if (slice == null) {
            int bufferSize = this.bufferSize;
            int buffersPerRegion = this.buffersPerRegion;
            ByteBuffer region = this.allocator.allocate(buffersPerRegion * bufferSize);
            int idx = bufferSize;
            for (int i = 1; i < buffersPerRegion; ++i) {
                sliceQueue.add(new Slice(region, idx, bufferSize));
                idx += bufferSize;
            }
            Slice newSlice = new Slice(region, 0, bufferSize);
            return new PooledByteBuffer(newSlice, newSlice.slice());
        }
        if (slice == null) {
            throw new PoolDepletedException("Pool is empty");
        }
        return new PooledByteBuffer(slice, slice.slice());
    }

    private void doFree(Slice region) {
        this.sliceQueue.add(region);
    }

    private static final class QueueThread
    extends Thread {
        private static final ReferenceQueue<ByteBuffer> REFERENCE_QUEUE = new ReferenceQueue();
        private static final QueueThread INSTANCE = new QueueThread();

        private QueueThread() {
            this.setDaemon(true);
            this.setName("Buffer reclamation thread");
        }

        @Override
        public void run() {
            try {
                Ref reference = (Ref)REFERENCE_QUEUE.remove();
                reference.free();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        static {
            INSTANCE.start();
        }
    }

    private final class Ref
    extends PhantomReference<ByteBuffer> {
        private final Slice region;

        private Ref(ByteBuffer referent, Slice region) {
            super(referent, QueueThread.REFERENCE_QUEUE);
            this.region = region;
        }

        void free() {
            ByteBufferSlicePool.this.doFree(this.region);
            ByteBufferSlicePool.this.refSet.remove(this);
        }
    }

    private final class Slice {
        private final ByteBuffer parent;
        private final int start;
        private final int size;

        private Slice(ByteBuffer parent, int start, int size) {
            this.parent = parent;
            this.start = start;
            this.size = size;
        }

        ByteBuffer slice() {
            return ((ByteBuffer)this.parent.duplicate().position(this.start).limit(this.start + this.size)).slice();
        }
    }

    private final class PooledByteBuffer
    implements Pooled<ByteBuffer> {
        private final Slice region;
        volatile ByteBuffer buffer;

        PooledByteBuffer(Slice region, ByteBuffer buffer) {
            this.region = region;
            this.buffer = buffer;
        }

        @Override
        public void discard() {
            ByteBuffer buffer = bufferUpdater.getAndSet(this, null);
            if (buffer != null) {
                ByteBufferSlicePool.this.refSet.add(new Ref(buffer, this.region));
            }
        }

        @Override
        public void free() {
            if (bufferUpdater.getAndSet(this, null) != null) {
                ByteBufferSlicePool.this.doFree(this.region);
            }
        }

        @Override
        public ByteBuffer getResource() {
            ByteBuffer buffer = this.buffer;
            if (buffer == null) {
                throw new IllegalStateException();
            }
            return buffer;
        }

        protected void finalize() throws Throwable {
            this.discard();
            super.finalize();
        }

        public String toString() {
            return "Pooled buffer " + this.buffer;
        }
    }
}

