/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.ConcurrentStreamChannelAccessException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.WrappedChannel;

public class PushBackStreamChannel
implements StreamSourceChannel,
WrappedChannel<StreamSourceChannel> {
    private final StreamSourceChannel firstChannel;
    private volatile StreamSourceChannel channel;
    private volatile int flags;
    private final ChannelListener.Setter<PushBackStreamChannel> readSetter;
    private final ChannelListener.Setter<PushBackStreamChannel> closeSetter;
    private static final AtomicReferenceFieldUpdater<PushBackStreamChannel, StreamSourceChannel> channelUpdater = AtomicReferenceFieldUpdater.newUpdater(PushBackStreamChannel.class, StreamSourceChannel.class, "channel");
    private static final AtomicIntegerFieldUpdater<PushBackStreamChannel> flagsUpdater = AtomicIntegerFieldUpdater.newUpdater(PushBackStreamChannel.class, "flags");
    private static final int FLAG_ENTERED = 1;

    public PushBackStreamChannel(StreamSourceChannel channel) {
        this.channel = this.firstChannel = channel;
        this.readSetter = ChannelListeners.getDelegatingSetter(this.firstChannel.getReadSetter(), this);
        this.closeSetter = ChannelListeners.getDelegatingSetter(this.firstChannel.getCloseSetter(), this);
    }

    private void enter() {
        if (!flagsUpdater.compareAndSet(this, 0, 1)) {
            throw new ConcurrentStreamChannelAccessException();
        }
    }

    private void exit() {
        flagsUpdater.set(this, 0);
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel == null) {
            return 0L;
        }
        return channel.transferTo(position, count, target);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel == null) {
            return 0L;
        }
        return channel.transferTo(count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel == null) {
            return -1;
        }
        return channel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel == null) {
            return -1L;
        }
        return channel.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel == null) {
            return -1L;
        }
        return channel.read(dsts, offset, length);
    }

    public void unget(Pooled<ByteBuffer> buffer) {
        StreamSourceChannel old;
        do {
            if ((old = this.channel) != null) continue;
            buffer.free();
            return;
        } while (!channelUpdater.compareAndSet(this, old, new BufferHolder(old, buffer)));
    }

    public ChannelListener.Setter<? extends PushBackStreamChannel> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<? extends PushBackStreamChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public void suspendReads() {
        this.firstChannel.suspendReads();
    }

    @Override
    public void resumeReads() {
        StreamSourceChannel channel = this.channel;
        if (channel != null) {
            channel.resumeReads();
        }
    }

    @Override
    public boolean isReadResumed() {
        return this.firstChannel.isReadResumed();
    }

    @Override
    public void wakeupReads() {
        this.firstChannel.wakeupReads();
    }

    @Override
    public void shutdownReads() throws IOException {
        StreamSourceChannel old = channelUpdater.getAndSet(this, null);
        if (old != null) {
            old.shutdownReads();
        }
    }

    @Override
    public void awaitReadable() throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel != null) {
            channel.awaitReadable();
        }
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel != null) {
            channel.awaitReadable(time, timeUnit);
        }
    }

    @Override
    public XnioExecutor getReadThread() {
        return this.firstChannel.getReadThread();
    }

    @Override
    public XnioWorker getWorker() {
        return this.firstChannel.getWorker();
    }

    @Override
    public boolean isOpen() {
        return this.firstChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        StreamSourceChannel old = channelUpdater.getAndSet(this, null);
        if (old != null) {
            old.close();
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.firstChannel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.firstChannel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.firstChannel.setOption(option, value);
    }

    @Override
    public StreamSourceChannel getChannel() {
        return this.firstChannel;
    }

    class BufferHolder
    implements StreamSourceChannel {
        private final StreamSourceChannel next;
        private final Pooled<ByteBuffer> buffer;

        BufferHolder(StreamSourceChannel next, Pooled<ByteBuffer> buffer) {
            this.next = next;
            this.buffer = buffer;
        }

        /*
         * Exception decompiling
         */
        @Override
        public long transferTo(long position, long count, FileChannel target) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            long cnt;
            block7: {
                if (!Buffers.hasRemaining(dsts, offset, length)) {
                    return 0L;
                }
                PushBackStreamChannel.this.enter();
                ByteBuffer src = this.buffer.getResource();
                cnt = Buffers.copy(dsts, offset, length, src);
                if (!src.hasRemaining()) break block7;
                long l = cnt;
                PushBackStreamChannel.this.exit();
                return l;
            }
            try {
                try {
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    this.buffer.free();
                }
                catch (IllegalStateException ignored) {
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    cnt = 0L;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                PushBackStreamChannel.this.exit();
            }
            long res = this.next.read(dsts, offset, length);
            return res > 0L ? res + cnt : (cnt > 0L ? cnt : res);
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            int cnt;
            block7: {
                if (!dst.hasRemaining()) {
                    return 0;
                }
                PushBackStreamChannel.this.enter();
                ByteBuffer src = this.buffer.getResource();
                cnt = Buffers.copy(dst, src);
                if (!src.hasRemaining()) break block7;
                int n = cnt;
                PushBackStreamChannel.this.exit();
                return n;
            }
            try {
                try {
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    this.buffer.free();
                }
                catch (IllegalStateException ignored) {
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    cnt = 0;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                PushBackStreamChannel.this.exit();
            }
            int res = this.next.read(dst);
            return res > 0 ? res + cnt : (cnt > 0 ? cnt : res);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            PushBackStreamChannel.this.enter();
            try {
                this.buffer.free();
            }
            finally {
                PushBackStreamChannel.this.exit();
            }
            this.next.close();
        }

        @Override
        public void resumeReads() {
            PushBackStreamChannel.this.firstChannel.wakeupReads();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdownReads() throws IOException {
            PushBackStreamChannel.this.enter();
            try {
                this.buffer.free();
            }
            finally {
                PushBackStreamChannel.this.exit();
            }
            this.next.shutdownReads();
        }

        @Override
        public void awaitReadable() throws IOException {
        }

        @Override
        public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        }

        @Override
        public boolean isOpen() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void suspendReads() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isReadResumed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void wakeupReads() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XnioExecutor getReadThread() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XnioWorker getWorker() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean supportsOption(Option<?> option) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T getOption(Option<T> option) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
            throw new UnsupportedOperationException();
        }
    }
}

