/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.ConcurrentStreamChannelAccessException;
import org.xnio.channels.FixedLengthOverflowException;
import org.xnio.channels.FixedLengthUnderflowException;
import org.xnio.channels.ProtectedWrappedChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class FixedLengthStreamSinkChannel
implements StreamSinkChannel,
ProtectedWrappedChannel<StreamSinkChannel> {
    private final StreamSinkChannel delegate;
    private final int config;
    private final Object guard;
    private final ChannelListener<? super FixedLengthStreamSinkChannel> finishListener;
    private final ChannelListener.SimpleSetter<FixedLengthStreamSinkChannel> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<FixedLengthStreamSinkChannel> closeSetter = new ChannelListener.SimpleSetter();
    private volatile long state;
    private static final int CONF_FLAG_CONFIGURABLE = 1;
    private static final int CONF_FLAG_PASS_CLOSE = 2;
    private static final long FLAG_WRITE_ENTERED = Long.MIN_VALUE;
    private static final long FLAG_CLOSE_REQUESTED = 0x4000000000000000L;
    private static final long FLAG_CLOSE_COMPLETE = 0x2000000000000000L;
    private static final long FLAG_SUS_RES_SHUT_ENTERED = 0x1000000000000000L;
    private static final long FLAG_FINISHED = 0x800000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask(0, 58);
    private static final AtomicLongFieldUpdater<FixedLengthStreamSinkChannel> stateUpdater = AtomicLongFieldUpdater.newUpdater(FixedLengthStreamSinkChannel.class, "state");

    public FixedLengthStreamSinkChannel(StreamSinkChannel delegate, long contentLength, boolean configurable, boolean propagateClose, ChannelListener<? super FixedLengthStreamSinkChannel> finishListener, Object guard) {
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length must be greater than or equal to zero");
        }
        if (contentLength > MASK_COUNT) {
            throw new IllegalArgumentException("Content length is too long");
        }
        this.guard = guard;
        this.delegate = delegate;
        this.finishListener = finishListener;
        this.config = (configurable ? 1 : 0) | (propagateClose ? 2 : 0);
        this.state = contentLength;
        delegate.getWriteSetter().set(ChannelListeners.delegatingChannelListener(this, this.writeSetter));
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public StreamSinkChannel getChannel(Object guard) {
        Object ourGuard = this.guard;
        if (ourGuard == null || guard == ourGuard) {
            return this.delegate;
        }
        return null;
    }

    @Override
    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!src.hasRemaining()) {
            return 0;
        }
        long val = this.enterWrite();
        if (Bits.allAreSet(val, 0x4000000000000000L)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreSet(val, 0x800000000000000L)) {
            throw new FixedLengthOverflowException();
        }
        int res = 0;
        long remaining = val & MASK_COUNT;
        try {
            int lim = src.limit();
            int pos = src.position();
            if ((long)(lim - pos) > remaining) {
                src.limit((int)(remaining - (long)pos));
                try {
                    int n = res = this.delegate.write(src);
                    return n;
                }
                finally {
                    src.limit(lim);
                }
            }
            int n = res = this.delegate.write(src);
            return n;
        }
        finally {
            this.exitWrite(val, res);
        }
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        if (length == 1) {
            return this.write(srcs[offset]);
        }
        long val = this.enterWrite();
        if (Bits.allAreSet(val, 0x4000000000000000L)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreSet(val, 0x800000000000000L)) {
            throw new FixedLengthOverflowException();
        }
        long res = 0L;
        if ((val & MASK_COUNT) == 0L) {
            long l = -1L;
            return l;
        }
        long t = 0L;
        for (int i = 0; i < length; ++i) {
            ByteBuffer buffer = srcs[i + offset];
            int lim = buffer.limit();
            if ((t += (long)(lim - buffer.position())) <= (val & MASK_COUNT)) continue;
            buffer.limit(lim - (int)(t - (val & MASK_COUNT)));
            try {
                long l = res = this.delegate.write(srcs, offset, i + 1);
                return l;
            }
            finally {
                buffer.limit(lim);
            }
        }
        if (t == 0L) {
            long l = 0L;
            return l;
        }
        long l = res = this.delegate.write(srcs, offset, length);
        return l;
        finally {
            this.exitWrite(val, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long val = this.enterWrite();
        if (Bits.allAreSet(val, 0x4000000000000000L)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreSet(val, 0x800000000000000L)) {
            throw new FixedLengthOverflowException();
        }
        long res = 0L;
        try {
            long l = res = this.delegate.transferFrom(src, position, Math.min(count, val & MASK_COUNT));
            return l;
        }
        finally {
            this.exitWrite(val, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long val = this.enterWrite();
        if (Bits.allAreSet(val, 0x4000000000000000L)) {
            throw new ClosedChannelException();
        }
        if (Bits.allAreSet(val, 0x800000000000000L)) {
            throw new FixedLengthOverflowException();
        }
        long res = 0L;
        try {
            long l = res = this.delegate.transferFrom(source, Math.min(count, val & MASK_COUNT), throughBuffer);
            return l;
        }
        finally {
            this.exitWrite(val, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        long val = this.enterFlush();
        if (Bits.anyAreSet(val, 0x2800000000000000L)) {
            return true;
        }
        if (Bits.anyAreSet(val, Long.MIN_VALUE)) {
            return false;
        }
        boolean flushed = false;
        try {
            boolean bl = flushed = this.delegate.flush();
            return bl;
        }
        finally {
            this.exitFlush(val, flushed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendWrites() {
        long val = this.enterSuspendResume();
        if (Bits.anyAreSet(val, 0x3800000000000000L)) {
            return;
        }
        try {
            this.delegate.suspendWrites();
        }
        finally {
            this.exitSuspendResume(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeWrites() {
        long val = this.enterSuspendResume();
        if (Bits.anyAreSet(val, 0x3800000000000000L)) {
            return;
        }
        try {
            this.delegate.resumeWrites();
        }
        finally {
            this.exitSuspendResume(val);
        }
    }

    @Override
    public boolean isWriteResumed() {
        return Bits.allAreClear(this.state, 0x2800000000000000L) && this.delegate.isWriteResumed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeupWrites() {
        long val = this.enterSuspendResume();
        if (Bits.anyAreSet(val, 0x3800000000000000L)) {
            return;
        }
        try {
            this.delegate.wakeupWrites();
        }
        finally {
            this.exitSuspendResume(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownWrites() throws IOException {
        long val = this.enterShutdown();
        try {
            if (Bits.anyAreSet(val, MASK_COUNT)) {
                try {
                    throw new FixedLengthUnderflowException((val & MASK_COUNT) + " bytes remaining");
                }
                catch (Throwable throwable) {
                    if (Bits.allAreSet(this.config, 2)) {
                        IoUtils.safeClose(this.delegate);
                    }
                    throw throwable;
                }
            }
            if (Bits.allAreSet(this.config, 2)) {
                this.delegate.shutdownWrites();
            }
        }
        finally {
            this.exitShutdown(val);
        }
    }

    @Override
    public void awaitWritable() throws IOException {
        this.delegate.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.delegate.awaitWritable(time, timeUnit);
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 0x4000000000000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        long val = this.enterClose();
        try {
            if (Bits.anyAreSet(val, MASK_COUNT)) {
                try {
                    throw new FixedLengthUnderflowException((val & MASK_COUNT) + " bytes remaining");
                }
                catch (Throwable throwable) {
                    if (Bits.allAreSet(this.config, 2)) {
                        IoUtils.safeClose(this.delegate);
                    }
                    throw throwable;
                }
            }
            if (Bits.allAreSet(this.config, 2)) {
                this.delegate.close();
            }
        }
        finally {
            this.exitClose(val);
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return Bits.allAreSet(this.config, 1) && this.delegate.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return Bits.allAreSet(this.config, 1) ? (T)this.delegate.getOption(option) : null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return Bits.allAreSet(this.config, 1) ? (T)this.delegate.setOption(option, value) : null;
    }

    public long getRemaining() {
        return this.state & MASK_COUNT;
    }

    private long enterWrite() {
        long newVal;
        long oldVal;
        do {
            if (Bits.allAreSet(oldVal = this.state, 0x2000000000000000L) || Bits.allAreClear(oldVal, MASK_COUNT)) {
                return oldVal;
            }
            if (!Bits.allAreSet(oldVal, Long.MIN_VALUE)) continue;
            throw new ConcurrentStreamChannelAccessException();
        } while (!stateUpdater.weakCompareAndSet(this, oldVal, newVal = oldVal | Long.MIN_VALUE));
        return oldVal;
    }

    private void exitWrite(long oldVal, long consumed) {
        long newVal = oldVal - consumed;
        if (Bits.allAreClear(newVal, MASK_COUNT)) {
            newVal |= 0x800000000000000L;
        }
        while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.state;
            newVal = oldVal & Long.MAX_VALUE - consumed;
            if (!Bits.allAreClear(newVal, MASK_COUNT)) continue;
            newVal |= 0x800000000000000L;
        }
        if (Bits.allAreSet(newVal, 0x1000000000000000L)) {
            return;
        }
        if (Bits.allAreSet(newVal, 0x2000000000000000L)) {
            this.callClosed();
        }
        if (Bits.allAreClear(oldVal, 0x800000000000000L) && Bits.allAreSet(newVal, 0x800000000000000L)) {
            this.callFinish();
        }
    }

    private long enterFlush() {
        long newVal;
        long oldVal;
        do {
            if (!Bits.anyAreSet(oldVal = this.state, -6341068275337658368L)) continue;
            return oldVal;
        } while (!stateUpdater.weakCompareAndSet(this, oldVal, newVal = oldVal | Long.MIN_VALUE));
        return oldVal;
    }

    private void exitFlush(long oldVal, boolean flushed) {
        long newVal = oldVal;
        if (Bits.anyAreSet(oldVal, 0x4000000000000000L)) {
            newVal |= 0x2000000000000000L;
        }
        while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.state;
            newVal = oldVal & Long.MAX_VALUE;
            if (!flushed || !Bits.anyAreSet(oldVal, 0x4000000000000000L)) continue;
            newVal |= 0x2000000000000000L;
        }
        if (Bits.allAreSet(newVal, 0x1000000000000000L)) {
            return;
        }
        if (Bits.allAreSet(newVal, 0x2000000000000000L)) {
            this.callClosed();
        }
        if (Bits.anyAreSet(oldVal, MASK_COUNT) && Bits.allAreClear(newVal, MASK_COUNT)) {
            this.callFinish();
        }
    }

    private long enterSuspendResume() {
        long newVal;
        long oldVal;
        do {
            if (!Bits.anyAreSet(oldVal = this.state, 0x3000000000000000L)) continue;
            return oldVal;
        } while (!stateUpdater.weakCompareAndSet(this, oldVal, newVal = oldVal | 0x1000000000000000L));
        return oldVal;
    }

    private void exitSuspendResume(long oldVal) {
        boolean wasFinished = Bits.allAreSet(oldVal, 0x800000000000000L);
        boolean wasClosed = Bits.allAreClear(oldVal, 0x2000000000000000L);
        boolean wasEntered = Bits.allAreSet(oldVal, Long.MIN_VALUE);
        long newVal = oldVal & 0xEFFFFFFFFFFFFFFFL;
        if (Bits.allAreClear(newVal, MASK_COUNT)) {
            newVal |= 0x800000000000000L;
        }
        while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.state;
            newVal = oldVal & 0xEFFFFFFFFFFFFFFFL;
            if (!Bits.allAreClear(newVal, MASK_COUNT)) continue;
            newVal |= 0x800000000000000L;
        }
        if (!wasEntered) {
            if (!wasFinished && Bits.allAreSet(newVal, 0x800000000000000L)) {
                this.callFinish();
            }
            if (!wasClosed && Bits.allAreSet(newVal, 0x2000000000000000L)) {
                this.callClosed();
            }
        }
    }

    private long enterShutdown() {
        long newVal;
        long oldVal;
        do {
            if (Bits.anyAreSet(oldVal = this.state, 0x6000000000000000L)) {
                return oldVal;
            }
            newVal = oldVal | 0x1000000000000000L | 0x4000000000000000L | 0x800000000000000L;
            if (!Bits.allAreClear(oldVal, 0x800000000000000L)) continue;
            newVal |= 0x2800000000000000L;
        } while (!stateUpdater.weakCompareAndSet(this, oldVal, newVal));
        return oldVal;
    }

    private void exitShutdown(long oldVal) {
        boolean wasFinished = Bits.allAreSet(oldVal, 0x800000000000000L);
        boolean wasInSusRes = Bits.allAreSet(oldVal, 0x1000000000000000L);
        boolean wasEntered = Bits.allAreSet(oldVal, Long.MIN_VALUE);
        if (!wasInSusRes) {
            long newVal = oldVal & 0xEFFFFFFFFFFFFFFFL;
            while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                oldVal = this.state;
                newVal = oldVal & 0xEFFFFFFFFFFFFFFFL;
            }
            if (!wasEntered) {
                if (!wasFinished && Bits.allAreSet(newVal, 0x800000000000000L)) {
                    this.callFinish();
                }
                this.callClosed();
            }
        }
    }

    private long enterClose() {
        long newVal;
        long oldVal;
        do {
            if (Bits.anyAreSet(oldVal = this.state, 0x2000000000000000L)) {
                return oldVal;
            }
            newVal = oldVal | 0x1000000000000000L | 0x4000000000000000L | 0x2000000000000000L | 0x800000000000000L;
            if (!Bits.allAreClear(oldVal, 0x800000000000000L)) continue;
            newVal |= 0x6800000000000000L;
        } while (!stateUpdater.weakCompareAndSet(this, oldVal, newVal));
        return oldVal;
    }

    private void exitClose(long oldVal) {
        boolean wasFinished = Bits.allAreSet(oldVal, 0x800000000000000L);
        boolean wasInSusRes = Bits.allAreSet(oldVal, 0x1000000000000000L);
        boolean wasEntered = Bits.allAreSet(oldVal, Long.MIN_VALUE);
        if (!wasInSusRes) {
            long newVal = oldVal & 0xEFFFFFFFFFFFFFFFL;
            while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                oldVal = this.state;
                newVal = oldVal & 0xEFFFFFFFFFFFFFFFL;
            }
            if (!wasEntered) {
                if (!wasFinished && Bits.allAreSet(newVal, 0x800000000000000L)) {
                    this.callFinish();
                }
                this.callClosed();
            }
        }
    }

    private void callFinish() {
        ChannelListeners.invokeChannelListener(this, this.finishListener);
    }

    private void callClosed() {
        ChannelListeners.invokeChannelListener(this, this.closeSetter.get());
    }
}

