/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.WrappedChannel;

public class PushBackStreamChannel
implements StreamSourceChannel,
WrappedChannel<StreamSourceChannel> {
    private final StreamSourceChannel firstChannel;
    private volatile StreamSourceChannel channel;
    private final ChannelListener.Setter<PushBackStreamChannel> readSetter;
    private final ChannelListener.Setter<PushBackStreamChannel> closeSetter;
    private static final AtomicReferenceFieldUpdater<PushBackStreamChannel, StreamSourceChannel> channelUpdater = AtomicReferenceFieldUpdater.newUpdater(PushBackStreamChannel.class, StreamSourceChannel.class, "channel");

    public PushBackStreamChannel(StreamSourceChannel channel) {
        this.channel = this.firstChannel = channel;
        this.readSetter = ChannelListeners.getDelegatingSetter(this.firstChannel.getReadSetter(), this);
        this.closeSetter = ChannelListeners.getDelegatingSetter(this.firstChannel.getCloseSetter(), this);
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return this.channel.transferTo(position, count, target);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return this.channel.transferTo(count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.channel.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.channel.read(dsts, offset, length);
    }

    public void unget(Pooled<ByteBuffer> buffer) {
        StreamSourceChannel old;
        do {
            if ((old = this.channel) != null) continue;
            buffer.free();
            return;
        } while (!channelUpdater.compareAndSet(this, old, new BufferHolder(old, buffer)));
    }

    public ChannelListener.Setter<? extends PushBackStreamChannel> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<? extends PushBackStreamChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public void suspendReads() {
        this.firstChannel.suspendReads();
    }

    @Override
    public void resumeReads() {
        this.firstChannel.resumeReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.firstChannel.isReadResumed();
    }

    @Override
    public void wakeupReads() {
        this.firstChannel.wakeupReads();
    }

    @Override
    public void shutdownReads() throws IOException {
        StreamSourceChannel old = channelUpdater.getAndSet(this, null);
        if (old != null) {
            old.shutdownReads();
        }
    }

    @Override
    public void awaitReadable() throws IOException {
        this.channel.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.channel.awaitReadable(time, timeUnit);
    }

    @Override
    public XnioExecutor getReadThread() {
        return this.firstChannel.getReadThread();
    }

    @Override
    public XnioWorker getWorker() {
        return this.firstChannel.getWorker();
    }

    @Override
    public boolean isOpen() {
        return this.firstChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        StreamSourceChannel old = channelUpdater.getAndSet(this, null);
        if (old != null) {
            old.close();
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.firstChannel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.firstChannel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.firstChannel.setOption(option, value);
    }

    @Override
    public StreamSourceChannel getChannel() {
        return this.firstChannel;
    }

    class BufferHolder
    implements StreamSourceChannel {
        private final StreamSourceChannel next;
        private final Pooled<ByteBuffer> buffer;

        BufferHolder(StreamSourceChannel next, Pooled<ByteBuffer> buffer) {
            this.next = next;
            this.buffer = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long transferTo(long position, long count, FileChannel target) throws IOException {
            BufferHolder bufferHolder = this;
            synchronized (bufferHolder) {
                long cnt;
                try {
                    ByteBuffer src = this.buffer.getResource();
                    int pos = src.position();
                    int rem = src.remaining();
                    if ((long)rem > count) {
                        try {
                            src.limit(pos + (int)count);
                            long l = target.write(src, position);
                            return l;
                        }
                        finally {
                            src.limit(pos + rem);
                        }
                    }
                    cnt = target.write(src, position);
                    if (cnt != (long)rem) return cnt;
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    this.buffer.free();
                    position += cnt;
                    count -= cnt;
                }
                catch (IllegalStateException ignored) {
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    cnt = 0L;
                }
                return cnt + this.next.transferTo(position, count, target);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
            long l;
            long cnt;
            BufferHolder bufferHolder = this;
            synchronized (bufferHolder) {
                throughBuffer.clear();
                try {
                    ByteBuffer src = this.buffer.getResource();
                    int pos = src.position();
                    int rem = src.remaining();
                    if ((long)rem > count) {
                        try {
                            src.limit(pos + (int)count);
                            throughBuffer.limit(0);
                            long l2 = target.write(src);
                            return l2;
                        }
                        finally {
                            src.limit(pos + rem);
                        }
                    }
                    cnt = target.write(src);
                    if (cnt != (long)rem) return cnt;
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    this.buffer.free();
                }
                catch (IllegalStateException ignored) {
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    cnt = 0L;
                }
            }
            long res = this.next.transferTo(count, throughBuffer, target);
            if (res > 0L) {
                l = cnt + res;
                return l;
            }
            if (cnt > 0L) {
                l = cnt;
                return l;
            }
            l = res;
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            long cnt;
            if (!Buffers.hasRemaining(dsts, offset, length)) {
                return 0L;
            }
            BufferHolder bufferHolder = this;
            synchronized (bufferHolder) {
                try {
                    ByteBuffer src = this.buffer.getResource();
                    cnt = Buffers.copy(dsts, offset, length, src);
                    if (src.hasRemaining()) {
                        return cnt;
                    }
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    this.buffer.free();
                }
                catch (IllegalStateException ignored) {
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    cnt = 0L;
                }
            }
            long res = this.next.read(dsts, offset, length);
            return res > 0L ? res + cnt : (cnt > 0L ? cnt : res);
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            int cnt;
            if (!dst.hasRemaining()) {
                return 0;
            }
            BufferHolder bufferHolder = this;
            synchronized (bufferHolder) {
                try {
                    ByteBuffer src = this.buffer.getResource();
                    cnt = Buffers.copy(dst, src);
                    if (src.hasRemaining()) {
                        return cnt;
                    }
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    this.buffer.free();
                }
                catch (IllegalStateException ignored) {
                    channelUpdater.compareAndSet(PushBackStreamChannel.this, this, this.next);
                    cnt = 0;
                }
            }
            int res = this.next.read(dst);
            return res > 0 ? res + cnt : (cnt > 0 ? cnt : res);
        }

        @Override
        public synchronized void close() throws IOException {
            this.buffer.free();
            this.next.close();
        }

        @Override
        public void awaitReadable() throws IOException {
        }

        @Override
        public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
            return null;
        }

        @Override
        public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
            return null;
        }

        @Override
        public void suspendReads() {
        }

        @Override
        public void resumeReads() {
        }

        @Override
        public boolean isReadResumed() {
            return false;
        }

        @Override
        public void wakeupReads() {
        }

        @Override
        public void shutdownReads() throws IOException {
        }

        @Override
        public XnioExecutor getReadThread() {
            return null;
        }

        @Override
        public XnioWorker getWorker() {
            return null;
        }

        @Override
        public boolean supportsOption(Option<?> option) {
            return false;
        }

        @Override
        public <T> T getOption(Option<T> option) throws IOException {
            return null;
        }

        @Override
        public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
            return null;
        }
    }
}

