/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.Channels;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.SuspendableReadChannel;
import org.xnio.channels.SuspendableWriteChannel;
import org.xnio.channels.WritableMessageChannel;

public final class ChannelListeners {
    private static final ChannelListener<Channel> NULL_LISTENER = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
        }
    };
    private static final ChannelListener.Setter<?> NULL_SETTER = new ChannelListener.Setter<Channel>(){

        @Override
        public void set(ChannelListener<? super Channel> channelListener) {
        }
    };
    private static final Logger listenerLog = Logger.getLogger((String)"org.xnio.listener");
    private static ChannelListener<Channel> CLOSING_CHANNEL_LISTENER = new ChannelListener<Channel>(){

        @Override
        public void handleEvent(Channel channel) {
            IoUtils.safeClose(channel);
        }
    };
    private static final ChannelExceptionHandler<Channel> CLOSING_HANDLER = new ChannelExceptionHandler<Channel>(){

        @Override
        public void handleException(Channel channel, IOException exception) {
            IoUtils.safeClose(channel);
        }
    };

    private ChannelListeners() {
    }

    public static <T extends Channel> boolean invokeChannelListener(T channel, ChannelListener<? super T> channelListener) {
        if (channelListener != null) {
            try {
                listenerLog.tracef("Invoking listener %s on channel %s", channelListener, channel);
                channelListener.handleEvent(channel);
            }
            catch (Throwable t) {
                listenerLog.errorf(t, "A channel event listener threw an exception", new Object[0]);
                return false;
            }
        }
        return true;
    }

    public static <T extends Channel> void invokeChannelListener(Executor executor, T channel, ChannelListener<? super T> channelListener) {
        try {
            executor.execute(ChannelListeners.getChannelListenerTask(channel, channelListener));
        }
        catch (RejectedExecutionException ree) {
            ChannelListeners.invokeChannelListener(channel, channelListener);
        }
    }

    public static <T extends Channel> Runnable getChannelListenerTask(final T channel, final ChannelListener<? super T> channelListener) {
        return new Runnable(){

            @Override
            public void run() {
                ChannelListeners.invokeChannelListener(channel, channelListener);
            }
        };
    }

    public static ChannelListener<Channel> closingChannelListener() {
        return CLOSING_CHANNEL_LISTENER;
    }

    public static ChannelListener<Channel> nullChannelListener() {
        return NULL_LISTENER;
    }

    public static ChannelExceptionHandler<Channel> closingChannelExceptionHandler() {
        return CLOSING_HANDLER;
    }

    public static <C extends ConnectedChannel> ChannelListener<AcceptingChannel<C>> openListenerAdapter(final ChannelListener<? super C> openListener) {
        if (openListener == null) {
            throw new IllegalArgumentException("openListener is null");
        }
        return new ChannelListener<AcceptingChannel<C>>(){

            @Override
            public void handleEvent(AcceptingChannel<C> channel) {
                try {
                    Object accepted = channel.accept();
                    if (accepted != null) {
                        ChannelListeners.invokeChannelListener(accepted, openListener);
                    }
                }
                catch (IOException e) {
                    listenerLog.errorf("Failed to accept a connection on %s: %s", channel, (Object)e);
                }
            }

            public String toString() {
                return "Accepting listener for " + openListener;
            }
        };
    }

    public static <T extends Channel, C> ChannelListener.Setter<T> getSetter(final C channel, final AtomicReferenceFieldUpdater<C, ChannelListener> updater) {
        return new ChannelListener.Setter<T>(){

            @Override
            public void set(ChannelListener<? super T> channelListener) {
                updater.set(channel, channelListener);
            }
        };
    }

    public static <T extends Channel> ChannelListener.Setter<T> getSetter(final AtomicReference<ChannelListener<? super T>> atomicReference) {
        return new ChannelListener.Setter<T>(){

            @Override
            public void set(ChannelListener<? super T> channelListener) {
                atomicReference.set(channelListener);
            }
        };
    }

    public static <T extends Channel> ChannelListener.Setter<T> getDelegatingSetter(ChannelListener.Setter<? extends Channel> target, T realChannel) {
        return target == null ? null : ChannelListeners.delegatingSetter(target, realChannel);
    }

    private static <T extends Channel, O extends Channel> DelegatingSetter<T, O> delegatingSetter(ChannelListener.Setter<O> setter, T realChannel) {
        return new DelegatingSetter<T, O>(setter, realChannel);
    }

    public static <T extends Channel> ChannelListener.Setter<T> nullSetter() {
        return NULL_SETTER;
    }

    public static <T extends Channel> ChannelListener<T> executorChannelListener(final ChannelListener<T> listener, final Executor executor) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                try {
                    executor.execute(ChannelListeners.getChannelListenerTask(channel, listener));
                }
                catch (RejectedExecutionException e) {
                    listenerLog.errorf("Failed to submit task to executor: %s (closing %s)", (Object)e, channel);
                    IoUtils.safeClose(channel);
                }
            }
        };
    }

    public static <T extends SuspendableWriteChannel> ChannelListener<T> flushingChannelListener(final ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                boolean result;
                try {
                    result = channel.flush();
                }
                catch (IOException e) {
                    channel.suspendWrites();
                    exceptionHandler.handleException(channel, e);
                    return;
                }
                if (result) {
                    Channels.setWriteListener(channel, delegate);
                    delegate.handleEvent(channel);
                } else {
                    Channels.setWriteListener(channel, this);
                    channel.resumeWrites();
                }
            }

            public String toString() {
                return "Flushing channel listener -> " + delegate;
            }
        };
    }

    public static <T extends SuspendableWriteChannel> ChannelListener<T> writeShutdownChannelListener(ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        final ChannelListener<? super T> flushingListener = ChannelListeners.flushingChannelListener(delegate, exceptionHandler);
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                try {
                    channel.shutdownWrites();
                }
                catch (IOException e) {
                    exceptionHandler.handleException(channel, e);
                    return;
                }
                flushingListener.handleEvent(channel);
            }
        };
    }

    public static <T extends StreamSinkChannel> ChannelListener<T> writingChannelListener(final Pooled<ByteBuffer> pooled, final ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        return new ChannelListener<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(T channel) {
                ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                boolean ok = false;
                do {
                    int result;
                    try {
                        result = channel.write(buffer);
                        ok = true;
                    }
                    catch (IOException e) {
                        channel.suspendWrites();
                        pooled.free();
                        exceptionHandler.handleException(channel, e);
                        return;
                    }
                    finally {
                        if (!ok) {
                            pooled.free();
                        }
                    }
                    if (result != 0) continue;
                    Channels.setWriteListener(channel, this);
                    channel.resumeWrites();
                    return;
                } while (buffer.hasRemaining());
                pooled.free();
                delegate.handleEvent(channel);
            }

            public String toString() {
                return "Writing channel listener -> " + delegate;
            }
        };
    }

    public static <T extends WritableMessageChannel> ChannelListener<T> sendingChannelListener(final Pooled<ByteBuffer> pooled, final ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        return new ChannelListener<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(T channel) {
                ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                boolean free = true;
                try {
                    free = channel.send(buffer);
                    if (!free) {
                        Channels.setWriteListener(channel, this);
                        channel.resumeWrites();
                        return;
                    }
                }
                catch (IOException e) {
                    channel.suspendWrites();
                    pooled.free();
                    exceptionHandler.handleException(channel, e);
                    return;
                }
                finally {
                    if (free) {
                        pooled.free();
                    }
                }
                delegate.handleEvent(channel);
            }

            public String toString() {
                return "Sending channel listener -> " + delegate;
            }
        };
    }

    public static <T extends StreamSinkChannel> ChannelListener<T> fileSendingChannelListener(final FileChannel source, final long position, final long count, final ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        if (count == 0L) {
            return ChannelListeners.delegatingChannelListener(delegate);
        }
        return new ChannelListener<T>(){
            private long p;
            private long cnt;
            {
                this.p = position;
                this.cnt = count;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(T channel) {
                long cnt = this.cnt;
                long p = this.p;
                try {
                    do {
                        long result;
                        try {
                            result = channel.transferFrom(source, p, cnt);
                        }
                        catch (IOException e) {
                            exceptionHandler.handleException(channel, e);
                            this.p = p;
                            this.cnt = cnt;
                            return;
                        }
                        if (result == 0L) {
                            Channels.setWriteListener(channel, this);
                            channel.resumeWrites();
                            return;
                        }
                        p += result;
                        if ((cnt -= result) != 0L) continue;
                        delegate.handleEvent(channel);
                        return;
                    } while (cnt > 0L);
                }
                finally {
                    this.p = p;
                    this.cnt = cnt;
                }
            }
        };
    }

    public static <T extends StreamSourceChannel> ChannelListener<T> fileReceivingChannelListener(final FileChannel target, final long position, final long count, final ChannelListener<? super T> delegate, final ChannelExceptionHandler<? super T> exceptionHandler) {
        if (count == 0L) {
            return ChannelListeners.delegatingChannelListener(delegate);
        }
        return new ChannelListener<T>(){
            private long p;
            private long cnt;
            {
                this.p = position;
                this.cnt = count;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(T channel) {
                long cnt = this.cnt;
                long p = this.p;
                try {
                    do {
                        long result;
                        try {
                            result = channel.transferTo(p, cnt, target);
                        }
                        catch (IOException e) {
                            exceptionHandler.handleException(channel, e);
                            this.p = p;
                            this.cnt = cnt;
                            return;
                        }
                        if (result == 0L) {
                            Channels.setReadListener(channel, this);
                            channel.resumeReads();
                            return;
                        }
                        p += result;
                        if ((cnt -= result) != 0L) continue;
                        delegate.handleEvent(channel);
                        return;
                    } while (cnt > 0L);
                }
                finally {
                    this.p = p;
                    this.cnt = cnt;
                }
            }
        };
    }

    public static <T extends Channel> ChannelListener<T> delegatingChannelListener(final ChannelListener<? super T> delegate) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                delegate.handleEvent(channel);
            }
        };
    }

    public static <T extends SuspendableWriteChannel> ChannelListener<T> writeSuspendingChannelListener(final ChannelListener<? super T> delegate) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                channel.suspendWrites();
                delegate.handleEvent(channel);
            }
        };
    }

    public static <T extends SuspendableReadChannel> ChannelListener<T> readSuspendingChannelListener(final ChannelListener<? super T> delegate) {
        return new ChannelListener<T>(){

            @Override
            public void handleEvent(T channel) {
                channel.suspendReads();
                delegate.handleEvent(channel);
            }
        };
    }

    public static <I extends StreamSourceChannel, O extends StreamSinkChannel> void initiateTransfer(I source, O sink, Pool<ByteBuffer> pool) {
        ChannelListeners.initiateTransfer(Long.MAX_VALUE, source, sink, CLOSING_CHANNEL_LISTENER, CLOSING_CHANNEL_LISTENER, CLOSING_HANDLER, CLOSING_HANDLER, pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends StreamSourceChannel, O extends StreamSinkChannel> void initiateTransfer(long count, I source, O sink, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener, ChannelExceptionHandler<? super I> readExceptionHandler, ChannelExceptionHandler<? super O> writeExceptionHandler, Pool<ByteBuffer> pool) {
        if (pool == null) {
            throw new IllegalArgumentException("pool is null");
        }
        Pooled<ByteBuffer> allocated = pool.allocate();
        boolean free = true;
        try {
            long transferred;
            ByteBuffer buffer = allocated.getResource();
            do {
                try {
                    transferred = source.transferTo(count, buffer, sink);
                }
                catch (IOException e) {
                    readExceptionHandler.handleException(source, e);
                    if (free) {
                        allocated.free();
                    }
                    return;
                }
                if (transferred == -1L) {
                    if (count == Long.MAX_VALUE) {
                        Channels.setReadListener(source, sourceListener);
                        if (sourceListener == null) {
                            source.suspendReads();
                        } else {
                            source.wakeupReads();
                        }
                        Channels.setWriteListener(sink, sinkListener);
                        if (sinkListener == null) {
                            sink.suspendWrites();
                        } else {
                            sink.wakeupWrites();
                        }
                    } else {
                        source.suspendReads();
                        sink.suspendWrites();
                        readExceptionHandler.handleException(source, new EOFException());
                    }
                    return;
                }
                if (count != Long.MAX_VALUE) {
                    count -= transferred;
                }
                while (buffer.hasRemaining()) {
                    int res;
                    try {
                        res = sink.write(buffer);
                    }
                    catch (IOException e) {
                        writeExceptionHandler.handleException(sink, e);
                        if (free) {
                            allocated.free();
                        }
                        return;
                    }
                    if (res != 0) continue;
                    TransferListener<? super I, ? super O> listener = new TransferListener<I, O>(count, allocated, source, sink, sourceListener, sinkListener, writeExceptionHandler, readExceptionHandler, 1);
                    source.suspendReads();
                    source.getReadSetter().set(listener);
                    sink.getWriteSetter().set(listener);
                    sink.resumeWrites();
                    free = false;
                    return;
                }
            } while (transferred > 0L);
            TransferListener<? super I, ? super O> listener = new TransferListener<I, O>(count, allocated, source, sink, sourceListener, sinkListener, writeExceptionHandler, readExceptionHandler, 0);
            sink.suspendWrites();
            sink.getWriteSetter().set(listener);
            source.getReadSetter().set(listener);
            source.resumeReads();
            free = false;
            return;
        }
        finally {
            if (free) {
                allocated.free();
            }
        }
    }

    private static class DelegatingChannelListener<T extends Channel, O extends Channel>
    implements ChannelListener<O> {
        private final ChannelListener<? super T> channelListener;
        private final T realChannel;

        public DelegatingChannelListener(ChannelListener<? super T> channelListener, T realChannel) {
            this.channelListener = channelListener;
            this.realChannel = realChannel;
        }

        @Override
        public void handleEvent(Channel channel) {
            this.channelListener.handleEvent(this.realChannel);
        }
    }

    private static class DelegatingSetter<T extends Channel, O extends Channel>
    implements ChannelListener.Setter<T> {
        private final ChannelListener.Setter<O> setter;
        private final T realChannel;

        DelegatingSetter(ChannelListener.Setter<O> setter, T realChannel) {
            this.setter = setter;
            this.realChannel = realChannel;
        }

        @Override
        public void set(ChannelListener<? super T> channelListener) {
            this.setter.set(channelListener == null ? null : new DelegatingChannelListener(channelListener, this.realChannel));
        }
    }

    static final class TransferListener<I extends StreamSourceChannel, O extends StreamSinkChannel>
    implements ChannelListener<Channel> {
        private final Pooled<ByteBuffer> pooledBuffer;
        private final I source;
        private final O sink;
        private final ChannelListener<? super I> sourceListener;
        private final ChannelListener<? super O> sinkListener;
        private final ChannelExceptionHandler<? super O> writeExceptionHandler;
        private final ChannelExceptionHandler<? super I> readExceptionHandler;
        private long count;
        private volatile int state;

        TransferListener(long count, Pooled<ByteBuffer> pooledBuffer, I source, O sink, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener, ChannelExceptionHandler<? super O> writeExceptionHandler, ChannelExceptionHandler<? super I> readExceptionHandler, int state) {
            this.count = count;
            this.pooledBuffer = pooledBuffer;
            this.source = source;
            this.sink = sink;
            this.sourceListener = sourceListener;
            this.sinkListener = sinkListener;
            this.writeExceptionHandler = writeExceptionHandler;
            this.readExceptionHandler = readExceptionHandler;
            this.state = state;
        }

        @Override
        public void handleEvent(Channel channel) {
            ByteBuffer buffer = this.pooledBuffer.getResource();
            int state = this.state;
            long count = this.count;
            switch (state) {
                case 0: {
                    block12: while (true) {
                        int ires;
                        long lres;
                        try {
                            lres = this.source.transferTo(count, buffer, (StreamSinkChannel)this.sink);
                        }
                        catch (IOException e) {
                            this.readFailed(e);
                            return;
                        }
                        if (lres == 0L) {
                            this.count = count;
                            return;
                        }
                        if (lres == -1L) {
                            if (count == Long.MAX_VALUE) {
                                this.done();
                                return;
                            }
                            this.readFailed(new EOFException());
                            return;
                        }
                        if (count != Long.MAX_VALUE) {
                            count -= lres;
                        }
                        do {
                            if (!buffer.hasRemaining()) continue block12;
                            try {
                                ires = this.sink.write(buffer);
                            }
                            catch (IOException e) {
                                this.writeFailed(e);
                                return;
                            }
                        } while (ires != 0);
                        break;
                    }
                    this.count = count;
                    this.state = 1;
                    this.source.suspendReads();
                    this.sink.resumeWrites();
                    return;
                }
                case 1: {
                    while (true) {
                        long lres;
                        if (buffer.hasRemaining()) {
                            int ires;
                            try {
                                ires = this.sink.write(buffer);
                            }
                            catch (IOException e) {
                                this.writeFailed(e);
                                return;
                            }
                            if (ires != 0) continue;
                            return;
                        }
                        try {
                            lres = this.source.transferTo(count, buffer, (StreamSinkChannel)this.sink);
                        }
                        catch (IOException e) {
                            this.readFailed(e);
                            return;
                        }
                        if (lres == 0L) {
                            this.count = count;
                            this.state = 0;
                            this.sink.suspendWrites();
                            this.source.resumeReads();
                            return;
                        }
                        if (lres == -1L) {
                            if (count == Long.MAX_VALUE) {
                                this.done();
                                return;
                            }
                            this.readFailed(new EOFException());
                            return;
                        }
                        if (count == Long.MAX_VALUE) continue;
                        count -= lres;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFailed(IOException e) {
            try {
                this.source.suspendReads();
                this.sink.suspendWrites();
                this.writeExceptionHandler.handleException(this.sink, e);
            }
            finally {
                this.pooledBuffer.free();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFailed(IOException e) {
            try {
                this.source.suspendReads();
                this.sink.suspendWrites();
                this.readExceptionHandler.handleException(this.source, e);
            }
            finally {
                this.pooledBuffer.free();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void done() {
            try {
                ChannelListener<? super I> sourceListener = this.sourceListener;
                ChannelListener<? super O> sinkListener = this.sinkListener;
                I source = this.source;
                O sink = this.sink;
                Channels.setReadListener(source, sourceListener);
                if (sourceListener == null) {
                    source.suspendReads();
                } else {
                    source.wakeupReads();
                }
                Channels.setWriteListener(sink, sinkListener);
                if (sinkListener == null) {
                    sink.suspendWrites();
                } else {
                    sink.wakeupWrites();
                }
            }
            finally {
                this.pooledBuffer.free();
            }
        }
    }
}

