/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jboss.logging.Logger;
import org.xnio.Buffers;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.TranslatingSuspendableChannel;

final class JsseConnectedSslStreamChannel
extends TranslatingSuspendableChannel<ConnectedSslStreamChannel, ConnectedStreamChannel>
implements ConnectedSslStreamChannel {
    private static final Logger log = Logger.getLogger((String)"org.xnio.ssl");
    private static final String FQCN = JsseConnectedSslStreamChannel.class.getName();
    private final SSLEngine engine;
    private final boolean propagateClose;
    private final Pooled<ByteBuffer> receiveBuffer;
    private final Pooled<ByteBuffer> sendBuffer;
    private final Pooled<ByteBuffer> readBuffer;
    private volatile boolean tls;
    private volatile boolean writeNeedsUnwrap;
    private volatile boolean readNeedsWrap;
    private volatile boolean forcedResumeReads;
    private volatile boolean forcedResumeWrites;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsseConnectedSslStreamChannel(ConnectedStreamChannel channel, SSLEngine engine, boolean propagateClose, Pool<ByteBuffer> socketBufferPool, Pool<ByteBuffer> applicationBufferPool, boolean startTls) {
        super(channel);
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        if (engine == null) {
            throw new IllegalArgumentException("engine is null");
        }
        this.tls = !startTls;
        this.engine = engine;
        this.propagateClose = propagateClose;
        SSLSession session = engine.getSession();
        int packetBufferSize = session.getPacketBufferSize();
        boolean ok = false;
        this.receiveBuffer = socketBufferPool.allocate();
        try {
            this.receiveBuffer.getResource().flip();
            this.sendBuffer = socketBufferPool.allocate();
            try {
                if (this.receiveBuffer.getResource().capacity() < packetBufferSize || this.sendBuffer.getResource().capacity() < packetBufferSize) {
                    throw new IllegalArgumentException("Socket buffer is too small (" + this.receiveBuffer.getResource().capacity() + "). Expected capacity is " + packetBufferSize);
                }
                int applicationBufferSize = session.getApplicationBufferSize();
                this.readBuffer = applicationBufferPool.allocate();
                try {
                    if (this.readBuffer.getResource().capacity() < applicationBufferSize) {
                        throw new IllegalArgumentException("Application buffer is too small");
                    }
                    ok = true;
                }
                finally {
                    if (!ok) {
                        this.readBuffer.free();
                    }
                }
            }
            finally {
                if (!ok) {
                    this.sendBuffer.free();
                }
            }
        }
        finally {
            if (!ok) {
                this.receiveBuffer.free();
            }
        }
        this.writeNeedsUnwrap = true;
        this.readNeedsWrap = true;
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return ((ConnectedStreamChannel)this.getChannel()).getLocalAddress(type);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return ((ConnectedStreamChannel)this.getChannel()).getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return ((ConnectedStreamChannel)this.getChannel()).getPeerAddress(type);
    }

    @Override
    public SocketAddress getPeerAddress() {
        return ((ConnectedStreamChannel)this.getChannel()).getPeerAddress();
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return option == Options.SECURE ? option.cast(this.tls) : super.getOption(option);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return option == Options.SECURE || super.supportsOption(option);
    }

    @Override
    public void resumeReads() {
        if (this.forcedResumeReads) {
            this.revertForcedResumeReads();
        }
        super.resumeReads();
    }

    @Override
    public void resumeWrites() {
        if (this.forcedResumeWrites) {
            this.revertForcedResumeWrites();
        }
        super.resumeWrites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleReadable(ConnectedStreamChannel channel) {
        boolean read;
        if (this.forcedResumeReads) {
            this.revertForcedResumeReads();
        }
        do {
            super.handleReadable(channel);
            Object object = this.getReadLock();
            synchronized (object) {
                read = this.readBuffer.getResource().position() > 0 && this.readBuffer.getResource().hasRemaining() && this.isReadResumed();
            }
        } while (read);
    }

    @Override
    protected void handleWritable(ConnectedStreamChannel channel) {
        if (this.forcedResumeWrites) {
            this.revertForcedResumeWrites();
        }
        super.handleWritable(channel);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (this.tls) {
            return src.transferTo(position, count, Channels.wrapByteChannel(this));
        }
        return ((ConnectedStreamChannel)this.channel).transferFrom(src, position, count);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.tls) {
            return this.write(src, false);
        }
        return ((ConnectedStreamChannel)this.channel).write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        SSLEngineResult result;
        boolean run;
        if (!this.tls) {
            return ((ConnectedStreamChannel)this.channel).write(srcs, offset, length);
        }
        if (length < 1) {
            return 0L;
        }
        ByteBuffer buffer = this.sendBuffer.getResource();
        long bytesConsumed = 0L;
        do {
            Object object = this.getWriteLock();
            synchronized (object) {
                result = this.wrap(srcs, offset, length, buffer);
                run = this.handleWrapResult(result, false);
                bytesConsumed += (long)result.bytesConsumed();
            }
        } while (run = run && (this.handleHandshake(result, true) || !this.writeNeedsUnwrap));
        return bytesConsumed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(ByteBuffer src, boolean isCloseExpected) throws IOException {
        SSLEngineResult result;
        boolean run;
        ByteBuffer buffer = this.sendBuffer.getResource();
        int bytesConsumed = 0;
        do {
            Object object = this.getWriteLock();
            synchronized (object) {
                result = this.wrap(src, buffer);
                run = this.handleWrapResult(result, isCloseExpected);
                bytesConsumed += result.bytesConsumed();
            }
        } while (run = run && (this.handleHandshake(result, true) || !this.writeNeedsUnwrap && src.hasRemaining()));
        return bytesConsumed;
    }

    private SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dest) throws SSLException {
        log.logf(FQCN, Logger.Level.TRACE, null, "Wrapping %s into %s", (Object)srcs, (Object)dest);
        return this.engine.wrap(srcs, offset, length, dest);
    }

    private SSLEngineResult wrap(ByteBuffer src, ByteBuffer dest) throws SSLException {
        log.logf(FQCN, Logger.Level.TRACE, null, "Wrapping %s into %s", (Object)src, (Object)dest);
        return this.engine.wrap(src, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleWrapResult(SSLEngineResult result, boolean closeExpected) throws IOException {
        assert (Thread.holdsLock(this.getWriteLock()));
        assert (!Thread.holdsLock(this.getReadLock()));
        log.logf(FQCN, Logger.Level.TRACE, null, "Wrap result is %s", (Object)result);
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                break;
            }
            case BUFFER_OVERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                ByteBuffer buffer = this.sendBuffer.getResource();
                if (buffer.position() == 0) {
                    throw new IOException("SSLEngine required a bigger send buffer but our buffer was already big enough");
                }
                buffer.flip();
                try {
                    while (buffer.hasRemaining()) {
                        int res = ((ConnectedStreamChannel)this.channel).write(buffer);
                        if (res != 0) continue;
                        boolean bl = false;
                        return bl;
                    }
                    break;
                }
                finally {
                    buffer.compact();
                }
            }
            case CLOSED: {
                if (!closeExpected) {
                    throw new ClosedChannelException();
                }
            }
            case OK: {
                if (result.bytesConsumed() != 0 || result.bytesProduced() <= 0 || this.doFlush()) break;
                return false;
            }
            default: {
                throw new IllegalStateException("Unexpected wrap result status: " + (Object)((Object)result.getStatus()));
            }
        }
        return true;
    }

    private void markWriteNeedsUnwrap() {
        if (!this.writeNeedsUnwrap) {
            this.writeNeedsUnwrap = true;
            this.forceResumeReads();
        }
    }

    private void clearWriteNeedsUnwrap() {
        if (this.writeNeedsUnwrap) {
            this.writeNeedsUnwrap = false;
            this.resumeWritesIfRequested();
            if (this.forcedResumeReads) {
                this.revertForcedResumeReads();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceResumeReads() {
        Object object = this.getReadLock();
        synchronized (object) {
            if (!this.isReadResumed()) {
                this.resumeReads();
                this.forcedResumeReads = true;
            }
        }
        if (this.forcedResumeReads) {
            this.suspendWrites();
        }
    }

    private void revertForcedResumeReads() {
        this.forcedResumeReads = false;
        this.suspendReads();
        if (!this.isWriteResumed()) {
            this.resumeWrites();
        }
    }

    private void clearReadNeedsWrap() {
        if (this.readNeedsWrap) {
            this.readNeedsWrap = false;
            this.resumeReadsIfRequested();
            if (this.forcedResumeWrites) {
                this.revertForcedResumeWrites();
            }
        }
    }

    private void markReadNeedsWrap() {
        if (!this.readNeedsWrap) {
            this.readNeedsWrap = true;
            this.forceResumeWrites();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceResumeWrites() {
        Object object = this.getWriteLock();
        synchronized (object) {
            if (!this.isWriteResumed()) {
                this.resumeWrites();
                this.forcedResumeWrites = true;
            }
        }
        if (this.forcedResumeWrites) {
            this.suspendReads();
        }
    }

    private void revertForcedResumeWrites() {
        this.forcedResumeWrites = false;
        this.suspendWrites();
        if (!this.isReadResumed()) {
            this.resumeReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleHandshake(SSLEngineResult result, boolean write) throws IOException {
        assert (!Thread.holdsLock(this.getReadLock()));
        if (this.readNeedsWrap && this.writeNeedsUnwrap) {
            this.writeNeedsUnwrap = false;
            this.readNeedsWrap = false;
        }
        boolean newResult = false;
        block13: while (true) {
            switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[result.getHandshakeStatus().ordinal()]) {
                case 1: {
                    this.clearReadNeedsWrap();
                    this.clearWriteNeedsUnwrap();
                    return true;
                }
                case 2: {
                    this.clearReadNeedsWrap();
                    this.clearWriteNeedsUnwrap();
                    return false;
                }
                case 3: {
                    this.clearWriteNeedsUnwrap();
                    if (write) {
                        return true;
                    }
                    ByteBuffer buffer = this.sendBuffer.getResource();
                    boolean flushed = true;
                    Object object = this.getWriteLock();
                    synchronized (object) {
                        flushed = this.doFlush();
                        if (flushed) {
                            result = this.wrap(Buffers.EMPTY_BYTE_BUFFER, buffer);
                            if (!this.handleWrapResult(result, true)) {
                                this.markReadNeedsWrap();
                                this.resumeWritesIfRequestedAndSuspendReads();
                                return false;
                            }
                            newResult = true;
                            continue block13;
                        }
                    }
                    if (flushed) {
                        return !this.readNeedsWrap;
                    }
                    this.markReadNeedsWrap();
                    return false;
                }
                case 4: {
                    this.clearReadNeedsWrap();
                    this.markWriteNeedsUnwrap();
                    if (!write) {
                        return newResult;
                    }
                    ByteBuffer buffer = this.receiveBuffer.getResource();
                    Object object = this.getReadLock();
                    synchronized (object) {
                        ByteBuffer unwrappedBuffer = this.readBuffer.getResource();
                        result = this.unwrap(buffer, unwrappedBuffer);
                        if (this.handleUnwrapResult(result) >= 0) {
                            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || result.bytesConsumed() > 0) {
                                this.clearWriteNeedsUnwrap();
                                continue block13;
                            }
                            this.markWriteNeedsUnwrap();
                            this.resumeReadsIfRequestedAndSuspendWrites();
                            return false;
                        }
                    }
                }
                continue block13;
                case 5: {
                    Runnable task;
                    while ((task = this.engine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    return true;
                }
            }
            break;
        }
        throw new IOException("Unexpected handshake status: " + (Object)((Object)result.getHandshakeStatus()));
    }

    private SSLEngineResult unwrap(ByteBuffer buffer, ByteBuffer unwrappedBuffer) throws IOException, SSLException {
        if (!buffer.hasRemaining()) {
            buffer.compact();
            ((ConnectedStreamChannel)this.channel).read(buffer);
            buffer.flip();
        }
        log.logf(FQCN, Logger.Level.TRACE, null, "Unwrapping %s into %s", (Object)buffer, (Object)unwrappedBuffer);
        return this.engine.unwrap(buffer, unwrappedBuffer);
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        if (this.tls) {
            return target.transferFrom(Channels.wrapByteChannel(this), position, count);
        }
        return ((ConnectedStreamChannel)this.channel).transferTo(position, count, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.tls) {
            return (int)this.read(new ByteBuffer[]{dst}, 0, 1);
        }
        return ((ConnectedStreamChannel)this.channel).read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        SSLEngineResult result;
        if (!this.tls) {
            return ((ConnectedStreamChannel)this.channel).read(dsts, offset, length);
        }
        if (dsts.length == 0 || length == 0) {
            return 0L;
        }
        ByteBuffer buffer = this.receiveBuffer.getResource();
        ByteBuffer unwrappedBuffer = this.readBuffer.getResource();
        long total = 0L;
        Object object = this.getReadLock();
        synchronized (object) {
            if (unwrappedBuffer.position() > 0 && unwrappedBuffer.hasRemaining()) {
                total += (long)this.copyUnwrappedData(dsts, offset, length, unwrappedBuffer);
            }
        }
        int res = 0;
        do {
            Object object2 = this.getReadLock();
            synchronized (object2) {
                if (!Buffers.hasRemaining(dsts, offset, length)) {
                    return total;
                }
                result = this.unwrap(buffer, unwrappedBuffer);
                res = this.handleUnwrapResult(result);
                total += (long)this.copyUnwrappedData(dsts, offset, length, unwrappedBuffer);
            }
        } while (this.handleHandshake(result, false) || res > 0);
        if (res == -1) {
            return total == 0L ? -1L : total;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyUnwrappedData(ByteBuffer[] dsts, int offset, int length, ByteBuffer unwrappedBuffer) {
        assert (Thread.holdsLock(this.getReadLock()));
        unwrappedBuffer.flip();
        try {
            int n = Buffers.copy(dsts, offset, length, unwrappedBuffer);
            return n;
        }
        finally {
            unwrappedBuffer.compact();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleUnwrapResult(SSLEngineResult result) throws IOException {
        assert (Thread.holdsLock(this.getReadLock()));
        log.logf(FQCN, Logger.Level.TRACE, null, "Unwrap result is %s", (Object)result);
        switch (result.getStatus()) {
            case BUFFER_OVERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                return 0;
            }
            case BUFFER_UNDERFLOW: {
                assert (result.bytesConsumed() == 0);
                assert (result.bytesProduced() == 0);
                ByteBuffer buffer = this.receiveBuffer.getResource();
                Object object = this.getReadLock();
                synchronized (object) {
                    int n;
                    buffer.compact();
                    try {
                        n = ((ConnectedStreamChannel)this.channel).read(buffer);
                        buffer.flip();
                    }
                    catch (Throwable throwable) {
                        buffer.flip();
                        throw throwable;
                    }
                    return n;
                }
            }
            case CLOSED: {
                if (result.bytesConsumed() > 0) {
                    return result.bytesConsumed();
                }
                return -1;
            }
            case OK: {
                return result.bytesConsumed();
            }
        }
        throw new IOException("Unexpected unwrap result status: " + (Object)((Object)result.getStatus()));
    }

    @Override
    public void startHandshake() throws IOException {
        this.tls = true;
        this.engine.beginHandshake();
    }

    @Override
    public SSLSession getSslSession() {
        return this.tls ? this.engine.getSession() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TranslatingSuspendableChannel.Readiness isReadable() {
        Object object = this.getReadLock();
        synchronized (object) {
            return this.readNeedsWrap ? (this.writeNeedsUnwrap ? TranslatingSuspendableChannel.Readiness.ALWAYS : TranslatingSuspendableChannel.Readiness.NEVER) : TranslatingSuspendableChannel.Readiness.OKAY;
        }
    }

    @Override
    protected Object getReadLock() {
        return this.receiveBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TranslatingSuspendableChannel.Readiness isWritable() {
        Object object = this.getWriteLock();
        synchronized (object) {
            return this.writeNeedsUnwrap ? (this.readNeedsWrap ? TranslatingSuspendableChannel.Readiness.ALWAYS : TranslatingSuspendableChannel.Readiness.NEVER) : TranslatingSuspendableChannel.Readiness.OKAY;
        }
    }

    @Override
    protected Object getWriteLock() {
        return this.sendBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownReads() throws IOException {
        if (!this.tls) {
            ((ConnectedStreamChannel)this.channel).shutdownReads();
            return;
        }
        if (this.propagateClose) {
            super.shutdownReads();
        }
        Object object = this.getReadLock();
        synchronized (object) {
            this.engine.closeInbound();
        }
        this.write(Buffers.EMPTY_BYTE_BUFFER, true);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdownWrites() throws IOException {
        if (!this.tls) {
            return ((ConnectedStreamChannel)this.channel).shutdownWrites();
        }
        Object object = this.getWriteLock();
        synchronized (object) {
            if (this.doFlush()) {
                SSLEngineResult result;
                this.engine.closeOutbound();
                ByteBuffer buffer = this.sendBuffer.getResource();
                do {
                    result = this.wrap(Buffers.EMPTY_BYTE_BUFFER, buffer);
                    this.handleWrapResult(result, true);
                } while (this.handleHandshake(result, true));
                result = this.wrap(Buffers.EMPTY_BYTE_BUFFER, buffer);
                this.handleWrapResult(result, true);
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    return false;
                }
                if (this.doFlush() && this.engine.isOutboundDone() && (!this.propagateClose || super.shutdownWrites())) {
                    this.suspendWrites();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        if (!this.tls) {
            return ((ConnectedStreamChannel)this.channel).flush();
        }
        Object object = this.getWriteLock();
        synchronized (object) {
            return this.doFlush();
        }
    }

    @Override
    public XnioWorker getWorker() {
        return ((ConnectedStreamChannel)this.channel).getWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush() throws IOException {
        assert (Thread.holdsLock(this.getWriteLock()));
        assert (!Thread.holdsLock(this.getReadLock()));
        ByteBuffer buffer = this.sendBuffer.getResource();
        buffer.flip();
        try {
            while (buffer.hasRemaining()) {
                int res = ((ConnectedStreamChannel)this.channel).write(buffer);
                if (res != 0) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            buffer.compact();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long transfer(long count, ByteBuffer throughBuffer, StreamSourceChannel source, StreamSinkChannel sink) throws IOException {
        long total = 0L;
        throughBuffer.clear();
        while (total < count) {
            long res;
            if (count - total < (long)throughBuffer.remaining()) {
                throughBuffer.limit((int)(count - total));
            }
            try {
                res = source.read(throughBuffer);
                if (res <= 0L) {
                    long l = total == 0L ? res : total;
                    return l;
                }
            }
            finally {
                throughBuffer.flip();
            }
            res = sink.write(throughBuffer);
            if (res == 0L) {
                return total;
            }
            throughBuffer.compact();
        }
        return total;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return JsseConnectedSslStreamChannel.transfer(count, throughBuffer, this, target);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return JsseConnectedSslStreamChannel.transfer(count, throughBuffer, source, this);
    }
}

