/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.streams;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.xnio.Pooled;

public class BufferPipeOutputStream
extends OutputStream {
    private final Object lock = new Object();
    private Pooled<ByteBuffer> buffer;
    private boolean eof;
    private final BufferWriter bufferWriterTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferPipeOutputStream(BufferWriter bufferWriterTask) throws IOException {
        this.bufferWriterTask = bufferWriterTask;
        Object object = this.lock;
        synchronized (object) {
            this.buffer = bufferWriterTask.getBuffer();
        }
    }

    private static IOException closed() {
        return new IOException("Stream is closed");
    }

    private void checkClosed() throws IOException {
        if (this.eof) {
            throw BufferPipeOutputStream.closed();
        }
    }

    private Pooled<ByteBuffer> getBuffer() throws IOException {
        Pooled<ByteBuffer> buffer = this.buffer;
        if (buffer != null && buffer.getResource().hasRemaining()) {
            return buffer;
        }
        if (buffer != null) {
            this.send();
        }
        this.buffer = this.bufferWriterTask.getBuffer();
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        BufferPipeOutputStream bufferPipeOutputStream = this;
        synchronized (bufferPipeOutputStream) {
            this.checkClosed();
            this.getBuffer().getResource().put((byte)b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        BufferPipeOutputStream bufferPipeOutputStream = this;
        synchronized (bufferPipeOutputStream) {
            this.checkClosed();
            while (len > 0) {
                ByteBuffer buffer = this.getBuffer().getResource();
                int cnt = Math.min(len, buffer.remaining());
                buffer.put(b, off, cnt);
                len -= cnt;
                off += cnt;
            }
        }
    }

    private void send() throws IOException {
        Pooled<ByteBuffer> pooledBuffer = this.buffer;
        ByteBuffer buffer = pooledBuffer.getResource();
        this.buffer = null;
        boolean eof = this.eof;
        if (buffer != null && buffer.position() > 0) {
            buffer.flip();
            this.send(pooledBuffer, eof);
        } else if (eof) {
            Pooled<ByteBuffer> pooledBuffer1 = this.getBuffer();
            ByteBuffer buffer1 = pooledBuffer1.getResource();
            buffer1.flip();
            this.send(pooledBuffer1, eof);
        }
    }

    private void send(Pooled<ByteBuffer> buffer, boolean eof) throws IOException {
        try {
            this.bufferWriterTask.accept(buffer, eof);
        }
        catch (IOException e) {
            this.eof = true;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        BufferPipeOutputStream bufferPipeOutputStream = this;
        synchronized (bufferPipeOutputStream) {
            this.send();
            try {
                this.bufferWriterTask.flush();
            }
            catch (IOException e) {
                this.eof = true;
                this.buffer = null;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        BufferPipeOutputStream bufferPipeOutputStream = this;
        synchronized (bufferPipeOutputStream) {
            if (this.eof) {
                return;
            }
            this.eof = true;
            this.flush();
        }
    }

    public static interface BufferWriter
    extends Flushable {
        public Pooled<ByteBuffer> getBuffer() throws IOException;

        public void accept(Pooled<ByteBuffer> var1, boolean var2) throws IOException;

        @Override
        public void flush() throws IOException;
    }
}

