/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.ReadChannelThread;
import org.xnio.WriteChannelThread;
import org.xnio.channels.SuspendableChannel;

public abstract class TranslatingSuspendableChannel<C extends SuspendableChannel, W extends SuspendableChannel>
implements SuspendableChannel {
    protected final W channel;
    private final ChannelListener.SimpleSetter<C> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<C> closeSetter = new ChannelListener.SimpleSetter();
    private boolean readsRequested;
    private boolean writesRequested;
    private final Runnable readListenerCommand = new Runnable(){

        @Override
        public void run() {
            ChannelListeners.invokeChannelListener(TranslatingSuspendableChannel.this.channel, TranslatingSuspendableChannel.this.readListener);
        }
    };
    private final ChannelListener<W> readListener = new ChannelListener<W>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(W channel) {
            ChannelListener listener = TranslatingSuspendableChannel.this.readSetter.get();
            if (listener == null) {
                Object object = TranslatingSuspendableChannel.this.getReadLock();
                synchronized (object) {
                    channel.suspendReads();
                    TranslatingSuspendableChannel.this.readsRequested = false;
                }
                return;
            }
            ChannelListeners.invokeChannelListener(TranslatingSuspendableChannel.this, listener);
            Object object = TranslatingSuspendableChannel.this.getReadLock();
            synchronized (object) {
                if (TranslatingSuspendableChannel.this.readsRequested && TranslatingSuspendableChannel.this.isReadable()) {
                    channel.getReadThread().execute(TranslatingSuspendableChannel.this.readListenerCommand);
                }
            }
        }
    };
    private final Runnable writeListenerCommand = new Runnable(){

        @Override
        public void run() {
            ChannelListeners.invokeChannelListener(TranslatingSuspendableChannel.this.channel, TranslatingSuspendableChannel.this.writeListener);
        }
    };
    private final ChannelListener<W> writeListener = new ChannelListener<W>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(W channel) {
            ChannelListener listener = TranslatingSuspendableChannel.this.writeSetter.get();
            if (listener == null) {
                Object object = TranslatingSuspendableChannel.this.getWriteLock();
                synchronized (object) {
                    channel.suspendWrites();
                    TranslatingSuspendableChannel.this.writesRequested = false;
                }
                return;
            }
            ChannelListeners.invokeChannelListener(TranslatingSuspendableChannel.this, listener);
            Object object = TranslatingSuspendableChannel.this.getReadLock();
            synchronized (object) {
                if (TranslatingSuspendableChannel.this.writesRequested && TranslatingSuspendableChannel.this.isReadable()) {
                    channel.getWriteThread().execute(TranslatingSuspendableChannel.this.writeListenerCommand);
                }
            }
        }
    };

    protected TranslatingSuspendableChannel(W channel) {
        this.channel = channel;
        ChannelListener.Setter<? extends SuspendableChannel> readSetter = channel.getReadSetter();
        readSetter.set(this.readListener);
        ChannelListener.Setter<? extends SuspendableChannel> writeSetter = channel.getWriteSetter();
        writeSetter.set(this.writeListener);
    }

    public ChannelListener.Setter<C> getCloseSetter() {
        return this.closeSetter;
    }

    public ChannelListener.Setter<C> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<C> getWriteSetter() {
        return this.writeSetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendReads() {
        Object object = this.getReadLock();
        synchronized (object) {
            this.readsRequested = false;
            this.channel.suspendReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeReads() {
        Object object = this.getReadLock();
        synchronized (object) {
            this.readsRequested = true;
            this.channel.resumeReads();
            if (this.isReadable()) {
                this.getReadThread().execute(this.readListenerCommand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendWrites() {
        Object object = this.getWriteLock();
        synchronized (object) {
            this.writesRequested = false;
            this.channel.suspendWrites();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeWrites() {
        Object object = this.getWriteLock();
        synchronized (object) {
            this.writesRequested = true;
            this.channel.resumeWrites();
            if (this.isWritable()) {
                this.getWriteThread().execute(this.writeListenerCommand);
            }
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.channel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.channel.setOption(option, value);
    }

    @Override
    public void setReadThread(ReadChannelThread thread) throws IllegalArgumentException {
        this.channel.setReadThread(thread);
    }

    @Override
    public ReadChannelThread getReadThread() {
        return this.channel.getReadThread();
    }

    @Override
    public void setWriteThread(WriteChannelThread thread) throws IllegalArgumentException {
        this.channel.setWriteThread(thread);
    }

    @Override
    public WriteChannelThread getWriteThread() {
        return this.channel.getWriteThread();
    }

    @Override
    public boolean flush() throws IOException {
        return this.channel.flush();
    }

    @Override
    public void shutdownReads() throws IOException {
        this.channel.shutdownReads();
    }

    @Override
    public boolean shutdownWrites() throws IOException {
        return this.channel.shutdownWrites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable() throws IOException {
        Object object = this.getReadLock();
        synchronized (object) {
            if (this.isReadable()) {
                return;
            }
        }
        this.channel.awaitReadable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        Object object = this.getReadLock();
        synchronized (object) {
            if (this.isReadable()) {
                return;
            }
        }
        this.channel.awaitReadable(time, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable() throws IOException {
        Object object = this.getWriteLock();
        synchronized (object) {
            if (this.isWritable()) {
                return;
            }
        }
        this.channel.awaitWritable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        Object object = this.getWriteLock();
        synchronized (object) {
            if (this.isWritable()) {
                return;
            }
        }
        this.channel.awaitWritable(time, timeUnit);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    protected abstract boolean isReadable();

    protected abstract Object getReadLock();

    protected abstract boolean isWritable();

    protected abstract Object getWriteLock();
}

