/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.xnio.Buffers;
import org.xnio.Pooled;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.TranslatingSuspendableChannel;

public class FramedMessageChannel
extends TranslatingSuspendableChannel<ConnectedMessageChannel, ConnectedStreamChannel>
implements ConnectedMessageChannel {
    private final Pooled<ByteBuffer> receiveBuffer;
    private final Pooled<ByteBuffer> transmitBuffer;

    public FramedMessageChannel(ConnectedStreamChannel channel, ByteBuffer receiveBuffer, ByteBuffer transmitBuffer) {
        super(channel);
        this.receiveBuffer = Buffers.pooledWrapper(receiveBuffer);
        this.transmitBuffer = Buffers.pooledWrapper(transmitBuffer);
    }

    public FramedMessageChannel(ConnectedStreamChannel channel, Pooled<ByteBuffer> receiveBuffer, Pooled<ByteBuffer> transmitBuffer) {
        super(channel);
        this.receiveBuffer = receiveBuffer;
        this.transmitBuffer = transmitBuffer;
    }

    @Override
    protected boolean isReadable() {
        ByteBuffer buffer = this.receiveBuffer.getResource();
        int remaining = buffer.remaining();
        return remaining >= 4 && remaining >= buffer.getInt(0);
    }

    @Override
    protected Object getReadLock() {
        return this.receiveBuffer;
    }

    @Override
    protected boolean isWritable() {
        return this.receiveBuffer.getResource().position() == 0;
    }

    @Override
    protected Object getWriteLock() {
        return this.transmitBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int receive(ByteBuffer buffer) throws IOException {
        ByteBuffer receiveBuffer;
        ByteBuffer byteBuffer = receiveBuffer = this.receiveBuffer.getResource();
        synchronized (byteBuffer) {
            int n;
            int res;
            ConnectedStreamChannel channel = (ConnectedStreamChannel)this.channel;
            while ((res = channel.read(receiveBuffer)) > 0) {
            }
            if (receiveBuffer.remaining() < 4) {
                return res;
            }
            int length = receiveBuffer.getInt();
            if (receiveBuffer.remaining() < length) {
                Buffers.unget(receiveBuffer, 4);
                return res;
            }
            try {
                n = Buffers.copy(buffer, Buffers.slice(receiveBuffer, length));
            }
            catch (Throwable throwable) {
                if (receiveBuffer.remaining() == 0) {
                    receiveBuffer.clear();
                }
                throw throwable;
            }
            if (receiveBuffer.remaining() == 0) {
                receiveBuffer.clear();
            }
            return n;
        }
    }

    @Override
    public long receive(ByteBuffer[] buffers) throws IOException {
        return this.receive(buffers, 0, buffers.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long receive(ByteBuffer[] buffers, int offs, int len) throws IOException {
        ByteBuffer receiveBuffer;
        ByteBuffer byteBuffer = receiveBuffer = this.receiveBuffer.getResource();
        synchronized (byteBuffer) {
            long l;
            int res;
            while ((res = ((ConnectedStreamChannel)this.channel).read(receiveBuffer)) > 0) {
            }
            if (receiveBuffer.remaining() < 4) {
                return res;
            }
            int length = receiveBuffer.getInt();
            if (receiveBuffer.remaining() < length) {
                Buffers.unget(receiveBuffer, 4);
                return res;
            }
            try {
                l = Buffers.copy(buffers, offs, len, Buffers.slice(receiveBuffer, length));
            }
            catch (Throwable throwable) {
                if (receiveBuffer.remaining() == 0) {
                    receiveBuffer.clear();
                }
                throw throwable;
            }
            if (receiveBuffer.remaining() == 0) {
                receiveBuffer.clear();
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownReads() throws IOException {
        ByteBuffer receiveBuffer;
        ByteBuffer byteBuffer = receiveBuffer = this.receiveBuffer.getResource();
        synchronized (byteBuffer) {
            receiveBuffer.clear();
        }
        super.shutdownReads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(ByteBuffer buffer) throws IOException {
        ByteBuffer transmitBuffer;
        ByteBuffer byteBuffer = transmitBuffer = this.transmitBuffer.getResource();
        synchronized (byteBuffer) {
            int remaining = buffer.remaining();
            if (transmitBuffer.remaining() < 4 + remaining) {
                return false;
            }
            transmitBuffer.putInt(remaining);
            transmitBuffer.put(buffer);
            this.doFlush();
            return true;
        }
    }

    @Override
    public boolean send(ByteBuffer[] buffers) throws IOException {
        return this.send(buffers, 0, buffers.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(ByteBuffer[] buffers, int offs, int len) throws IOException {
        ByteBuffer transmitBuffer;
        ByteBuffer byteBuffer = transmitBuffer = this.transmitBuffer.getResource();
        synchronized (byteBuffer) {
            long remaining = Buffers.remaining(buffers);
            if ((long)transmitBuffer.remaining() < 4L + remaining) {
                return false;
            }
            transmitBuffer.putInt((int)remaining);
            Buffers.copy(transmitBuffer, buffers, offs, len);
            this.doFlush();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdownWrites() throws IOException {
        Pooled<ByteBuffer> pooled = this.transmitBuffer;
        synchronized (pooled) {
            return this.doFlush() && super.shutdownWrites();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        Pooled<ByteBuffer> pooled = this.transmitBuffer;
        synchronized (pooled) {
            return !this.doFlush();
        }
    }

    private boolean doFlush() throws IOException {
        ByteBuffer buffer = this.transmitBuffer.getResource();
        while (buffer.hasRemaining()) {
            int res = ((ConnectedStreamChannel)this.channel).write(buffer);
            if (res != 0) continue;
            return true;
        }
        buffer.clear();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Pooled<ByteBuffer> pooled = this.transmitBuffer;
        synchronized (pooled) {
            this.transmitBuffer.getResource().clear();
            this.transmitBuffer.free();
        }
        pooled = this.receiveBuffer;
        synchronized (pooled) {
            this.receiveBuffer.getResource().clear();
            this.receiveBuffer.free();
        }
        super.close();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return ((ConnectedStreamChannel)this.channel).getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return ((ConnectedStreamChannel)this.channel).getPeerAddress(type);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return ((ConnectedStreamChannel)this.channel).getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return ((ConnectedStreamChannel)this.channel).getLocalAddress(type);
    }

    public ConnectedStreamChannel getChannel() {
        return (ConnectedStreamChannel)this.channel;
    }
}

