/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.logging.Logger;
import org.xnio.AcceptingSslStreamChannel;
import org.xnio.Acceptor;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ChannelSource;
import org.xnio.ConnectedSslStreamChannelImpl;
import org.xnio.ConnectionChannelThread;
import org.xnio.Connector;
import org.xnio.FileAccess;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.LocalSocketAddress;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ReadChannelThread;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.Version;
import org.xnio.WriteChannelThread;
import org.xnio.XnioFileChannel;
import org.xnio.XnioProvider;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.SimpleAcceptingChannel;
import org.xnio.channels.StreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.UnsupportedOptionException;

public abstract class Xnio {
    private static final InetSocketAddress ANY_INET_ADDRESS = new InetSocketAddress(0);
    private static final LocalSocketAddress ANY_LOCAL_ADDRESS = new LocalSocketAddress("");
    private static final EnumMap<FileAccess, OptionMap> FILE_ACCESS_OPTION_MAPS;
    private final String name;

    protected Xnio(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    public static Xnio getInstance(ClassLoader classLoader) {
        return Xnio.doGetInstance(null, ServiceLoader.load(XnioProvider.class, classLoader));
    }

    public static Xnio getInstance() {
        return Xnio.doGetInstance(null, ServiceLoader.load(XnioProvider.class));
    }

    public static Xnio getInstance(String provider, ClassLoader classLoader) {
        return Xnio.doGetInstance(provider, ServiceLoader.load(XnioProvider.class, classLoader));
    }

    public static Xnio getInstance(String provider) {
        return Xnio.doGetInstance(provider, ServiceLoader.load(XnioProvider.class));
    }

    private static Xnio doGetInstance(String provider, ServiceLoader<XnioProvider> serviceLoader) {
        for (XnioProvider xnioProvider : serviceLoader) {
            if (provider != null && !provider.equals(xnioProvider.getName())) continue;
            return xnioProvider.getInstance();
        }
        throw new IllegalArgumentException("No matching XNIO provider found");
    }

    static ConnectedSslStreamChannel createSslConnectedStreamChannel(SSLContext sslContext, ConnectedStreamChannel tcpChannel, Executor executor, OptionMap optionMap, boolean server) {
        Sequence<String> protocols;
        SslClientAuthMode clientAuthMode;
        InetSocketAddress peerAddress = tcpChannel.getPeerAddress(InetSocketAddress.class);
        SSLEngine engine = sslContext.createSSLEngine(peerAddress.getHostName(), peerAddress.getPort());
        boolean clientMode = optionMap.get(Options.SSL_USE_CLIENT_MODE, !server);
        engine.setUseClientMode(clientMode);
        if (!clientMode && (clientAuthMode = optionMap.get(Options.SSL_CLIENT_AUTH_MODE)) != null) {
            switch (clientAuthMode) {
                case NOT_REQUESTED: {
                    engine.setNeedClientAuth(false);
                    engine.setWantClientAuth(false);
                    break;
                }
                case REQUESTED: {
                    engine.setWantClientAuth(true);
                    break;
                }
                case REQUIRED: {
                    engine.setNeedClientAuth(true);
                }
            }
        }
        engine.setEnableSessionCreation(optionMap.get(Options.SSL_ENABLE_SESSION_CREATION, true));
        Sequence<String> cipherSuites = optionMap.get(Options.SSL_ENABLED_CIPHER_SUITES);
        if (cipherSuites != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedCipherSuites()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String name : cipherSuites) {
                if (!supported.contains(name)) continue;
                finalList.add(name);
            }
            engine.setEnabledCipherSuites(finalList.toArray(new String[finalList.size()]));
        }
        if ((protocols = optionMap.get(Options.SSL_ENABLED_PROTOCOLS)) != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedProtocols()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String name : protocols) {
                if (!supported.contains(name)) continue;
                finalList.add(name);
            }
            engine.setEnabledProtocols(finalList.toArray(new String[finalList.size()]));
        }
        return new ConnectedSslStreamChannelImpl(tcpChannel, engine, executor);
    }

    private static SSLContext getSSLContext(OptionMap optionMap) throws NoSuchAlgorithmException, NoSuchProviderException {
        String provider = optionMap.get(Options.SSL_PROVIDER);
        String protocol = optionMap.get(Options.SSL_PROTOCOL);
        SSLContext sslContext = protocol == null ? SSLContext.getDefault() : (provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider));
        return sslContext;
    }

    IoFuture<ConnectedSslStreamChannel> connectSsl(InetSocketAddress bindAddress, InetSocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, final SSLContext sslContext, final Executor executor, final ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, final OptionMap optionMap) {
        final FutureResult futureResult = new FutureResult(IoUtils.directExecutor());
        this.connectStream(bindAddress, destination, thread, readThread, writeThread, (ChannelListener<? super ConnectedStreamChannel>)new ChannelListener<ConnectedStreamChannel>(){

            @Override
            public void handleEvent(ConnectedStreamChannel tcpChannel) {
                ConnectedSslStreamChannel channel = Xnio.createSslConnectedStreamChannel(sslContext, tcpChannel, executor, optionMap, false);
                futureResult.setResult(channel);
                ChannelListeners.invokeChannelListener(channel, openListener);
            }
        }, bindListener, optionMap).addNotifier(new IoFuture.HandlingNotifier<ConnectedStreamChannel, FutureResult<ConnectedSslStreamChannel>>(){

            @Override
            public void handleCancelled(FutureResult<ConnectedSslStreamChannel> result) {
                result.setCancelled();
            }

            @Override
            public void handleFailed(IOException exception, FutureResult<ConnectedSslStreamChannel> result) {
                result.setException(exception);
            }
        }, futureResult);
        return futureResult.getIoFuture();
    }

    public IoFuture<ConnectedSslStreamChannel> connectSsl(InetSocketAddress bindAddress, InetSocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, Executor executor, ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.connectSsl(bindAddress, destination, thread, readThread, writeThread, Xnio.getSSLContext(optionMap), executor, openListener, bindListener, optionMap);
    }

    public IoFuture<ConnectedSslStreamChannel> connectSsl(InetSocketAddress bindAddress, InetSocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedSslStreamChannel> openListener, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.connectSsl(bindAddress, destination, thread, readThread, writeThread, Xnio.getSSLContext(optionMap), IoUtils.directExecutor(), openListener, bindListener, optionMap);
    }

    public IoFuture<ConnectedSslStreamChannel> connectSsl(InetSocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.connectSsl(new InetSocketAddress(0), destination, thread, readThread, writeThread, Xnio.getSSLContext(optionMap), IoUtils.directExecutor(), openListener, bindListener, optionMap);
    }

    public IoFuture<ConnectedSslStreamChannel> connectSsl(InetSocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedSslStreamChannel> openListener, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.connectSsl(new InetSocketAddress(0), destination, thread, readThread, writeThread, Xnio.getSSLContext(optionMap), IoUtils.directExecutor(), openListener, null, optionMap);
    }

    public AcceptingChannel<ConnectedSslStreamChannel> createSslTcpServer(InetSocketAddress bindAddress, ConnectionChannelThread thread, Executor executor, ChannelListener<? super AcceptingChannel<ConnectedSslStreamChannel>> acceptListener, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException, IOException {
        SSLContext sslContext = Xnio.getSSLContext(optionMap);
        AcceptingSslStreamChannel server = new AcceptingSslStreamChannel(sslContext, this.createStreamServer(bindAddress, thread, null, optionMap), executor, optionMap);
        if (acceptListener != null) {
            server.getAcceptSetter().set(acceptListener);
        }
        return server;
    }

    public AcceptingChannel<ConnectedSslStreamChannel> createSslTcpServer(InetSocketAddress bindAddress, ConnectionChannelThread thread, ChannelListener<? super AcceptingChannel<ConnectedSslStreamChannel>> acceptListener, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException, IOException {
        return this.createSslTcpServer(bindAddress, thread, IoUtils.directExecutor(), acceptListener, optionMap);
    }

    public Connector<ConnectedSslStreamChannel> createSslTcpConnector(final InetSocketAddress src, final ConnectionChannelThread thread, final ReadChannelThread readThread, final WriteChannelThread writeThread, final Executor executor, final OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        final SSLContext sslContext = Xnio.getSSLContext(optionMap);
        return new Connector<ConnectedSslStreamChannel>(){

            @Override
            public IoFuture<ConnectedSslStreamChannel> connectTo(SocketAddress destination, ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener) {
                return Xnio.this.connectSsl(src, (InetSocketAddress)destination, thread, readThread, writeThread, sslContext, executor, openListener, bindListener, optionMap);
            }
        };
    }

    public Connector<ConnectedSslStreamChannel> createSslTcpConnector(InetSocketAddress src, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.createSslTcpConnector(src, thread, readThread, writeThread, IoUtils.directExecutor(), optionMap);
    }

    public Connector<ConnectedSslStreamChannel> createSslTcpConnector(ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.createSslTcpConnector(ANY_INET_ADDRESS, thread, readThread, writeThread, IoUtils.directExecutor(), optionMap);
    }

    public AcceptingChannel<? extends ConnectedStreamChannel> createStreamServer(SocketAddress bindAddress, ConnectionChannelThread thread, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (bindAddress instanceof InetSocketAddress) {
            return this.createTcpServer((InetSocketAddress)bindAddress, thread, acceptListener, optionMap);
        }
        if (bindAddress instanceof LocalSocketAddress) {
            return this.createLocalStreamServer((LocalSocketAddress)bindAddress, thread, acceptListener, optionMap);
        }
        throw new UnsupportedOperationException("Unsupported socket address " + bindAddress.getClass());
    }

    protected AcceptingChannel<? extends ConnectedStreamChannel> createTcpServer(InetSocketAddress bindAddress, ConnectionChannelThread thread, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("TCP server");
    }

    protected AcceptingChannel<? extends ConnectedStreamChannel> createLocalStreamServer(LocalSocketAddress bindAddress, ConnectionChannelThread thread, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("UNIX stream server");
    }

    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectTcp(ANY_INET_ADDRESS, (InetSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectStreamLocal(ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to server with socket address " + destination.getClass());
    }

    public IoFuture<ConnectedStreamChannel> connectStream(SocketAddress bindAddress, SocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (bindAddress.getClass() != destination.getClass()) {
            throw new IllegalArgumentException("Bind address " + bindAddress.getClass() + " is not the same type as destination address " + destination.getClass());
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectTcp((InetSocketAddress)bindAddress, (InetSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectStreamLocal((LocalSocketAddress)bindAddress, (LocalSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to stream server with socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedStreamChannel> connectTcp(InetSocketAddress bindAddress, InetSocketAddress destinationAddress, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to TCP server");
    }

    protected IoFuture<ConnectedStreamChannel> connectStreamLocal(LocalSocketAddress bindAddress, LocalSocketAddress destinationAddress, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to local stream server");
    }

    public Connector<ConnectedStreamChannel> createStreamConnector(final SocketAddress bindAddress, final ConnectionChannelThread thread, final ReadChannelThread readThread, final WriteChannelThread writeThread, final OptionMap optionMap) {
        return new Connector<ConnectedStreamChannel>(){

            @Override
            public IoFuture<ConnectedStreamChannel> connectTo(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener) {
                return Xnio.this.connectStream(bindAddress, destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
            }
        };
    }

    public IoFuture<ConnectedStreamChannel> acceptStream(SocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.acceptTcp((InetSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptStreamLocal((LocalSocketAddress)destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Accept a connection to socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedStreamChannel> acceptStreamLocal(LocalSocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOptionException("Accept a local stream connection");
    }

    protected IoFuture<ConnectedStreamChannel> acceptTcp(InetSocketAddress destination, ConnectionChannelThread thread, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOptionException("Accept a TCP connection");
    }

    public Acceptor<ConnectedStreamChannel> createStreamAcceptor(final ConnectionChannelThread thread, final ReadChannelThread readThread, final WriteChannelThread writeThread, final OptionMap optionMap) {
        return new Acceptor<ConnectedStreamChannel>(){

            @Override
            public IoFuture<ConnectedStreamChannel> acceptTo(SocketAddress destination, ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener) {
                return Xnio.this.acceptStream(destination, thread, readThread, writeThread, openListener, bindListener, optionMap);
            }
        };
    }

    public IoFuture<ConnectedMessageChannel> connectDatagram(SocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectUdp(ANY_INET_ADDRESS, (InetSocketAddress)destination, thread, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectDatagramLocal(ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, thread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to datagram server with socket address " + destination.getClass());
    }

    public IoFuture<ConnectedMessageChannel> connectDatagram(SocketAddress bindAddress, SocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (bindAddress == null) {
            throw new IllegalArgumentException("bindAddress is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (bindAddress.getClass() != destination.getClass()) {
            throw new IllegalArgumentException("Bind address " + bindAddress.getClass() + " is not the same type as destination address " + destination.getClass());
        }
        if (destination instanceof InetSocketAddress) {
            return this.connectUdp((InetSocketAddress)bindAddress, (InetSocketAddress)destination, thread, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.connectDatagramLocal((LocalSocketAddress)bindAddress, (LocalSocketAddress)destination, thread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Connect to server with socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedMessageChannel> connectUdp(InetSocketAddress bindAddress, InetSocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to UDP server");
    }

    protected IoFuture<ConnectedMessageChannel> connectDatagramLocal(LocalSocketAddress bindAddress, LocalSocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOperationException("Connect to local datagram server");
    }

    public Connector<ConnectedMessageChannel> createDatagramConnector(final SocketAddress bindAddress, final ConnectionChannelThread thread, final OptionMap optionMap) {
        return new Connector<ConnectedMessageChannel>(){

            @Override
            public IoFuture<ConnectedMessageChannel> connectTo(SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener) {
                return Xnio.this.connectDatagram(bindAddress, destination, thread, openListener, bindListener, optionMap);
            }
        };
    }

    public IoFuture<ConnectedMessageChannel> acceptDatagram(SocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptDatagramLocal((LocalSocketAddress)destination, thread, openListener, bindListener, optionMap);
        }
        throw new UnsupportedOperationException("Accept a connection to socket address " + destination.getClass());
    }

    protected IoFuture<ConnectedMessageChannel> acceptDatagramLocal(LocalSocketAddress destination, ConnectionChannelThread thread, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw new UnsupportedOptionException("Accept a local message connection");
    }

    public Acceptor<ConnectedMessageChannel> createMessageAcceptor(final ConnectionChannelThread thread, final OptionMap optionMap) {
        return new Acceptor<ConnectedMessageChannel>(){

            @Override
            public IoFuture<ConnectedMessageChannel> acceptTo(SocketAddress destination, ChannelListener<? super ConnectedMessageChannel> openListener, ChannelListener<? super BoundChannel> bindListener) {
                return Xnio.this.acceptDatagram(destination, thread, openListener, bindListener, optionMap);
            }
        };
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        throw new UnsupportedOperationException("UDP Server");
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ReadChannelThread readThread, WriteChannelThread writeThread, OptionMap optionMap) throws IOException {
        return this.createUdpServer(bindAddress, readThread, writeThread, ChannelListeners.nullChannelListener(), optionMap);
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ReadChannelThread readThread, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        return this.createUdpServer(bindAddress, readThread, null, bindListener, optionMap);
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ReadChannelThread readThread, OptionMap optionMap) throws IOException {
        return this.createUdpServer(bindAddress, readThread, null, ChannelListeners.nullChannelListener(), optionMap);
    }

    public ChannelSource<? extends StreamChannel> createPipeServer(ReadChannelThread readThread, WriteChannelThread writeThread, ChannelListener<? super SimpleAcceptingChannel<StreamChannel>> acceptListener) {
        throw new UnsupportedOperationException("Pipe Server");
    }

    public ChannelSource<? extends StreamSourceChannel> createPipeSourceServer(ReadChannelThread readThread, ChannelListener<? super SimpleAcceptingChannel<StreamSinkChannel>> acceptListener) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public ChannelSource<? extends StreamSinkChannel> createPipeSinkServer(WriteChannelThread writeThread, ChannelListener<? super SimpleAcceptingChannel<StreamSourceChannel>> acceptListener) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public FileChannel openFile(File file, OptionMap options) throws IOException {
        switch (options.get(Options.FILE_ACCESS, FileAccess.READ_WRITE)) {
            case READ_ONLY: {
                return new XnioFileChannel(new RandomAccessFile(file, "r").getChannel());
            }
            case READ_WRITE: {
                return new XnioFileChannel(new RandomAccessFile(file, "rw").getChannel());
            }
        }
        throw new IllegalStateException();
    }

    public FileChannel openFile(String fileName, OptionMap options) throws IOException {
        return this.openFile(new File(fileName), options);
    }

    public FileChannel openFile(File file, FileAccess access) throws IOException {
        if (access == null) {
            throw new IllegalArgumentException("access is null");
        }
        return this.openFile(file, FILE_ACCESS_OPTION_MAPS.get((Object)access));
    }

    public FileChannel openFile(String fileName, FileAccess access) throws IOException {
        if (access == null) {
            throw new IllegalArgumentException("access is null");
        }
        return this.openFile(new File(fileName), FILE_ACCESS_OPTION_MAPS.get((Object)access));
    }

    public abstract ReadChannelThread createReadChannelThread(ThreadFactory var1) throws IOException;

    public abstract WriteChannelThread createWriteChannelThread(ThreadFactory var1) throws IOException;

    public abstract ConnectionChannelThread createConnectionChannelThread(ThreadFactory var1) throws IOException;

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return String.format("XNIO provider \"%s\" <%s@%s>", this.getName(), this.getClass().getName(), Integer.toHexString(this.hashCode()));
    }

    protected String getProperty(String name) {
        if (!name.startsWith("xnio.")) {
            throw new SecurityException("Not allowed to read non-XNIO properties");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new GetPropertyAction(name, null));
        }
        return System.getProperty(name);
    }

    protected String getProperty(String name, String defaultValue) {
        if (!name.startsWith("xnio.")) {
            throw new SecurityException("Not allowed to read non-XNIO properties");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new GetPropertyAction(name, defaultValue));
        }
        return System.getProperty(name, defaultValue);
    }

    static {
        Logger.getLogger((String)"org.xnio").info((Object)("XNIO Version " + Version.VERSION));
        EnumMap<FileAccess, OptionMap> map = new EnumMap<FileAccess, OptionMap>(FileAccess.class);
        map.put(FileAccess.READ_ONLY, OptionMap.create(Options.FILE_ACCESS, FileAccess.READ_ONLY));
        map.put(FileAccess.READ_WRITE, OptionMap.create(Options.FILE_ACCESS, FileAccess.READ_WRITE));
        FILE_ACCESS_OPTION_MAPS = map;
    }

    private static final class GetPropertyAction
    implements PrivilegedAction<String> {
        private final String propertyName;
        private final String defaultValue;

        private GetPropertyAction(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String run() {
            return System.getProperty(this.propertyName, this.defaultValue);
        }
    }
}

