/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.util.ArrayList;
import java.util.Collection;
import org.xnio.Option;
import org.xnio.Sequence;

final class SequenceOption<T>
extends Option<Sequence<T>> {
    private static final long serialVersionUID = -4328676629293125136L;
    private final transient Class<T> elementType;
    private final transient Option.ValueParser<T> parser;

    SequenceOption(Class<?> declClass, String name, Class<T> elementType) {
        super(declClass, name);
        this.elementType = elementType;
        this.parser = Option.getParser(elementType);
    }

    @Override
    public Sequence<T> cast(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Sequence) {
            return ((Sequence)o).cast(this.elementType);
        }
        if (o instanceof Object[]) {
            return Sequence.of((Object[])o).cast(this.elementType);
        }
        if (o instanceof Collection) {
            return Sequence.of((Collection)o).cast(this.elementType);
        }
        throw new ClassCastException("Not a sequence");
    }

    @Override
    public Sequence<T> parseValue(String string) throws IllegalArgumentException {
        ArrayList<T> list = new ArrayList<T>();
        for (String value : string.split(",")) {
            list.add(this.parser.parseValue(value));
        }
        return Sequence.of(list);
    }
}

