/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.xnio.Option;
import org.xnio.Sequence;

public final class OptionMap
implements Iterable<Option<?>>,
Serializable {
    private static final long serialVersionUID = 3632842565346928132L;
    private final Map<Option<?>, Object> value;
    public static final OptionMap EMPTY = new OptionMap(Collections.<Option<?>, Object>emptyMap());

    private OptionMap(Map<Option<?>, Object> value) {
        this.value = value;
    }

    public boolean contains(Option<?> option) {
        return this.value.containsKey(option);
    }

    public <T> T get(Option<T> option) {
        return option.cast(this.value.get(option));
    }

    public <T> T get(Option<T> option, T defaultValue) {
        Object o = this.value.get(option);
        return o == null ? defaultValue : option.cast(o);
    }

    public boolean get(Option<Boolean> option, boolean defaultValue) {
        Object o = this.value.get(option);
        return o == null ? defaultValue : option.cast(o);
    }

    public int get(Option<Integer> option, int defaultValue) {
        Object o = this.value.get(option);
        return o == null ? defaultValue : option.cast(o);
    }

    public long get(Option<Long> option, long defaultValue) {
        Object o = this.value.get(option);
        return o == null ? defaultValue : option.cast(o);
    }

    @Override
    public Iterator<Option<?>> iterator() {
        return Collections.unmodifiableCollection(this.value.keySet()).iterator();
    }

    public int size() {
        return this.value.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <T> OptionMap create(Option<T> option, T value) {
        if (option == null) {
            throw new IllegalArgumentException("option is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        return new OptionMap(Collections.singletonMap(option, option.cast(value)));
    }

    public static final class Builder {
        private static final Logger log = Logger.getLogger((String)"org.xnio.option.parse");
        private List<OVPair<?>> list = new ArrayList();

        private Builder() {
        }

        public <T> Builder parse(Option<T> key, String stringValue) {
            this.set(key, key.parseValue(stringValue));
            return this;
        }

        public Builder parseAll(Properties props, String prefix, ClassLoader optionClassLoader) {
            for (String name : props.stringPropertyNames()) {
                if (!name.startsWith(prefix)) continue;
                String optionName = name.substring(prefix.length());
                try {
                    Option<?> option = Option.fromString(optionName, optionClassLoader);
                    this.parse(option, props.getProperty(name));
                }
                catch (IllegalArgumentException e) {
                    log.warnf("Invalid option '%s' in property '%s': %s", (Object)optionName, (Object)name, (Object)e);
                }
            }
            return this;
        }

        public Builder parseAll(Properties props, String prefix) {
            for (String name : props.stringPropertyNames()) {
                if (!name.startsWith(prefix)) continue;
                String optionName = name.substring(prefix.length());
                try {
                    Option<?> option = Option.fromString(optionName, null);
                    this.parse(option, props.getProperty(name));
                }
                catch (IllegalArgumentException e) {
                    log.warnf("Invalid option '%s' in property '%s': %s", (Object)optionName, (Object)name, (Object)e);
                }
            }
            return this;
        }

        public <T> Builder set(Option<T> key, T value) {
            if (value == null) {
                throw new NullPointerException("value is null");
            }
            this.list.add(new OVPair(key, value));
            return this;
        }

        public Builder set(Option<Integer> key, int value) {
            this.list.add(new OVPair(key, value));
            return this;
        }

        public Builder setSequence(Option<Sequence<Integer>> key, int ... values) {
            Integer[] a = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                a[i] = values[i];
            }
            this.list.add(new OVPair(key, Sequence.of(a)));
            return this;
        }

        public Builder set(Option<Long> key, long value) {
            this.list.add(new OVPair(key, value));
            return this;
        }

        public Builder setSequence(Option<Sequence<Long>> key, long ... values) {
            Long[] a = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                a[i] = values[i];
            }
            this.list.add(new OVPair(key, Sequence.of(a)));
            return this;
        }

        public Builder set(Option<Boolean> key, boolean value) {
            this.list.add(new OVPair(key, value));
            return this;
        }

        public Builder setSequence(Option<Sequence<Boolean>> key, boolean ... values) {
            Boolean[] a = new Boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                a[i] = values[i];
            }
            this.list.add(new OVPair(key, Sequence.of(a)));
            return this;
        }

        public <T> Builder setSequence(Option<Sequence<T>> key, T ... values) {
            this.list.add(new OVPair(key, Sequence.of(values)));
            return this;
        }

        private <T> void copy(Map<?, ?> map, Option<T> option) {
            this.set(option, option.cast(map.get(option)));
        }

        public Builder add(Map<?, ?> map) throws ClassCastException {
            for (Object key : map.keySet()) {
                Option option = (Option)Option.class.cast(key);
                this.copy(map, option);
            }
            return this;
        }

        private <T> void copy(OptionMap optionMap, Option<T> option) {
            this.set(option, optionMap.get(option));
        }

        public Builder addAll(OptionMap optionMap) {
            for (Option<?> option : optionMap) {
                this.copy(optionMap, option);
            }
            return this;
        }

        public OptionMap getMap() {
            List<OVPair<?>> list = this.list;
            if (list.size() == 0) {
                return EMPTY;
            }
            if (list.size() == 1) {
                OVPair<?> pair = list.get(0);
                return new OptionMap(Collections.singletonMap(pair.option, pair.value));
            }
            IdentityHashMap map = new IdentityHashMap();
            for (OVPair<?> ovPair : list) {
                map.put(ovPair.option, ovPair.value);
            }
            return new OptionMap(map);
        }

        private static class OVPair<T> {
            Option<T> option;
            T value;

            private OVPair(Option<T> option, T value) {
                this.option = option;
                this.value = value;
            }
        }
    }
}

