/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import org.jboss.logging.Logger;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.ReadChannelThread;
import org.xnio.Sequence;
import org.xnio.WriteChannelThread;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;

final class ConnectedSslStreamChannelImpl
implements ConnectedSslStreamChannel {
    private static final Logger log = Logger.getLogger((String)"org.xnio.ssl");
    private final ConnectedStreamChannel connectedStreamChannel;
    private final SSLEngine sslEngine;
    private final Executor executor;
    private volatile ChannelListener<? super ConnectedSslStreamChannel> readListener = null;
    private volatile ChannelListener<? super ConnectedSslStreamChannel> writeListener = null;
    private volatile ChannelListener<? super ConnectedSslStreamChannel> closeListener = null;
    private static final AtomicReferenceFieldUpdater<ConnectedSslStreamChannelImpl, ChannelListener> readListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(ConnectedSslStreamChannelImpl.class, ChannelListener.class, "readListener");
    private static final AtomicReferenceFieldUpdater<ConnectedSslStreamChannelImpl, ChannelListener> writeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(ConnectedSslStreamChannelImpl.class, ChannelListener.class, "writeListener");
    private static final AtomicReferenceFieldUpdater<ConnectedSslStreamChannelImpl, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(ConnectedSslStreamChannelImpl.class, ChannelListener.class, "closeListener");
    private final ChannelListener.Setter<ConnectedSslStreamChannel> readSetter = ChannelListeners.getSetter(this, readListenerUpdater);
    private final ChannelListener.Setter<ConnectedSslStreamChannel> writeSetter = ChannelListeners.getSetter(this, writeListenerUpdater);
    private final ChannelListener.Setter<ConnectedSslStreamChannel> closeSetter = ChannelListeners.getSetter(this, closeListenerUpdater);
    private final ChannelListener<ConnectedStreamChannel> tcpCloseListener = new ChannelListener<ConnectedStreamChannel>(){

        @Override
        public void handleEvent(ConnectedStreamChannel channel) {
            IoUtils.safeClose(ConnectedSslStreamChannelImpl.this);
            ChannelListeners.invokeChannelListener(ConnectedSslStreamChannelImpl.this, ConnectedSslStreamChannelImpl.this.closeListener);
        }
    };
    private final Runnable readTriggeredTask = new Runnable(){

        @Override
        public void run() {
            ConnectedSslStreamChannelImpl.this.runReadListener();
        }
    };
    private final ChannelListener<ConnectedStreamChannel> tcpReadListener = new ReadListener();
    private final ChannelListener<ConnectedStreamChannel> tcpWriteListener = new WriteListener();
    private final Lock mainLock = new ReentrantLock();
    private final Condition readAwaiters = this.mainLock.newCondition();
    private final Condition writeAwaiters = this.mainLock.newCondition();
    private boolean userReads;
    private boolean userWrites;
    private boolean needsWrap;
    private boolean needsUnwrap;
    private boolean newReadData;
    private ByteBuffer readBuffer = Buffers.EMPTY_BYTE_BUFFER;
    private ByteBuffer receiveBuffer = Buffers.EMPTY_BYTE_BUFFER;
    private ByteBuffer sendBuffer = Buffers.EMPTY_BYTE_BUFFER;
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.SSL_ENABLED_CIPHER_SUITES).add(Options.SSL_ENABLED_PROTOCOLS).add(Options.SSL_SUPPORTED_CIPHER_SUITES).add(Options.SSL_SUPPORTED_PROTOCOLS).create();

    private void runReadListener() {
        ChannelListeners.invokeChannelListener(this, this.readListener);
    }

    private void runWriteListener() {
        ChannelListeners.invokeChannelListener(this, this.writeListener);
    }

    ConnectedSslStreamChannelImpl(ConnectedStreamChannel connectedStreamChannel, SSLEngine sslEngine, Executor executor) {
        this.connectedStreamChannel = connectedStreamChannel;
        this.sslEngine = sslEngine;
        this.executor = executor;
        connectedStreamChannel.getReadSetter().set(this.tcpReadListener);
        connectedStreamChannel.getWriteSetter().set(this.tcpWriteListener);
        connectedStreamChannel.getCloseSetter().set(this.tcpCloseListener);
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.connectedStreamChannel.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        SocketAddress address = this.connectedStreamChannel.getPeerAddress();
        return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.connectedStreamChannel.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        SocketAddress address = this.connectedStreamChannel.getLocalAddress();
        return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
    }

    @Override
    public void startHandshake() throws IOException {
        this.sslEngine.beginHandshake();
    }

    @Override
    public SSLSession getSslSession() {
        return this.sslEngine.getSession();
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(this, position, count);
    }

    public ChannelListener.Setter<ConnectedSslStreamChannel> getReadSetter() {
        return this.readSetter;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this);
    }

    public ChannelListener.Setter<ConnectedSslStreamChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<ConnectedSslStreamChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public void setReadThread(ReadChannelThread thread) throws IllegalArgumentException {
        this.connectedStreamChannel.setReadThread(thread);
    }

    @Override
    public ReadChannelThread getReadThread() {
        return this.connectedStreamChannel.getReadThread();
    }

    @Override
    public void setWriteThread(WriteChannelThread thread) throws IllegalArgumentException {
        this.connectedStreamChannel.setWriteThread(thread);
    }

    @Override
    public WriteChannelThread getWriteThread() {
        return this.connectedStreamChannel.getWriteThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            boolean bl = this.doFlush();
            return bl;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush() throws IOException {
        SSLEngineResult wrapResult;
        ConnectedStreamChannel connectedStreamChannel = this.connectedStreamChannel;
        block23: while (true) {
            ByteBuffer sendBuffer = this.sendBuffer;
            sendBuffer.flip();
            try {
                while (sendBuffer.hasRemaining()) {
                    log.tracef("Flushing send buffer %s", (Object)sendBuffer);
                    if (connectedStreamChannel.write(sendBuffer) != 0) continue;
                    log.tracef("Send (in flush) would block, return false", new Object[0]);
                    boolean bl = false;
                    return bl;
                }
                if (!connectedStreamChannel.flush()) {
                    log.tracef("Flushing TCP channel would block, return false", new Object[0]);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                sendBuffer.compact();
            }
            SSLEngine sslEngine = this.sslEngine;
            log.tracef("Wrapping empty buffer into send buffer %s", (Object)sendBuffer);
            wrapResult = sslEngine.wrap(Buffers.EMPTY_BYTE_BUFFER, sendBuffer);
            log.tracef("Wrap result is %s", (Object)wrapResult);
            int produced = wrapResult.bytesProduced();
            switch (wrapResult.getStatus()) {
                case CLOSED: {
                    return true;
                }
                case BUFFER_UNDERFLOW: 
                case OK: {
                    if (produced > 0) {
                        log.tracef("Data produced, flush needed", new Object[0]);
                        continue block23;
                    }
                    switch (wrapResult.getHandshakeStatus()) {
                        case NOT_HANDSHAKING: 
                        case FINISHED: {
                            log.tracef("Fully flushed, return true", new Object[0]);
                            return true;
                        }
                        case NEED_TASK: {
                            Runnable task = sslEngine.getDelegatedTask();
                            log.tracef("Running delegated task %s", (Object)task);
                            task.run();
                            log.tracef("Finished delegated task %s", (Object)task);
                            continue block23;
                        }
                        case NEED_UNWRAP: {
                            SSLEngineResult unwrapResult;
                            log.tracef("Unwrap needed to proceed with flush", new Object[0]);
                            block25: while (true) {
                                ByteBuffer receiveBuffer = this.receiveBuffer;
                                ByteBuffer readBuffer = this.readBuffer;
                                log.tracef("Unwrapping from receive buffer %s to read buffer %s", (Object)receiveBuffer, (Object)readBuffer);
                                unwrapResult = sslEngine.unwrap(receiveBuffer, readBuffer);
                                this.readAwaiters.signalAll();
                                switch (unwrapResult.getStatus()) {
                                    case BUFFER_UNDERFLOW: {
                                        this.newReadData = false;
                                        if (receiveBuffer.position() == 0 && receiveBuffer.limit() == receiveBuffer.capacity()) {
                                            log.tracef("Receive buffer is too small, growing from %s", (Object)receiveBuffer);
                                            int pktBufSize = sslEngine.getSession().getPacketBufferSize();
                                            if (receiveBuffer.capacity() >= pktBufSize) {
                                                throw new IOException("Unexpected/inexplicable buffer underflow from the SSL engine");
                                            }
                                            this.receiveBuffer = Buffers.flip(ByteBuffer.allocate(pktBufSize).put(receiveBuffer));
                                            log.tracef("Grew receive buffer to %s", (Object)this.receiveBuffer);
                                            continue block25;
                                        }
                                        receiveBuffer.compact();
                                        try {
                                            log.tracef("Reading data into receive buffer %s", (Object)receiveBuffer);
                                            int res = connectedStreamChannel.read(receiveBuffer);
                                            if (res == -1) {
                                                log.tracef("End of input stream reached", new Object[0]);
                                                sslEngine.closeInbound();
                                                continue block23;
                                            }
                                            if (res == 0) {
                                                log.tracef("Read would block, set needsUnwrap = true", new Object[0]);
                                                this.needsUnwrap = true;
                                                boolean bl = false;
                                                return bl;
                                            }
                                            this.newReadData = true;
                                            continue block25;
                                        }
                                        finally {
                                            receiveBuffer.flip();
                                            continue block23;
                                        }
                                    }
                                    case CLOSED: {
                                        log.tracef("Engine is closed, everything must be flushed; return true", new Object[0]);
                                        return true;
                                    }
                                    case OK: {
                                        log.tracef("Unwrap complete, proceeding with wrap", new Object[0]);
                                        continue block23;
                                    }
                                }
                                break;
                            }
                            throw new IOException("Unexpected unwrap result status " + (Object)((Object)unwrapResult.getStatus()));
                        }
                    }
                    throw new IOException("Unexpected wrap result handshake status " + (Object)((Object)wrapResult.getStatus()));
                }
            }
            break;
        }
        throw new IOException("Unexpected wrap result status " + (Object)((Object)wrapResult.getStatus()));
    }

    @Override
    public boolean isOpen() {
        return this.connectedStreamChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.sslEngine.closeOutbound();
            IOException e1 = null;
            IOException e2 = null;
            try {
                this.sslEngine.closeInbound();
            }
            catch (IOException e) {
                e1 = e;
            }
            try {
                this.connectedStreamChannel.close();
            }
            catch (IOException e) {
                e2 = e;
            }
            if (e1 != null && e2 != null) {
                IOException t = new IOException("Multiple failures on close!  The second exception is: " + e2.toString());
                t.initCause(e1);
                throw t;
            }
            if (e1 != null) {
                throw e1;
            }
            if (e2 != null) {
                throw e2;
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option) || this.connectedStreamChannel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
            return option.cast(Sequence.of(this.sslEngine.getEnabledCipherSuites()));
        }
        if (option == Options.SSL_SUPPORTED_CIPHER_SUITES) {
            return option.cast(Sequence.of(this.sslEngine.getSupportedCipherSuites()));
        }
        if (option == Options.SSL_ENABLED_PROTOCOLS) {
            return option.cast(Sequence.of(this.sslEngine.getEnabledProtocols()));
        }
        if (option == Options.SSL_SUPPORTED_PROTOCOLS) {
            return option.cast(Sequence.of(this.sslEngine.getSupportedProtocols()));
        }
        return this.connectedStreamChannel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
            Sequence<String> strings = Options.SSL_ENABLED_CIPHER_SUITES.cast(value);
            String[] old = this.sslEngine.getEnabledCipherSuites();
            this.sslEngine.setEnabledCipherSuites(strings.toArray((String[])new String[strings.size()]));
            return option.cast(old);
        }
        if (option == Options.SSL_ENABLED_PROTOCOLS) {
            Sequence<String> strings = Options.SSL_ENABLED_PROTOCOLS.cast(value);
            String[] old = this.sslEngine.getEnabledProtocols();
            this.sslEngine.setEnabledProtocols(strings.toArray((String[])new String[strings.size()]));
            return option.cast(old);
        }
        return this.connectedStreamChannel.setOption(option, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendReads() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.userReads = false;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendWrites() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.userWrites = false;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeReads() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.readBuffer.position() > 0 || this.newReadData) {
                log.tracef("Application resumeReads() -> Execute read handler", new Object[0]);
                this.executor.execute(this.readTriggeredTask);
            } else {
                this.userReads = true;
                if (this.needsWrap) {
                    log.tracef("Application resumeReads() -> SSL resumeWrites()", new Object[0]);
                    this.connectedStreamChannel.resumeWrites();
                } else {
                    log.tracef("Application resumeReads() -> SSL resumeReads()", new Object[0]);
                    this.connectedStreamChannel.resumeReads();
                }
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeWrites() {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.userWrites = true;
            if (this.needsUnwrap) {
                log.tracef("Application resumeWrites() -> SSL resumeReads()", new Object[0]);
                this.connectedStreamChannel.resumeReads();
            } else {
                log.tracef("Application resumeWrites() -> SSL resumeWrites()", new Object[0]);
                this.connectedStreamChannel.resumeWrites();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownReads() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            log.tracef("Shutting down writes", new Object[0]);
            this.connectedStreamChannel.shutdownReads();
            this.sslEngine.closeInbound();
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdownWrites() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.flush()) {
                log.tracef("Shutting down writes", new Object[0]);
                this.sslEngine.closeOutbound();
                boolean bl = this.flush() && this.sslEngine.isOutboundDone() && this.connectedStreamChannel.shutdownWrites();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable() throws IOException {
        block7: {
            Lock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (this.readBuffer.position() != 0) break block7;
                try {
                    if (this.needsWrap) {
                        log.tracef("Application awaitReadable() -> SSL resumeWrites()", new Object[0]);
                        this.connectedStreamChannel.resumeWrites();
                    } else {
                        log.tracef("Application awaitReadable() -> SSL resumeReads()", new Object[0]);
                        this.connectedStreamChannel.resumeReads();
                    }
                    this.readAwaiters.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        block7: {
            Lock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (this.readBuffer.position() != 0) break block7;
                try {
                    if (this.needsWrap) {
                        log.tracef("Application awaitReadable() -> SSL resumeWrites()", new Object[0]);
                        this.connectedStreamChannel.resumeWrites();
                    } else {
                        log.tracef("Application awaitReadable() -> SSL resumeReads()", new Object[0]);
                        this.connectedStreamChannel.resumeReads();
                    }
                    this.readAwaiters.await(time, timeUnit);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    @Override
    public void awaitWritable() throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.needsUnwrap) {
                log.tracef("Application awaitWritable() -> SSL resumeReads()", new Object[0]);
                this.connectedStreamChannel.resumeReads();
            } else {
                log.tracef("Application awaitWritable() -> SSL resumeWrites()", new Object[0]);
                this.connectedStreamChannel.resumeWrites();
            }
            this.writeAwaiters.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.needsUnwrap) {
                log.tracef("Application awaitWritable() -> SSL resumeReads()", new Object[0]);
                this.connectedStreamChannel.resumeReads();
            } else {
                log.tracef("Application awaitWritable() -> SSL resumeWrites()", new Object[0]);
                this.connectedStreamChannel.resumeWrites();
            }
            this.writeAwaiters.await(time, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return (int)this.write(new ByteBuffer[]{src}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length < 1) {
            return 0L;
        }
        SSLEngine sslEngine = this.sslEngine;
        Lock mainLock = this.mainLock;
        mainLock.lock();
        try {
            SSLEngineResult wrapResult;
            ByteBuffer sendBuffer = this.sendBuffer;
            block32: while (true) {
                log.tracef("Wrapping %s (and possibly more) into send buffer %s", (Object)srcs[0], (Object)sendBuffer);
                wrapResult = sslEngine.wrap(srcs, offset, length, sendBuffer);
                log.tracef("Wrap result is %s", (Object)wrapResult);
                int produced = wrapResult.bytesProduced();
                int consumed = wrapResult.bytesConsumed();
                ConnectedStreamChannel connectedStreamChannel = this.connectedStreamChannel;
                switch (wrapResult.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        if (sendBuffer.position() == 0) {
                            log.tracef("Send buffer is too small, growing from %s", (Object)sendBuffer);
                            int oldCap = sendBuffer.capacity();
                            int reqCap = sslEngine.getSession().getPacketBufferSize();
                            if (reqCap <= oldCap) {
                                throw new IOException("SSLEngine required a bigger send buffer but our buffer was already big enough");
                            }
                            sendBuffer = this.sendBuffer = ByteBuffer.allocate(reqCap);
                            log.tracef("Grew send buffer to %s", (Object)this.sendBuffer);
                            continue block32;
                        }
                        log.tracef("No room in send buffer, flushing", new Object[0]);
                        sendBuffer.flip();
                        try {
                            int res = connectedStreamChannel.write(sendBuffer);
                            if (res != 0) continue block32;
                            long reqCap = consumed;
                            return reqCap;
                        }
                        finally {
                            sendBuffer.compact();
                            continue block32;
                        }
                    }
                    case BUFFER_UNDERFLOW: {
                        log.tracef("Source buffer must be empty, finished", new Object[0]);
                        long res = consumed;
                        return res;
                    }
                    case CLOSED: {
                        log.tracef("Attempted to write after the channel is shut down", new Object[0]);
                        throw new ClosedChannelException();
                    }
                    case OK: {
                        if (consumed == 0) {
                            if (produced > 0) continue block32;
                            switch (wrapResult.getHandshakeStatus()) {
                                case NEED_TASK: {
                                    Runnable task = sslEngine.getDelegatedTask();
                                    log.tracef("Running delegated task %s", (Object)task);
                                    task.run();
                                    log.tracef("Finished delegated task %s", (Object)task);
                                    continue block32;
                                }
                                case NEED_UNWRAP: {
                                    SSLEngineResult unwrapResult;
                                    log.tracef("Unwrap required before write can proceed", new Object[0]);
                                    block33: while (true) {
                                        ByteBuffer receiveBuffer = this.receiveBuffer;
                                        ByteBuffer readBuffer = this.readBuffer;
                                        log.tracef("Unwrapping from receive buffer %s to read buffer %s", (Object)receiveBuffer, (Object)readBuffer);
                                        unwrapResult = sslEngine.unwrap(receiveBuffer, readBuffer);
                                        log.tracef("Unwrap result is %s", (Object)unwrapResult);
                                        if (!receiveBuffer.hasRemaining()) {
                                            receiveBuffer.clear().flip();
                                        }
                                        this.readAwaiters.signalAll();
                                        switch (unwrapResult.getStatus()) {
                                            case BUFFER_UNDERFLOW: {
                                                this.newReadData = false;
                                                if (receiveBuffer.position() == 0 && receiveBuffer.limit() == receiveBuffer.capacity()) {
                                                    log.tracef("Receive buffer is not large enough to feed unwrap, growing from %s", (Object)receiveBuffer);
                                                    int pktBufSize = sslEngine.getSession().getPacketBufferSize();
                                                    if (receiveBuffer.capacity() >= pktBufSize) {
                                                        throw new IOException("Unexpected/inexplicable buffer underflow from the SSL engine");
                                                    }
                                                    this.receiveBuffer = Buffers.flip(ByteBuffer.allocate(pktBufSize).put(receiveBuffer));
                                                    log.tracef("Grew receive buffer to %s", (Object)this.receiveBuffer);
                                                    continue block33;
                                                }
                                                receiveBuffer.compact();
                                                try {
                                                    log.tracef("Filling receive buffer (read)", new Object[0]);
                                                    int res = connectedStreamChannel.read(receiveBuffer);
                                                    if (res == -1) {
                                                        log.tracef("End of inbound data", new Object[0]);
                                                        sslEngine.closeInbound();
                                                        continue block32;
                                                    }
                                                    if (res == 0) {
                                                        log.tracef("Read would block, setting needsUnwrap = true", new Object[0]);
                                                        this.needsUnwrap = true;
                                                        long l = consumed;
                                                        return l;
                                                    }
                                                    log.tracef("Read successful, retrying unwrap", new Object[0]);
                                                    this.newReadData = true;
                                                    continue block33;
                                                }
                                                finally {
                                                    receiveBuffer.flip();
                                                    continue block32;
                                                }
                                            }
                                            case BUFFER_OVERFLOW: {
                                                int appBufSize = sslEngine.getSession().getApplicationBufferSize();
                                                if (readBuffer.capacity() >= appBufSize) {
                                                    throw new IOException("Unexpected/inexplicable buffer overflow from the SSL engine");
                                                }
                                                log.tracef("Read buffer is too small, growing from %s", (Object)readBuffer);
                                                this.readBuffer = ByteBuffer.allocate(appBufSize).put(Buffers.flip(readBuffer));
                                                log.tracef("Grew read buffer to %s", (Object)this.readBuffer);
                                                continue block33;
                                            }
                                            case CLOSED: {
                                                log.tracef("Read on closed channel, return", new Object[0]);
                                                long l = consumed == 0 ? -1L : (long)consumed;
                                                return l;
                                            }
                                            case OK: {
                                                log.tracef("Unwrap succeeded, proceeding with wrap", new Object[0]);
                                                continue block32;
                                            }
                                        }
                                        break;
                                    }
                                    throw new IOException("Unexpected unwrap result status " + (Object)((Object)unwrapResult.getStatus()));
                                }
                            }
                            throw new IOException("Unexpected handshake state " + (Object)((Object)wrapResult.getHandshakeStatus()) + " on wrap");
                        }
                        long l = consumed;
                        return l;
                    }
                }
                break;
            }
            throw new IOException("Unexpected wrap result status " + (Object)((Object)wrapResult.getStatus()));
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return (int)this.read(new ByteBuffer[]{dst}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        block51: {
            if (dsts.length == 0) return 0L;
            if (length == 0) {
                return 0L;
            }
            mainLock = this.mainLock;
            mainLock.lock();
            readBuffer = this.readBuffer;
            if (readBuffer.position() > 0) {
                ConnectedSslStreamChannelImpl.log.tracef("Returning data from read buffer %s", (Object)readBuffer);
                readBuffer.flip();
                try {
                    var6_6 = Buffers.copy(dsts, offset, length, readBuffer);
                    return var6_6;
                }
                finally {
                    readBuffer.compact();
                }
            }
            connectedStreamChannel = this.connectedStreamChannel;
            sslEngine = this.sslEngine;
lbl21:
            // 2 sources

            block38: while (true) {
                receiveBuffer = this.receiveBuffer;
                ConnectedSslStreamChannelImpl.log.tracef("Unwrapping from %s to %s", (Object)receiveBuffer, (Object)readBuffer);
                unwrapResult = sslEngine.unwrap(receiveBuffer, readBuffer);
                ConnectedSslStreamChannelImpl.log.tracef("Unwrap result is %s", (Object)unwrapResult);
                produced = unwrapResult.bytesProduced();
                switch (3.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[unwrapResult.getStatus().ordinal()]) {
                    case 4: {
                        if (readBuffer.position() > 0) {
                            this.readAwaiters.signalAll();
                            ConnectedSslStreamChannelImpl.log.tracef("Returning data from read buffer %s", (Object)readBuffer);
                            readBuffer.flip();
                            try {
                                var11_13 = Buffers.copy(dsts, offset, length, readBuffer);
                                return var11_13;
                            }
                            finally {
                                readBuffer.compact();
                            }
                        }
                        ConnectedSslStreamChannelImpl.log.tracef("Growing application readBuffer from %s", (Object)readBuffer);
                        appBufSize = sslEngine.getSession().getApplicationBufferSize();
                        if (readBuffer.capacity() >= appBufSize) {
                            throw new IOException("Unexpected/inexplicable buffer overflow from the SSL engine");
                        }
                        readBuffer = this.readBuffer = ByteBuffer.allocate(appBufSize);
                        ConnectedSslStreamChannelImpl.log.tracef("Grew application readBuffer to %s", (Object)this.readBuffer);
                        continue block38;
                    }
                    case 1: {
                        this.newReadData = false;
                        if (receiveBuffer.position() == 0 && receiveBuffer.limit() == receiveBuffer.capacity()) {
                            ConnectedSslStreamChannelImpl.log.tracef("Growing receive buffer from %s", (Object)receiveBuffer);
                            pktBufSize = sslEngine.getSession().getPacketBufferSize();
                            if (receiveBuffer.capacity() >= pktBufSize) {
                                throw new IOException("Unexpected/inexplicable buffer underflow from the SSL engine");
                            }
                            this.receiveBuffer = Buffers.flip(ByteBuffer.allocate(pktBufSize).put(receiveBuffer));
                            ConnectedSslStreamChannelImpl.log.tracef("Grew receive buffer to %s", (Object)this.receiveBuffer);
                            continue block38;
                        }
                        receiveBuffer.compact();
                        try {
                            ConnectedSslStreamChannelImpl.log.tracef("Reading into %s", (Object)receiveBuffer);
                            rres = connectedStreamChannel.read(receiveBuffer);
                            ConnectedSslStreamChannelImpl.log.tracef("Read into %s", (Object)receiveBuffer);
                        }
                        finally {
                            receiveBuffer.flip();
                        }
                        if (rres == -1) {
                            ConnectedSslStreamChannelImpl.log.tracef("Hit EOF on TCP stream, closing SSL inbound", new Object[0]);
                            sslEngine.closeInbound();
                        } else if (rres == 0) {
                            var12_22 = 0L;
                            return var12_22;
                        }
                        this.newReadData = true;
                        continue block38;
                    }
                    case 2: {
                        ConnectedSslStreamChannelImpl.log.tracef("Read from closed SSL inbound", new Object[0]);
                        this.needsUnwrap = false;
                        rres = -1L;
                        return rres;
                    }
                    case 3: {
                        this.needsUnwrap = false;
                        if (produced > 0) {
                            this.readAwaiters.signalAll();
                            ConnectedSslStreamChannelImpl.log.tracef("Returning data from read buffer %s", (Object)readBuffer);
                            readBuffer.flip();
                            try {
                                rres = Buffers.copy(dsts, offset, length, readBuffer);
                                return rres;
                            }
                            finally {
                                readBuffer.compact();
                            }
                        }
                        switch (3.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[unwrapResult.getHandshakeStatus().ordinal()]) {
                            case 3: {
                                task = sslEngine.getDelegatedTask();
                                ConnectedSslStreamChannelImpl.log.tracef("Running delegated task %s", (Object)task);
                                task.run();
                                ConnectedSslStreamChannelImpl.log.tracef("Delegated task %s complete", (Object)task);
                                continue block38;
                            }
                            case 5: {
                                ConnectedSslStreamChannelImpl.log.tracef("Wrap required for read to proceed", new Object[0]);
                                break block51;
                            }
                            default: {
                                throw new IOException("Unexpected handshake status of " + (Object)unwrapResult.getHandshakeStatus() + " while unwrapping");
                            }
                        }
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                break;
            }
            finally {
                mainLock.unlock();
            }
        }
        block39: while (true) {
            sendBuffer = this.sendBuffer;
            ConnectedSslStreamChannelImpl.log.tracef("Wrapping empty buffer into %s", (Object)sendBuffer);
            wrapResult = sslEngine.wrap(Buffers.EMPTY_BYTE_BUFFER, sendBuffer);
            ConnectedSslStreamChannelImpl.log.tracef("Wrap result is %s", (Object)wrapResult);
            this.writeAwaiters.signalAll();
            switch (3.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[wrapResult.getStatus().ordinal()]) {
                case 4: {
                    pktBufSize = sslEngine.getSession().getPacketBufferSize();
                    if (sendBuffer.capacity() < pktBufSize) {
                        ConnectedSslStreamChannelImpl.log.tracef("Send buffer is too small; resizing from %s", (Object)sendBuffer);
                        this.sendBuffer = ByteBuffer.allocate(pktBufSize);
                        ConnectedSslStreamChannelImpl.log.tracef("Send buffer resized to %s", (Object)this.sendBuffer.put(sendBuffer).flip());
                        continue block39;
                    }
                    sendBuffer.flip();
                    try {
                        ConnectedSslStreamChannelImpl.log.tracef("Send buffer has insufficient space, flushing", new Object[0]);
                        res = connectedStreamChannel.write(sendBuffer);
                        if (res != 0) continue block39;
                        ConnectedSslStreamChannelImpl.log.tracef("Channel is not writable, set needsWrap = true", new Object[0]);
                        this.needsWrap = true;
                        var15_28 = 0L;
                        return var15_28;
                    }
                    finally {
                        sendBuffer.compact();
                        continue block39;
                    }
                }
                case 3: {
                    ConnectedSslStreamChannelImpl.log.tracef("Wrap successful, continuing unwrap", new Object[0]);
                    this.needsWrap = false;
                    ** continue;
                }
            }
            break;
        }
        throw new IOException("Unexpected status of " + (Object)wrapResult.getStatus() + " while wrapping for an unwrap");
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    public String toString() {
        return String.format("SSL wrapped <%h> %s", this, this.connectedStreamChannel);
    }

    private class ReadListener
    implements ChannelListener<ConnectedStreamChannel> {
        private ReadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(ConnectedStreamChannel channel) {
            boolean runRead = false;
            boolean runWrite = false;
            Lock mainLock = ConnectedSslStreamChannelImpl.this.mainLock;
            mainLock.lock();
            try {
                if (ConnectedSslStreamChannelImpl.this.needsUnwrap) {
                    ConnectedSslStreamChannelImpl.this.writeAwaiters.signalAll();
                }
                if (!ConnectedSslStreamChannelImpl.this.needsWrap) {
                    ConnectedSslStreamChannelImpl.this.readAwaiters.signalAll();
                    if (ConnectedSslStreamChannelImpl.this.userReads) {
                        ConnectedSslStreamChannelImpl.this.userReads = false;
                        runRead = true;
                    }
                }
                if (ConnectedSslStreamChannelImpl.this.userWrites && ConnectedSslStreamChannelImpl.this.needsUnwrap) {
                    ConnectedSslStreamChannelImpl.this.userWrites = false;
                    runWrite = true;
                }
            }
            finally {
                mainLock.unlock();
            }
            if (runRead) {
                ConnectedSslStreamChannelImpl.this.runReadListener();
            }
            if (runWrite) {
                ConnectedSslStreamChannelImpl.this.runWriteListener();
            }
        }
    }

    private class WriteListener
    implements ChannelListener<ConnectedStreamChannel> {
        private WriteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(ConnectedStreamChannel channel) {
            boolean runRead = false;
            boolean runWrite = false;
            Lock mainLock = ConnectedSslStreamChannelImpl.this.mainLock;
            mainLock.lock();
            try {
                if (ConnectedSslStreamChannelImpl.this.needsWrap) {
                    ConnectedSslStreamChannelImpl.this.readAwaiters.signalAll();
                }
                if (!ConnectedSslStreamChannelImpl.this.needsUnwrap) {
                    ConnectedSslStreamChannelImpl.this.writeAwaiters.signalAll();
                    if (ConnectedSslStreamChannelImpl.this.userWrites) {
                        ConnectedSslStreamChannelImpl.this.userWrites = false;
                        runWrite = true;
                    }
                }
                if (ConnectedSslStreamChannelImpl.this.userReads && ConnectedSslStreamChannelImpl.this.needsWrap) {
                    ConnectedSslStreamChannelImpl.this.userReads = false;
                    runRead = true;
                }
            }
            finally {
                mainLock.unlock();
            }
            if (runRead) {
                ConnectedSslStreamChannelImpl.this.runReadListener();
            }
            if (runWrite) {
                ConnectedSslStreamChannelImpl.this.runWriteListener();
            }
        }
    }
}

