/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.xnio.ChannelThread;
import org.xnio.ChannelThreadPool;

public final class ChannelThreadPools {
    private static final ChannelThread[] NO_THREADS = new ChannelThread[0];

    private ChannelThreadPools() {
    }

    public static <T extends ChannelThread> ChannelThreadPool<T> createRandomPool() {
        return new SimpleThreadPool<T>(){
            private final Random random = new Random();

            @Override
            public T getThread() {
                ChannelThread[] pool = this.pool;
                int len = pool.length;
                if (len == 0) {
                    return null;
                }
                return pool[this.random.nextInt(len)];
            }
        };
    }

    public static <T extends ChannelThread> ChannelThreadPool<T> createLightestLoadPool() {
        return new SimpleThreadPool<T>(){
            private final Set<T> threadSet = new HashSet();
            private volatile T[] pool = ChannelThreadPools.access$100();

            @Override
            public T getThread() {
                T[] pool = this.pool;
                int len = pool.length;
                if (len == 0) {
                    return null;
                }
                int best = Integer.MAX_VALUE;
                int bestIdx = -1;
                for (int i = 0; i < len; ++i) {
                    int load = pool[i].getLoad();
                    if (load >= best) continue;
                    bestIdx = i;
                }
                return pool[bestIdx];
            }
        };
    }

    public static <T extends ChannelThread> ChannelThreadPool<T> singleton(final T thread) {
        return new ChannelThreadPool<T>(){

            @Override
            public T getThread() {
                return thread;
            }

            @Override
            public void addToPool(T thread2) {
                throw new IllegalArgumentException("Pool is full");
            }
        };
    }

    private static abstract class SimpleThreadPool<T extends ChannelThread>
    implements ChannelThreadPool<T> {
        private final Set<T> threadSet = new HashSet<T>();
        private final ChannelThread.Listener listener = new ChannelThread.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleTerminationInitiated(ChannelThread thread) {
                Set threadSet;
                thread.removeTerminationListener(this);
                Set set = threadSet = SimpleThreadPool.this.threadSet;
                synchronized (set) {
                    if (threadSet.remove(thread)) {
                        SimpleThreadPool.this.pool = threadSet.toArray(NO_THREADS);
                    }
                }
            }

            @Override
            public void handleTerminationComplete(ChannelThread thread) {
            }
        };
        volatile T[] pool = ChannelThreadPools.access$100();

        private SimpleThreadPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addToPool(T thread) {
            Set<T> threadSet;
            Set<T> set = threadSet = this.threadSet;
            synchronized (set) {
                if (threadSet.add(thread)) {
                    T[] pool = this.pool;
                    int oldLen = pool.length;
                    ChannelThread[] newPool = (ChannelThread[])Arrays.copyOf(pool, oldLen + 1);
                    newPool[oldLen] = thread;
                    thread.addTerminationListener(this.listener);
                    this.pool = newPool;
                }
            }
        }
    }
}

