/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ConnectedSslStreamChannelImpl;
import org.xnio.ConnectionChannelThread;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ReadChannelThread;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.WriteChannelThread;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;

final class AcceptingSslStreamChannel
implements AcceptingChannel<ConnectedSslStreamChannel> {
    private final SSLContext sslContext;
    private final AcceptingChannel<? extends ConnectedStreamChannel> tcpServer;
    private final Executor sslExecutor;
    private volatile SslClientAuthMode clientAuthMode;
    private volatile int useClientMode;
    private volatile int enableSessionCreation;
    private volatile String[] cipherSuites;
    private volatile String[] protocols;
    private static final AtomicReferenceFieldUpdater<AcceptingSslStreamChannel, SslClientAuthMode> clientAuthModeUpdater = AtomicReferenceFieldUpdater.newUpdater(AcceptingSslStreamChannel.class, SslClientAuthMode.class, "clientAuthMode");
    private static final AtomicIntegerFieldUpdater<AcceptingSslStreamChannel> useClientModeUpdater = AtomicIntegerFieldUpdater.newUpdater(AcceptingSslStreamChannel.class, "useClientMode");
    private static final AtomicIntegerFieldUpdater<AcceptingSslStreamChannel> enableSessionCreationUpdater = AtomicIntegerFieldUpdater.newUpdater(AcceptingSslStreamChannel.class, "enableSessionCreation");
    private static final AtomicReferenceFieldUpdater<AcceptingSslStreamChannel, String[]> cipherSuitesUpdater = AtomicReferenceFieldUpdater.newUpdater(AcceptingSslStreamChannel.class, String[].class, "cipherSuites");
    private static final AtomicReferenceFieldUpdater<AcceptingSslStreamChannel, String[]> protocolsUpdater = AtomicReferenceFieldUpdater.newUpdater(AcceptingSslStreamChannel.class, String[].class, "protocols");
    private final ChannelListener.Setter<AcceptingChannel<ConnectedSslStreamChannel>> closeSetter;
    private final ChannelListener.Setter<AcceptingChannel<ConnectedSslStreamChannel>> acceptSetter;
    private static final Set<Option<?>> SUPPORTED_OPTIONS = Option.setBuilder().add(Options.SSL_CLIENT_AUTH_MODE).add(Options.SSL_USE_CLIENT_MODE).add(Options.SSL_ENABLE_SESSION_CREATION).add(Options.SSL_ENABLED_CIPHER_SUITES).add(Options.SSL_ENABLED_PROTOCOLS).create();

    AcceptingSslStreamChannel(SSLContext sslContext, AcceptingChannel<? extends ConnectedStreamChannel> tcpServer, Executor executor, OptionMap optionMap) {
        this.tcpServer = tcpServer;
        this.sslExecutor = executor;
        this.sslContext = sslContext;
        this.clientAuthMode = optionMap.get(Options.SSL_CLIENT_AUTH_MODE);
        this.useClientMode = optionMap.get(Options.SSL_USE_CLIENT_MODE, false) ? 1 : 0;
        this.enableSessionCreation = optionMap.get(Options.SSL_ENABLE_SESSION_CREATION, true) ? 1 : 0;
        Sequence<String> enabledCipherSuites = optionMap.get(Options.SSL_ENABLED_CIPHER_SUITES);
        this.cipherSuites = enabledCipherSuites != null ? enabledCipherSuites.toArray((String[])new String[enabledCipherSuites.size()]) : null;
        Sequence<String> enabledProtocols = optionMap.get(Options.SSL_ENABLED_PROTOCOLS);
        this.protocols = enabledProtocols != null ? enabledProtocols.toArray((String[])new String[enabledProtocols.size()]) : null;
        this.closeSetter = ChannelListeners.getDelegatingSetter(tcpServer.getCloseSetter(), this);
        this.acceptSetter = ChannelListeners.getDelegatingSetter(tcpServer.getAcceptSetter(), this);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            return option.cast((Object)clientAuthModeUpdater.getAndSet(this, Options.SSL_CLIENT_AUTH_MODE.cast(value)));
        }
        if (option == Options.SSL_USE_CLIENT_MODE) {
            Boolean valueObject = Options.SSL_USE_CLIENT_MODE.cast(value);
            if (valueObject != null) {
                return option.cast(useClientModeUpdater.getAndSet(this, valueObject != false ? 1 : 0) != 0);
            }
        } else if (option == Options.SSL_ENABLE_SESSION_CREATION) {
            Boolean valueObject = Options.SSL_ENABLE_SESSION_CREATION.cast(value);
            if (valueObject != null) {
                return option.cast(enableSessionCreationUpdater.getAndSet(this, valueObject != false ? 1 : 0) != 0);
            }
        } else {
            if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
                Sequence<String> seq = Options.SSL_ENABLED_CIPHER_SUITES.cast(value);
                return option.cast(cipherSuitesUpdater.getAndSet(this, seq == null ? null : seq.toArray((String[])new String[seq.size()])));
            }
            if (option == Options.SSL_ENABLED_PROTOCOLS) {
                Sequence<String> seq = Options.SSL_ENABLED_PROTOCOLS.cast(value);
                return option.cast(protocolsUpdater.getAndSet(this, seq == null ? null : seq.toArray((String[])new String[seq.size()])));
            }
            return this.tcpServer.setOption(option, value);
        }
        throw new IllegalArgumentException("value is null");
    }

    @Override
    public ConnectedSslStreamChannel accept(ReadChannelThread readThread, WriteChannelThread writeThread) throws IOException {
        String[] protocols;
        SslClientAuthMode clientAuthMode;
        ConnectedStreamChannel tcpChannel = this.tcpServer.accept(readThread, writeThread);
        if (tcpChannel == null) {
            return null;
        }
        InetSocketAddress peerAddress = tcpChannel.getPeerAddress(InetSocketAddress.class);
        SSLEngine engine = this.sslContext.createSSLEngine(peerAddress.getHostName(), peerAddress.getPort());
        boolean clientMode = this.useClientMode != 0;
        engine.setUseClientMode(clientMode);
        if (!clientMode && (clientAuthMode = this.clientAuthMode) != null) {
            switch (clientAuthMode) {
                case NOT_REQUESTED: {
                    engine.setNeedClientAuth(false);
                    engine.setWantClientAuth(false);
                    break;
                }
                case REQUESTED: {
                    engine.setWantClientAuth(true);
                    break;
                }
                case REQUIRED: {
                    engine.setNeedClientAuth(true);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        engine.setEnableSessionCreation(this.enableSessionCreation != 0);
        String[] cipherSuites = this.cipherSuites;
        if (cipherSuites != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedCipherSuites()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String name : cipherSuites) {
                if (!supported.contains(name)) continue;
                finalList.add(name);
            }
            engine.setEnabledCipherSuites(finalList.toArray(new String[finalList.size()]));
        }
        if ((protocols = this.protocols) != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedProtocols()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String name : protocols) {
                if (!supported.contains(name)) continue;
                finalList.add(name);
            }
            engine.setEnabledProtocols(finalList.toArray(new String[finalList.size()]));
        }
        return new ConnectedSslStreamChannelImpl(tcpChannel, engine, this.sslExecutor);
    }

    @Override
    public ChannelListener.Setter<? extends AcceptingChannel<ConnectedSslStreamChannel>> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public boolean isOpen() {
        return this.tcpServer.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.tcpServer.close();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return SUPPORTED_OPTIONS.contains(option) || this.tcpServer.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            return option.cast((Object)this.clientAuthMode);
        }
        if (option == Options.SSL_USE_CLIENT_MODE) {
            return option.cast(this.useClientMode != 0);
        }
        if (option == Options.SSL_ENABLE_SESSION_CREATION) {
            return option.cast(this.enableSessionCreation != 0);
        }
        if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
            String[] cipherSuites = this.cipherSuites;
            return cipherSuites == null ? null : (T)option.cast(Sequence.of(cipherSuites));
        }
        if (option == Options.SSL_ENABLED_PROTOCOLS) {
            String[] protocols = this.protocols;
            return protocols == null ? null : (T)option.cast(Sequence.of(protocols));
        }
        return this.tcpServer.getOption(option);
    }

    @Override
    public ChannelListener.Setter<? extends AcceptingChannel<ConnectedSslStreamChannel>> getAcceptSetter() {
        return this.acceptSetter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.tcpServer.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.tcpServer.getLocalAddress(type);
    }

    @Override
    public void suspendAccepts() {
        this.tcpServer.suspendAccepts();
    }

    @Override
    public void resumeAccepts() {
        this.tcpServer.resumeAccepts();
    }

    @Override
    public void awaitAcceptable() throws IOException {
        this.tcpServer.awaitAcceptable();
    }

    @Override
    public void awaitAcceptable(long time, TimeUnit timeUnit) throws IOException {
        this.tcpServer.awaitAcceptable(time, timeUnit);
    }

    @Override
    public void setAcceptThread(ConnectionChannelThread thread) throws IllegalArgumentException {
        this.tcpServer.setAcceptThread(thread);
    }

    @Override
    public ConnectionChannelThread getAcceptThread() {
        return this.tcpServer.getAcceptThread();
    }
}

