/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.log;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.xnio.log.Logger;

class XnioLogRecord
extends LogRecord {
    private static final long serialVersionUID = 542119905844866161L;
    private boolean resolved;
    private static final String LOGGER_CLASS_NAME = Logger.class.getName();

    XnioLogRecord(Level level, String msg) {
        super(level, msg);
    }

    @Override
    public String getSourceClassName() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceClassName();
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        this.resolved = true;
        super.setSourceClassName(sourceClassName);
    }

    @Override
    public String getSourceMethodName() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceMethodName();
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        this.resolved = true;
        super.setSourceMethodName(sourceMethodName);
    }

    private void resolve() {
        this.resolved = true;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        boolean found = false;
        StackTraceElement[] stackTraceElementArray = stack;
        int n = stack.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            String className = element.getClassName();
            if (found) {
                if (!LOGGER_CLASS_NAME.equals(className)) {
                    this.setSourceClassName(className);
                    this.setSourceMethodName(element.getMethodName());
                    return;
                }
            } else {
                found = LOGGER_CLASS_NAME.equals(className);
            }
            ++n2;
        }
        this.setSourceClassName("<unknown>");
        this.setSourceMethodName("<unknown>");
    }

    protected Object writeReplace() {
        LogRecord replacement = new LogRecord(this.getLevel(), this.getMessage());
        replacement.setResourceBundle(this.getResourceBundle());
        replacement.setLoggerName(this.getLoggerName());
        replacement.setMillis(this.getMillis());
        replacement.setParameters(this.getParameters());
        replacement.setResourceBundleName(this.getResourceBundleName());
        replacement.setSequenceNumber(this.getSequenceNumber());
        replacement.setSourceClassName(this.getSourceClassName());
        replacement.setSourceMethodName(this.getSourceMethodName());
        replacement.setThreadID(this.getThreadID());
        replacement.setThrown(this.getThrown());
        return replacement;
    }
}

