/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.channels.MessageHandler;
import org.jboss.xnio.channels.StreamSourceChannel;

final class MessageStreamChannelListener
implements ChannelListener<StreamSourceChannel> {
    private final int maxInboundMessageSize;
    private final ByteBuffer readLengthBuf = ByteBuffer.allocate(4);
    private ReadState readState = ReadState.LENGTH;
    private ByteBuffer readBuffer;
    private volatile MessageHandler messageHandler;
    private final MessageHandler.Setter setter = new MessageHandler.Setter(){

        @Override
        public void set(MessageHandler newMessageHandler) {
            MessageStreamChannelListener.this.messageHandler = newMessageHandler;
        }
    };

    MessageStreamChannelListener(OptionMap optionMap) {
        this.maxInboundMessageSize = optionMap.get(Options.MAX_INBOUND_MESSAGE_SIZE, 2048);
    }

    MessageHandler.Setter getSetter() {
        return this.setter;
    }

    @Override
    public void handleEvent(StreamSourceChannel channel) {
        ByteBuffer readLengthBuf = this.readLengthBuf;
        block9: while (true) {
            switch (this.readState) {
                case EOF: {
                    return;
                }
                case LENGTH: {
                    while (readLengthBuf.hasRemaining()) {
                        int res;
                        try {
                            res = channel.read(readLengthBuf);
                        }
                        catch (IOException e) {
                            this.handleException(e);
                            return;
                        }
                        if (res == 0) {
                            channel.resumeReads();
                            return;
                        }
                        if (res != -1) continue;
                        this.readState = ReadState.EOF;
                        if (readLengthBuf.position() == 0) {
                            this.handleEof();
                            return;
                        }
                        readLengthBuf.clear();
                        this.handleException(new IOException("Truncated message"));
                        return;
                    }
                    int len = Buffers.flip(readLengthBuf).getInt();
                    readLengthBuf.clear();
                    if (len == 0) {
                        channel.resumeReads();
                        return;
                    }
                    int maxInboundMessageSize = this.maxInboundMessageSize;
                    if (len > maxInboundMessageSize) {
                        this.readState = ReadState.EOF;
                        this.handleException(new IOException("Received oversized message"));
                        return;
                    }
                    this.readState = ReadState.BODY;
                    this.readBuffer = ByteBuffer.allocate(len);
                }
                case BODY: {
                    ByteBuffer readBuffer = this.readBuffer;
                    while (readBuffer.hasRemaining()) {
                        int res;
                        try {
                            res = channel.read(readBuffer);
                        }
                        catch (IOException e) {
                            this.readState = ReadState.EOF;
                            this.handleException(e);
                            return;
                        }
                        if (res == 0) {
                            channel.resumeReads();
                            return;
                        }
                        if (res != -1) continue;
                        this.readState = ReadState.EOF;
                        this.handleException(new IOException("Truncated message"));
                    }
                    readBuffer.flip();
                    this.readBuffer = null;
                    this.readState = ReadState.LENGTH;
                    this.handleMessage(readBuffer);
                    continue block9;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private void handleMessage(ByteBuffer readBuffer) {
        MessageHandler messageHandler = this.messageHandler;
        if (messageHandler != null) {
            try {
                messageHandler.handleMessage(readBuffer);
            }
            catch (Throwable throwable) {}
        }
    }

    private void handleEof() {
        MessageHandler messageHandler = this.messageHandler;
        if (messageHandler != null) {
            try {
                messageHandler.handleEof();
            }
            catch (Throwable throwable) {}
        }
    }

    private void handleException(IOException e) {
        MessageHandler messageHandler = this.messageHandler;
        if (messageHandler != null) {
            try {
                messageHandler.handleException(e);
            }
            catch (Throwable throwable) {}
        }
    }

    private static enum ReadState {
        LENGTH,
        BODY,
        EOF;

    }
}

