/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.jboss.xnio.Pool;

public final class Buffers {
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);

    private Buffers() {
    }

    public static <T extends Buffer> T flip(T buffer) {
        buffer.flip();
        return buffer;
    }

    public static <T extends Buffer> T clear(T buffer) {
        buffer.clear();
        return buffer;
    }

    public static <T extends Buffer> T limit(T buffer, int limit) {
        buffer.limit(limit);
        return buffer;
    }

    public static <T extends Buffer> T mark(T buffer) {
        buffer.mark();
        return buffer;
    }

    public static <T extends Buffer> T position(T buffer, int position) {
        buffer.position(position);
        return buffer;
    }

    public static <T extends Buffer> T reset(T buffer) {
        buffer.reset();
        return buffer;
    }

    public static <T extends Buffer> T rewind(T buffer) {
        buffer.rewind();
        return buffer;
    }

    public static ByteBuffer slice(ByteBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                ByteBuffer byteBuffer = buffer.slice();
                return byteBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            ByteBuffer byteBuffer = buffer.slice();
            return byteBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static ByteBuffer fill(ByteBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (byte)value);
            Buffers.skip(buffer, count);
        } else {
            int i = count;
            while (i > 0) {
                buffer.put((byte)value);
                --i;
            }
        }
        return buffer;
    }

    public static CharBuffer slice(CharBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                CharBuffer charBuffer = buffer.slice();
                return charBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            CharBuffer charBuffer = buffer.slice();
            return charBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static CharBuffer fill(CharBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (char)value);
            Buffers.skip(buffer, count);
        } else {
            int i = count;
            while (i > 0) {
                buffer.put((char)value);
                --i;
            }
        }
        return buffer;
    }

    public static ShortBuffer slice(ShortBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                ShortBuffer shortBuffer = buffer.slice();
                return shortBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            ShortBuffer shortBuffer = buffer.slice();
            return shortBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static ShortBuffer fill(ShortBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (short)value);
            Buffers.skip(buffer, count);
        } else {
            int i = count;
            while (i > 0) {
                buffer.put((short)value);
                --i;
            }
        }
        return buffer;
    }

    public static IntBuffer slice(IntBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                IntBuffer intBuffer = buffer.slice();
                return intBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            IntBuffer intBuffer = buffer.slice();
            return intBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static IntBuffer fill(IntBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), value);
            Buffers.skip(buffer, count);
        } else {
            int i = count;
            while (i > 0) {
                buffer.put(value);
                --i;
            }
        }
        return buffer;
    }

    public static LongBuffer slice(LongBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                LongBuffer longBuffer = buffer.slice();
                return longBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            LongBuffer longBuffer = buffer.slice();
            return longBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static LongBuffer fill(LongBuffer buffer, long value, int count) {
        if (count > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), value);
            Buffers.skip(buffer, count);
        } else {
            int i = count;
            while (i > 0) {
                buffer.put(value);
                --i;
            }
        }
        return buffer;
    }

    public static <T extends Buffer> T skip(T buffer, int cnt) {
        if (cnt < 0) {
            throw new IllegalArgumentException();
        }
        if (cnt > buffer.remaining()) {
            throw new BufferUnderflowException();
        }
        buffer.position(buffer.position() + cnt);
        return buffer;
    }

    public static <T extends Buffer> T unget(T buffer, int cnt) {
        if (cnt < 0) {
            throw new IllegalArgumentException();
        }
        if (cnt > buffer.position()) {
            throw new BufferUnderflowException();
        }
        buffer.position(buffer.position() - cnt);
        return buffer;
    }

    public static byte[] take(ByteBuffer buffer, int cnt) {
        byte[] bytes = new byte[cnt];
        buffer.get(bytes);
        return bytes;
    }

    public static char[] take(CharBuffer buffer, int cnt) {
        char[] chars = new char[cnt];
        buffer.get(chars);
        return chars;
    }

    public static short[] take(ShortBuffer buffer, int cnt) {
        short[] shorts = new short[cnt];
        buffer.get(shorts);
        return shorts;
    }

    public static int[] take(IntBuffer buffer, int cnt) {
        int[] ints = new int[cnt];
        buffer.get(ints);
        return ints;
    }

    public static long[] take(LongBuffer buffer, int cnt) {
        long[] longs = new long[cnt];
        buffer.get(longs);
        return longs;
    }

    public static Object createDumper(final ByteBuffer buffer, final int indent, final int columns) {
        return new Object(){

            public String toString() {
                StringBuilder b = new StringBuilder();
                try {
                    Buffers.dump(buffer, (Appendable)b, indent, columns);
                }
                catch (IOException iOException) {}
                return b.toString();
            }
        };
    }

    public static void dump(ByteBuffer buffer, Appendable dest, int indent, int columns) throws IOException {
        int pos = buffer.position();
        int remaining = buffer.remaining();
        int rowLength = 8 << columns - 1;
        int n = Math.max(Integer.toString(buffer.remaining(), 16).length(), 4);
        int idx = 0;
        while (idx < remaining) {
            int i = 0;
            while (i < indent) {
                dest.append(' ');
                ++i;
            }
            String s = Integer.toString(idx, 16);
            int i2 = n - s.length();
            while (i2 > 0) {
                dest.append('0');
                --i2;
            }
            dest.append(s);
            dest.append(" - ");
            Buffers.appendHexRow(buffer, dest, pos + idx, columns);
            Buffers.appendTextRow(buffer, dest, pos + idx, columns);
            dest.append('\n');
            idx += rowLength;
        }
    }

    private static void appendHexRow(ByteBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        int c = 0;
        while (c < columns) {
            int i = 0;
            while (i < 8) {
                if (pos >= limit) {
                    dest.append("  ");
                } else {
                    int v = buffer.get(pos++) & 0xFF;
                    String hexVal = Integer.toString(v, 16);
                    if (v < 16) {
                        dest.append('0');
                    }
                    dest.append(hexVal);
                }
                dest.append(' ');
                ++i;
            }
            dest.append(' ');
            dest.append(' ');
            ++c;
        }
    }

    private static void appendTextRow(ByteBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        dest.append('[');
        dest.append(' ');
        int c = 0;
        while (c < columns) {
            int i = 0;
            while (i < 8) {
                char v;
                if (pos >= limit) {
                    dest.append(' ');
                } else if (Character.isISOControl(v = (char)(buffer.get(pos++) & 0xFF))) {
                    dest.append('.');
                } else {
                    dest.append(v);
                }
                ++i;
            }
            dest.append(' ');
            ++c;
        }
        dest.append(']');
    }

    public static Object createDumper(final CharBuffer buffer, final int indent, final int columns) {
        return new Object(){

            public String toString() {
                StringBuilder b = new StringBuilder();
                try {
                    Buffers.dump(buffer, (Appendable)b, indent, columns);
                }
                catch (IOException iOException) {}
                return b.toString();
            }
        };
    }

    public static void dump(CharBuffer buffer, Appendable dest, int indent, int columns) throws IOException {
        int pos = buffer.position();
        int remaining = buffer.remaining();
        int rowLength = 8 << columns - 1;
        int n = Math.max(Integer.toString(buffer.remaining(), 16).length(), 4);
        int idx = 0;
        while (idx < remaining) {
            int i = 0;
            while (i < indent) {
                dest.append(' ');
                ++i;
            }
            String s = Integer.toString(idx, 16);
            int i2 = n - s.length();
            while (i2 > 0) {
                dest.append('0');
                --i2;
            }
            dest.append(s);
            dest.append(" - ");
            Buffers.appendHexRow(buffer, dest, pos + idx, columns);
            Buffers.appendTextRow(buffer, dest, pos + idx, columns);
            dest.append('\n');
            idx += rowLength;
        }
    }

    private static void appendHexRow(CharBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        int c = 0;
        while (c < columns) {
            int i = 0;
            while (i < 8) {
                if (pos >= limit) {
                    dest.append("  ");
                } else {
                    char v = buffer.get(pos++);
                    String hexVal = Integer.toString(v, 16);
                    dest.append("0000".substring(hexVal.length()));
                    dest.append(hexVal);
                }
                dest.append(' ');
                ++i;
            }
            dest.append(' ');
            dest.append(' ');
            ++c;
        }
    }

    private static void appendTextRow(CharBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        dest.append('[');
        dest.append(' ');
        int c = 0;
        while (c < columns) {
            int i = 0;
            while (i < 8) {
                char v;
                if (pos >= limit) {
                    dest.append(' ');
                } else if (Character.isISOControl(v = buffer.get(pos++)) || Character.isHighSurrogate(v) || Character.isLowSurrogate(v)) {
                    dest.append('.');
                } else {
                    dest.append(v);
                }
                ++i;
            }
            dest.append(' ');
            ++c;
        }
        dest.append(']');
    }

    public static Pool<ByteBuffer> createHeapByteBufferAllocator(final int size) {
        return new Pool<ByteBuffer>(){

            @Override
            public ByteBuffer allocate() {
                return ByteBuffer.allocate(size);
            }

            @Override
            public void free(ByteBuffer buffer) {
            }

            @Override
            public void discard(ByteBuffer resource) {
            }
        };
    }

    public static boolean hasRemaining(Buffer[] buffers, int offs, int len) {
        int i = 0;
        while (i < len) {
            if (buffers[i + offs].hasRemaining()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasRemaining(Buffer[] buffers) {
        return Buffers.hasRemaining(buffers, 0, buffers.length);
    }

    public static long remaining(Buffer[] buffers, int offs, int len) {
        long t = 0L;
        int i = 0;
        while (i < len) {
            t += (long)buffers[i + offs].remaining();
            ++i;
        }
        return t;
    }

    public static long remaining(Buffer[] buffers) {
        return Buffers.remaining(buffers, 0, buffers.length);
    }

    public static long put(ByteBuffer[] dsts, int doffs, int dlen, ByteBuffer src) {
        long t = 0L;
        int i = 0;
        while (i < dlen) {
            ByteBuffer buffer = dsts[i + doffs];
            int dr = buffer.remaining();
            if (dr != 0) {
                if (dr < src.remaining()) {
                    buffer.put(Buffers.slice(src, dr));
                    t += (long)dr;
                } else {
                    buffer.put(src);
                    return t += (long)dr;
                }
            }
            ++i;
        }
        return t;
    }

    public static ByteBuffer putModifiedUtf8(ByteBuffer dest, String orig) throws BufferOverflowException {
        char[] chars;
        char[] cArray = chars = orig.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c > '\u0000' && c <= '\u007f') {
                dest.put((byte)c);
            } else if (c <= '\u07ff') {
                dest.put((byte)(0xC0 | 0x1F & c >> 6));
                dest.put((byte)(0x80 | 0x3F & c));
            } else {
                dest.put((byte)(0xE0 | 0xF & c >> 12));
                dest.put((byte)(0x80 | 0x3F & c >> 6));
                dest.put((byte)(0x80 | 0x3F & c));
            }
            ++n2;
        }
        return dest;
    }

    public static String getModifiedUtf8Z(ByteBuffer src) throws BufferUnderflowException {
        StringBuilder builder = new StringBuilder();
        int ch;
        while ((ch = Buffers.readUTFChar(src)) != -1) {
            builder.append((char)ch);
        }
        return builder.toString();
    }

    public static String getModifiedUtf8(ByteBuffer src) throws BufferUnderflowException {
        StringBuilder builder = new StringBuilder();
        while (src.hasRemaining()) {
            int ch = Buffers.readUTFChar(src);
            if (ch == -1) {
                builder.append('\u0000');
                continue;
            }
            builder.append((char)ch);
        }
        return builder.toString();
    }

    private static int readUTFChar(ByteBuffer src) throws BufferUnderflowException {
        int a = src.get() & 0xFF;
        if (a == 0) {
            return -1;
        }
        if (a < 128) {
            return (char)a;
        }
        if (a < 192) {
            return 63;
        }
        if (a < 224) {
            int b = src.get() & 0xFF;
            if ((b & 0xC0) != 128) {
                return 63;
            }
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        if (a < 240) {
            int b = src.get() & 0xFF;
            if ((b & 0xC0) != 128) {
                return 63;
            }
            int c = src.get() & 0xFF;
            if ((c & 0xC0) != 128) {
                return 63;
            }
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        return 63;
    }
}

